/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc;

import com.dbeaver.jdbc.base.AbstractJdbcResultSetMetaData;
import com.dbeaver.jdbc.base.AbstractJdbcStatement;
import com.dbeaver.jdbc.odbc.JdbcOdbcStatement;
import com.dbeaver.jdbc.odbc.bridge.OdbcLibrary;
import com.dbeaver.jdbc.odbc.bridge.util.OdbcException;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.ShortByReference;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.IntStream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class JdbcOdbcResultSetMetaData
extends AbstractJdbcResultSetMetaData<JdbcOdbcStatement> {
    private final Map<String, String> aliases;
    private final Map<String, Integer> names;
    private final Map<String, Integer> labels;
    private final int[] columns;

    public JdbcOdbcResultSetMetaData(@NotNull JdbcOdbcStatement statement, @Nullable Map<String, String> aliases, @Nullable int[] columns) throws SQLException {
        super((AbstractJdbcStatement)statement);
        ShortByReference count = new ShortByReference();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLNumResultCols(statement.getHandle(), count), statement.getHandle());
        if (columns == null) {
            columns = IntStream.rangeClosed(1, count.getValue()).toArray();
        }
        this.aliases = aliases;
        this.columns = columns;
        this.names = new HashMap<String, Integer>();
        this.labels = new HashMap<String, Integer>();
        int[] nArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            int column = nArray[n2];
            this.names.put(this.getStringAttribute(statement, column, (short)1011).toUpperCase(Locale.ROOT), column);
            this.labels.put(this.getStringAttribute(statement, column, (short)18).toUpperCase(Locale.ROOT), column);
            ++n2;
        }
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    @NotNull
    public String getColumnLabel(int column) throws SQLException {
        return this.getStringAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)18);
    }

    @NotNull
    public String getColumnName(int column) throws SQLException {
        String name = this.getStringAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)1011);
        return this.aliases != null ? this.aliases.getOrDefault(name, name) : name;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getNumericAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)1003);
    }

    public int getPrecision(int column) throws SQLException {
        return this.getNumericAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)1005);
    }

    public int getScale(int column) throws SQLException {
        return this.getNumericAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)1006);
    }

    public int getColumnType(int column) throws SQLException {
        String typeName = this.getColumnTypeName(column);
        int typeId = this.getNumericAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)1002);
        if (typeId == 9 && typeName.equalsIgnoreCase("timestamp")) {
            return 11;
        }
        return typeId;
    }

    public String getColumnTypeName(int column) throws SQLException {
        return this.getStringAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)14);
    }

    public String getCatalogName(int column) throws SQLException {
        return this.getStringAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)17);
    }

    public String getSchemaName(int column) throws SQLException {
        return this.getStringAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)16);
    }

    public String getTableName(int column) throws SQLException {
        return this.getStringAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)15);
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return this.getBooleanAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)11);
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        return this.getBooleanAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)12);
    }

    public boolean isSearchable(int column) throws SQLException {
        return this.getBooleanAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)13);
    }

    public boolean isCurrency(int column) throws SQLException {
        return this.getBooleanAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)9);
    }

    public int isNullable(int column) throws SQLException {
        return this.getBooleanAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)1008) ? 1 : 0;
    }

    public boolean isSigned(int column) throws SQLException {
        return !this.getBooleanAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)8);
    }

    public boolean isReadOnly(int column) throws SQLException {
        return !this.getBooleanAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)10);
    }

    public boolean isWritable(int column) throws SQLException {
        return this.getBooleanAttribute((JdbcOdbcStatement)this.statement, this.getColumnIndex(column), (short)10);
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }

    public int findColumn(@NotNull String columnLabel) throws SQLException {
        String label = columnLabel.toUpperCase(Locale.ROOT);
        Integer index = this.labels.get(label);
        if (index == null) {
            index = this.names.get(label);
        }
        if (index == null) {
            throw new SQLException("Column '" + columnLabel + "' is not present in the result set meta data");
        }
        return index;
    }

    private int getColumnIndex(int index) throws SQLException {
        if (index <= 0 || index > this.columns.length) {
            throw new SQLException("Column " + index + " out of bounds [1, " + this.columns.length + "]");
        }
        return this.columns[index - 1];
    }

    @NotNull
    private String getStringAttribute(@NotNull JdbcOdbcStatement stmt, int column, short attribute) throws SQLException {
        stmt.ensureOpen();
        Throwable throwable = null;
        Object var5_6 = null;
        try (Memory buffer = new Memory(1024L);){
            OdbcException.check(OdbcLibrary.INSTANCE.SQLColAttributeW(stmt.getHandle(), (short)column, attribute, (Pointer)buffer, (short)(buffer.size() - 1L), null, null), stmt.getHandle());
            return buffer.getWideString(0L);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int getNumericAttribute(@NotNull JdbcOdbcStatement stmt, int column, short attribute) throws SQLException {
        stmt.ensureOpen();
        LongByReference value = new LongByReference();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLColAttributeW(stmt.getHandle(), (short)column, attribute, null, (short)0, null, value), stmt.getHandle());
        return (int)value.getValue();
    }

    private boolean getBooleanAttribute(@NotNull JdbcOdbcStatement stmt, int column, short attribute) throws SQLException {
        return this.getNumericAttribute(stmt, column, attribute) == 1;
    }
}

