/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc;

import com.dbeaver.jdbc.odbc.JdbcOdbcConnection;
import com.dbeaver.jdbc.odbc.JdbcOdbcResultSet;
import com.dbeaver.jdbc.odbc.JdbcOdbcResultSetMetaData;
import com.dbeaver.jdbc.odbc.JdbcOdbcStatement;
import com.dbeaver.jdbc.odbc.bridge.OdbcLibrary;
import com.dbeaver.jdbc.odbc.bridge.struct.OdbcDate;
import com.dbeaver.jdbc.odbc.bridge.struct.OdbcTime;
import com.dbeaver.jdbc.odbc.bridge.struct.OdbcTimestamp;
import com.dbeaver.jdbc.odbc.bridge.util.OdbcException;
import com.dbeaver.jdbc.odbc.bridge.util.OdbcUtil;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.ShortByReference;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class JdbcOdbcPreparedStatement
extends JdbcOdbcStatement
implements PreparedStatement {
    public JdbcOdbcPreparedStatement(@NotNull JdbcOdbcConnection connection, @NotNull String sql) throws SQLException {
        super(connection);
        OdbcException.check(this.getResource(), OdbcLibrary.INSTANCE.SQLPrepareW(this.getHandle(), sql, -3));
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.execute()) {
            return this.resultSet;
        }
        throw new SQLException("No result set was produced");
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            return this.getUpdateCount();
        }
        throw new SQLException("No update count was produced");
    }

    @Override
    protected int executeUpdate(@NotNull String sql, @Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys) throws SQLException {
        throw OdbcUtil.notSupported();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.executeUpdate();
    }

    @Override
    public boolean execute() throws SQLException {
        short rc;
        this.ensureOpen();
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        if ((rc = OdbcLibrary.INSTANCE.SQLExecute(this.getHandle())) != 100) {
            OdbcException.check(this.getResource(), rc);
        }
        if (this.getColumnCount() > 0) {
            this.resultSet = new JdbcOdbcResultSet(this);
            return true;
        }
        return false;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.ensureOpen();
        OdbcException.check(this.getResource(), OdbcLibrary.INSTANCE.SQLBindParameter(this.getHandle(), (short)parameterIndex, (short)1, (short)sqlType, (short)sqlType, 0L, (short)0, (Pointer)null, 0L, new LongByReference(-1L)));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setByte(parameterIndex, (byte)(x ? 1 : 0));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ensureOpen();
        OdbcException.check(this.getResource(), OdbcLibrary.INSTANCE.SQLBindParameter(this.getHandle(), (short)parameterIndex, (short)1, (short)-7, (short)4, 0L, (short)0, (ByReference)new ByteByReference(x), 0L, null));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ensureOpen();
        OdbcException.check(this.getResource(), OdbcLibrary.INSTANCE.SQLBindParameter(this.getHandle(), (short)parameterIndex, (short)1, (short)-15, (short)4, 0L, (short)0, (ByReference)new ShortByReference(x), 0L, null));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ensureOpen();
        OdbcException.check(this.getResource(), OdbcLibrary.INSTANCE.SQLBindParameter(this.getHandle(), (short)parameterIndex, (short)1, (short)-16, (short)4, 0L, (short)0, (ByReference)new IntByReference(x), 0L, null));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ensureOpen();
        OdbcException.check(this.getResource(), OdbcLibrary.INSTANCE.SQLBindParameter(this.getHandle(), (short)parameterIndex, (short)1, (short)-27, (short)4, 0L, (short)0, (ByReference)new LongByReference(x), 0L, null));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ensureOpen();
        OdbcException.check(this.getResource(), OdbcLibrary.INSTANCE.SQLBindParameter(this.getHandle(), (short)parameterIndex, (short)1, (short)6, (short)3, 0L, (short)0, (ByReference)new FloatByReference(x), 0L, null));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ensureOpen();
        OdbcException.check(this.getResource(), OdbcLibrary.INSTANCE.SQLBindParameter(this.getHandle(), (short)parameterIndex, (short)1, (short)8, (short)3, 0L, (short)0, (ByReference)new DoubleByReference(x), 0L, null));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ensureOpen();
        OdbcException.check(this.getResource(), OdbcLibrary.INSTANCE.SQLBindParameter(this.getHandle(), (short)parameterIndex, (short)1, (short)-8, (short)12, (long)x.length(), (short)0, x, (long)x.length() * (long)Native.WCHAR_SIZE + 1L, new LongByReference(-3L)));
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.ensureOpen();
        cal.setTime(x);
        OdbcDate.ByReference value = new OdbcDate.ByReference();
        value.year = (short)cal.get(1);
        value.month = (short)(cal.get(2) + 1);
        value.day = (short)cal.get(5);
        OdbcException.check(this.getResource(), OdbcLibrary.INSTANCE.SQLBindParameter(this.getHandle(), (short)parameterIndex, (short)1, (short)9, (short)9, 0L, (short)0, value, 0L, null));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.ensureOpen();
        cal.setTime(x);
        OdbcTime.ByReference value = new OdbcTime.ByReference();
        value.hour = (short)cal.get(11);
        value.minute = (short)cal.get(12);
        value.second = (short)cal.get(13);
        OdbcException.check(this.getResource(), OdbcLibrary.INSTANCE.SQLBindParameter(this.getHandle(), (short)parameterIndex, (short)1, (short)10, (short)10, 0L, (short)0, value, 0L, null));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ensureOpen();
        cal.setTime(x);
        OdbcTimestamp.ByReference value = new OdbcTimestamp.ByReference();
        value.date.year = (short)cal.get(1);
        value.date.month = (short)(cal.get(2) + 1);
        value.date.day = (short)cal.get(5);
        value.time.hour = (short)cal.get(11);
        value.time.minute = (short)cal.get(12);
        value.time.second = (short)cal.get(13);
        value.fraction = cal.get(14) * 1000000;
        OdbcException.check(this.getResource(), OdbcLibrary.INSTANCE.SQLBindParameter(this.getHandle(), (short)parameterIndex, (short)1, (short)11, (short)11, 0L, (short)0, value, 0L, null));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new JdbcOdbcResultSetMetaData(this, null, null);
    }
}

