/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.odbc;

import com.dbeaver.jdbc.base.AbstractJdbcConnection;
import com.dbeaver.jdbc.odbc.JdbcOdbcBridgeDriver;
import com.dbeaver.jdbc.odbc.JdbcOdbcDatabaseMetaData;
import com.dbeaver.jdbc.odbc.JdbcOdbcPreparedStatement;
import com.dbeaver.jdbc.odbc.JdbcOdbcStatement;
import com.dbeaver.jdbc.odbc.bridge.OdbcHandle;
import com.dbeaver.jdbc.odbc.bridge.OdbcLibrary;
import com.dbeaver.jdbc.odbc.bridge.OdbcResource;
import com.dbeaver.jdbc.odbc.bridge.util.OdbcException;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.IntByReference;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Objects;
import java.util.Properties;
import org.jkiss.code.NotNull;

public class JdbcOdbcConnection
extends AbstractJdbcConnection {
    private final JdbcOdbcDatabaseMetaData metadata;
    private final OdbcResource<OdbcHandle.Connection> resource;

    public JdbcOdbcConnection(@NotNull OdbcResource<OdbcHandle.Environment> parent, @NotNull String url) throws SQLException {
        this.resource = new OdbcResource<OdbcHandle.Connection>(parent, parent.getHandle().newConnectionHandle());
        OdbcException.check(OdbcLibrary.INSTANCE.SQLDriverConnectW(this.getHandle(), null, url, (short)-3, null, (short)0, null, (short)0), this.getHandle());
        this.metadata = new JdbcOdbcDatabaseMetaData(this, url);
        try {
            this.holdability = this.metadata.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.resource.addWarning(new SQLWarning("Unable to determine result set holdability", e));
        }
    }

    OdbcResource<OdbcHandle.Connection> getResource() {
        return this.resource;
    }

    OdbcHandle.Connection getHandle() {
        return this.resource.getHandle();
    }

    private void ensureOpen() throws SQLException {
        this.resource.ensureOpen();
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    public String nativeSQL(String sql) throws SQLException {
        this.ensureOpen();
        IntByReference stringLength = new IntByReference();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLNativeSqlW(this.getHandle(), sql, -3, null, 0, stringLength), this.getHandle());
        Throwable throwable = null;
        Object var4_5 = null;
        try (Memory string = new Memory((long)stringLength.getValue() * (long)Native.WCHAR_SIZE + 1L);){
            OdbcException.check(OdbcLibrary.INSTANCE.SQLNativeSqlW(this.getHandle(), sql, -3, (Pointer)string, stringLength.getValue(), null), this.getHandle());
            return string.getWideString(0L);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.setAttrInt((short)102, autoCommit ? 1 : 0);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.getAttrInt((short)102) == 1;
    }

    public void commit() throws SQLException {
        this.ensureOpen();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLEndTran(this.getHandle().getType(), this.getHandle(), (short)0), this.getHandle());
    }

    public void rollback() throws SQLException {
        this.ensureOpen();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLEndTran(this.getHandle().getType(), this.getHandle(), (short)1), this.getHandle());
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureOpen();
        return this.metadata;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.setAttrInt((short)101, readOnly ? 1 : 0);
    }

    public boolean isReadOnly() throws SQLException {
        return this.getAttrInt((short)101) == 1;
    }

    public void setCatalog(String catalog) throws SQLException {
        this.setAttrString((short)109, Objects.requireNonNull(catalog, "catalog must not be null"));
    }

    public String getCatalog() throws SQLException {
        return this.getAttrString((short)109);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.setAttrInt((short)108, level);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.getAttrInt((short)108);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resource.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.resource.clearWarnings();
    }

    public void setHoldability(int holdability) throws SQLException {
        this.ensureOpen();
        if (holdability == 1 && this.metadata.supportsOpenCursorsAcrossCommit()) {
            this.holdability = holdability;
        } else if (holdability == 2) {
            this.holdability = holdability;
        } else {
            throw new SQLException("Unsupported holdability: " + holdability);
        }
    }

    public int getHoldability() throws SQLException {
        this.ensureOpen();
        return this.holdability;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLException("Unsupported result set type: " + resultSetType);
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Unsupported result set concurrency: " + resultSetType);
        }
        if (resultSetHoldability != 1 && resultSetHoldability != 2) {
            throw new SQLException("Unsupported result set holdability: " + resultSetType);
        }
        JdbcOdbcStatement dbStat = new JdbcOdbcStatement(this);
        return dbStat;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLException("Unsupported result set type: " + resultSetType);
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Unsupported result set concurrency: " + resultSetType);
        }
        if (resultSetHoldability != 1 && resultSetHoldability != 2) {
            throw new SQLException("Unsupported result set holdability: " + resultSetType);
        }
        return new JdbcOdbcPreparedStatement(this, Objects.requireNonNull(sql, "sql must not be null"));
    }

    public void setClientInfo(String name, String value) {
    }

    public void setClientInfo(Properties properties) {
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            OdbcException.check(OdbcLibrary.INSTANCE.SQLDisconnect(this.getHandle()), this.getHandle());
            this.resource.close();
        }
        finally {
            JdbcOdbcBridgeDriver.disconnect(this);
        }
    }

    public boolean isClosed() throws SQLException {
        return this.resource.isClosed();
    }

    @NotNull
    private String getAttrString(short attribute) throws SQLException {
        this.ensureOpen();
        IntByReference stringLength = new IntByReference();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLGetConnectAttrW(this.getHandle(), (int)attribute, (ByReference)null, 0, stringLength), this.getHandle());
        Throwable throwable = null;
        Object var4_5 = null;
        try (Memory string = new Memory((long)stringLength.getValue() * (long)Native.WCHAR_SIZE + 1L);){
            OdbcException.check(OdbcLibrary.INSTANCE.SQLGetConnectAttrW(this.getHandle(), (int)attribute, (Pointer)string, stringLength.getValue(), null), this.getHandle());
            return string.getWideString(0L);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int getAttrInt(short attribute) throws SQLException {
        this.ensureOpen();
        IntByReference value = new IntByReference();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLGetConnectAttrW(this.getHandle(), (int)attribute, (ByReference)value, 0, null), this.getHandle());
        return value.getValue();
    }

    private void setAttrString(short attribute, @NotNull String value) throws SQLException {
        this.ensureOpen();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLSetConnectAttrW(this.getHandle(), (int)attribute, value, -3), this.getHandle());
    }

    private void setAttrInt(short attribute, int value) throws SQLException {
        this.ensureOpen();
        OdbcException.check(OdbcLibrary.INSTANCE.SQLSetConnectAttrW(this.getHandle(), (int)attribute, Pointer.createConstant((int)value), 0), this.getHandle());
    }
}

