/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.sort;

import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.sort.SearchSortField;
import com.couchbase.client.java.search.sort.SearchSortGeoDistance;
import com.couchbase.client.java.search.sort.SearchSortId;
import com.couchbase.client.java.search.sort.SearchSortScore;

public abstract class SearchSort {
    private boolean descending = false;

    protected SearchSort() {
    }

    protected abstract String identifier();

    public void injectParams(JsonObject queryJson) {
        queryJson.put("by", this.identifier());
        if (this.descending) {
            queryJson.put("desc", true);
        }
    }

    public SearchSort descending(boolean descending) {
        this.descending = descending;
        return this;
    }

    public static SearchSortId sortId() {
        return new SearchSortId();
    }

    public static SearchSortScore sortScore() {
        return new SearchSortScore();
    }

    public static SearchSortField sortField(String field) {
        return new SearchSortField(field);
    }

    public static SearchSortGeoDistance sortGeoDistance(double locationLon, double locationLat, String field) {
        return new SearchSortGeoDistance(locationLon, locationLat, field);
    }
}

