/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.queries.AbstractFtsQuery;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class GeoDistanceQuery
extends AbstractFtsQuery {
    private final double locationLon;
    private final double locationLat;
    private final String distance;
    private String field;

    public GeoDistanceQuery(double locationLon, double locationLat, String distance) {
        this.locationLon = locationLon;
        this.locationLat = locationLat;
        this.distance = distance;
    }

    public GeoDistanceQuery field(String field) {
        this.field = field;
        return this;
    }

    @Override
    public GeoDistanceQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        input.put("location", JsonArray.from(this.locationLon, this.locationLat));
        input.put("distance", this.distance);
        if (this.field != null) {
            input.put("field", this.field);
        }
    }
}

