/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.path.index;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.query.dsl.element.IndexNamesElement;
import com.couchbase.client.java.query.dsl.path.AbstractPath;
import com.couchbase.client.java.query.dsl.path.index.DefaultUsingPath;
import com.couchbase.client.java.query.dsl.path.index.IndexNamesPath;
import com.couchbase.client.java.query.dsl.path.index.UsingPath;
import java.util.List;

@InterfaceStability.Experimental
@InterfaceAudience.Private
public class DefaultIndexNamesPath
extends AbstractPath
implements IndexNamesPath {
    protected DefaultIndexNamesPath(AbstractPath parent) {
        super(parent);
    }

    @Override
    public UsingPath indexes(String indexName, String ... indexNames) {
        this.element(new IndexNamesElement(indexName, indexNames));
        return new DefaultUsingPath(this);
    }

    @Override
    public UsingPath indexes(List<String> indexNames) {
        if (indexNames.isEmpty()) {
            throw new IllegalArgumentException("indexNames must have at least one name");
        }
        String first = indexNames.get(0);
        if (indexNames.size() > 1) {
            String[] others = indexNames.subList(1, indexNames.size()).toArray(new String[indexNames.size() - 1]);
            this.element(new IndexNamesElement(first, others));
        } else {
            this.element(new IndexNamesElement(first, new String[0]));
        }
        return new DefaultUsingPath(this);
    }

    @Override
    public UsingPath primary() {
        this.element(new IndexNamesElement("#primary", new String[0]));
        return new DefaultUsingPath(this);
    }
}

