/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis;

import com.dbeaver.db.redis.exec.RedisSession;
import com.dbeaver.db.redis.model.RedisDataSource;
import com.dbeaver.db.redis.model.RedisDatabase;
import com.dbeaver.db.redis.model.RedisKey;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.commands.KeyCommands;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

public class RedisUtils {
    private static final Log log = Log.getLog(RedisUtils.class);
    public static final List<String> NULL_SUB_KEYS = Collections.emptyList();
    public static final String ZERO_SCAN_CURSOR = "0";

    public static Map<String, Object> parseInfo(String info) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader in = new BufferedReader(new StringReader(info));){
                String line;
                while ((line = in.readLine()) != null) {
                    if (line.isEmpty()) {
                        break;
                    }
                    int divPos = line.indexOf(58);
                    if (divPos == -1) continue;
                    String name = line.substring(0, divPos);
                    String value = line.substring(divPos + 1);
                    map.put(name, value);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return map;
    }

    public static List<RedisKey> getKeys(@NotNull DBRProgressMonitor monitor, @NotNull RedisDatabase database, @Nullable RedisKey parent, @Nullable String pattern, boolean showHierarchy) throws DBCException {
        int maxPatternRead;
        RedisDataSource dataSource = database.getDataSource();
        DBPConnectionConfiguration props = database.getDataSource().getContainer().getConnectionConfiguration();
        String divider = database.getDataSource().getKeyDivider();
        if (parent != null && !showHierarchy) {
            return Collections.emptyList();
        }
        int maxKeys = CommonUtils.toInt((Object)props.getProviderProperty("@dbeaver-redis.key.read.count"), (int)10000);
        if (maxKeys <= 0) {
            maxKeys = 10000;
        }
        if ((maxPatternRead = CommonUtils.toInt((Object)props.getProviderProperty("@dbeaver-redis.pattern.read.count"), (int)100000)) <= 0) {
            maxPatternRead = 100000;
        }
        monitor.beginTask("Read keys", 1);
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            RedisSession session = (RedisSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)database, (String)"Read keys");
            try {
                RedisUtils.selectCurDatabase(session, database);
                ScanParams params = new ScanParams();
                String cursorPattern = null;
                String parentName = null;
                if (parent != null) {
                    parentName = parent.getFullyQualifiedName(DBPEvaluationContext.DML);
                    cursorPattern = String.valueOf(parentName) + divider;
                    cursorPattern = !CommonUtils.isEmpty((String)pattern) ? String.valueOf(cursorPattern) + pattern : String.valueOf(cursorPattern) + "*";
                } else if (!CommonUtils.isEmpty((String)pattern)) {
                    cursorPattern = pattern;
                }
                if (cursorPattern != null) {
                    params.match(cursorPattern);
                    params.count(Integer.valueOf(maxPatternRead));
                } else {
                    params.count(Integer.valueOf(maxKeys));
                }
                KeyReadInfo readInfo = new KeyReadInfo(maxKeys, parent, parentName, divider, showHierarchy);
                String cursorId = ZERO_SCAN_CURSOR;
                log.debug((Object)("Read Redis keys " + (cursorPattern == null ? "(all)" : cursorPattern)));
                while (!monitor.isCanceled()) {
                    ScanResult scanResult = null;
                    if (!dataSource.isUseCluster()) {
                        scanResult = session.getCommands(KeyCommands.class).scan(cursorId, params);
                        if (scanResult == null) break;
                        RedisUtils.fetchScanResult(database, (ScanResult<String>)scanResult, readInfo);
                        if (readInfo.totalKeysRead >= maxKeys) {
                            log.debug((Object)("\tMaximum key number exceeded (" + maxKeys + ")"));
                            break;
                        }
                        if (!scanResult.getCursor().equals(ZERO_SCAN_CURSOR)) continue;
                        log.debug((Object)"\tFetch ended");
                        break;
                    }
                    boolean hasMoreData = false;
                    Map clusterNodes = ((JedisCluster)dataSource.getClient()).getClusterNodes();
                    for (Map.Entry pool : clusterNodes.entrySet()) {
                        Throwable throwable2 = null;
                        Object var24_29 = null;
                        try (Jedis jedis = new Jedis(((ConnectionPool)pool.getValue()).getResource());){
                            scanResult = jedis.scan(cursorId, params);
                            if (scanResult == null) continue;
                            RedisUtils.fetchScanResult(database, (ScanResult<String>)scanResult, readInfo);
                            if (!scanResult.getCursor().equals(ZERO_SCAN_CURSOR)) {
                                hasMoreData = true;
                            }
                            if (readInfo.totalKeysRead < maxKeys) continue;
                            log.debug((Object)("\tMaximum key number exceeded in cluster (" + maxKeys + ")"));
                            break;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    if (!hasMoreData) break;
                }
                boolean readAll = readInfo.totalKeysRead < maxKeys;
                ArrayList<RedisKey> arrayList = new ArrayList<RedisKey>(readInfo.keyMap.values());
                if (session != null) {
                    session.close();
                }
                return arrayList;
            }
            catch (Throwable throwable4) {
                try {
                    try {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    throw new DBCException("Error scanning Redis keys", e);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void fetchScanResult(@NotNull RedisDatabase database, ScanResult<String> scanResult, KeyReadInfo readInfo) {
        List scanKeys = scanResult.getResult();
        for (String keyName : scanKeys) {
            RedisKey key;
            if (readInfo.totalKeysRead >= readInfo.maxKeys) break;
            ++readInfo.totalKeysRead;
            if (readInfo.parent != null && keyName.startsWith(readInfo.parentName) && (keyName = keyName.substring(readInfo.parentName.length())).startsWith(readInfo.divider)) {
                keyName = keyName.substring(readInfo.divider.length());
            }
            int divPos = readInfo.showHierarchy ? keyName.indexOf(readInfo.divider) : -1;
            String subKeyName = null;
            if (divPos != -1) {
                subKeyName = keyName.substring(divPos + readInfo.divider.length());
                keyName = keyName.substring(0, divPos);
            }
            if ((key = readInfo.keyMap.get(keyName)) == null) {
                key = new RedisKey(database, readInfo.parent, keyName, divPos != -1);
                readInfo.keyMap.put(keyName, key);
            }
            if (subKeyName == null) continue;
            key.addSubKey(subKeyName, readInfo.divider);
        }
    }

    public static void selectCurDatabase(RedisSession session) {
        RedisUtils.selectCurDatabase(session, session.getExecutionContext().getDefaultCatalog());
    }

    public static void selectCurDatabase(RedisSession session, @Nullable RedisDatabase database) {
        if (database == null || database.getId() == 0 && database.getDataSource().getDatabases().size() < 2) {
            return;
        }
        UnifiedJedis jedisClient = session.getJedisClient();
        CommandArguments selCommand = new CommandArguments((ProtocolCommand)Protocol.Command.SELECT);
        selCommand.add((Object)Protocol.toByteArray((int)database.getId()));
        jedisClient.executeCommand(selCommand);
    }

    private static class KeyReadInfo {
        Map<String, RedisKey> keyMap = new LinkedHashMap<String, RedisKey>();
        int totalKeysRead = 0;
        int maxKeys;
        RedisKey parent;
        String parentName;
        String divider;
        boolean showHierarchy;

        public KeyReadInfo(int maxKeys, RedisKey parent, String parentName, String divider, boolean showHierarchy) {
            this.maxKeys = maxKeys;
            this.parent = parent;
            this.parentName = parentName;
            this.divider = divider;
            this.showHierarchy = showHierarchy;
        }
    }
}

