/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.odbc.model;

import com.dbeaver.db.odbc.model.OdbcDataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.GenericDataSourceProvider;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfigurationMigrator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;

public class OdbcDataSourceProvider
extends GenericDataSourceProvider
implements DBPConnectionConfigurationMigrator {
    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new OdbcDataSource(monitor, container, new GenericMetaModel(), (SQLDialect)new GenericSQLDialect());
    }

    public void migrateConfiguration(@NotNull DBPConnectionConfiguration oldConfiguration, @NotNull DBPConnectionConfiguration newConfiguration) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String[] stringArray = oldConfiguration.getDatabaseName().split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            String[] parts = attr.split("=");
            if (parts.length == 2) {
                String value = parts[1];
                if (value.startsWith("{") && value.endsWith("}")) {
                    value = value.substring(1, value.length() - 1);
                }
                properties.put(parts[0], value);
            } else {
                properties.put(parts[0], null);
            }
            ++n2;
        }
        if (OdbcDataSourceProvider.migrateProperty(properties, "dsn", arg_0 -> ((DBPConnectionConfiguration)newConfiguration).setDatabaseName(arg_0))) {
            newConfiguration.setProviderProperty("odbc-connection-mode", "dsn");
        } else {
            newConfiguration.setProviderProperty("odbc-connection-mode", "manual");
            OdbcDataSourceProvider.migrateProperty(properties, "server", arg_0 -> ((DBPConnectionConfiguration)newConfiguration).setHostName(arg_0));
            OdbcDataSourceProvider.migrateProperty(properties, "port", arg_0 -> ((DBPConnectionConfiguration)newConfiguration).setHostPort(arg_0));
            OdbcDataSourceProvider.migrateProperty(properties, "database", arg_0 -> ((DBPConnectionConfiguration)newConfiguration).setDatabaseName(arg_0));
        }
        OdbcDataSourceProvider.migrateProperty(properties, "driver", arg_0 -> ((DBPConnectionConfiguration)newConfiguration).setServerName(arg_0));
        OdbcDataSourceProvider.migrateProperty(properties, "uid", arg_0 -> ((DBPConnectionConfiguration)newConfiguration).setUserName(arg_0));
        OdbcDataSourceProvider.migrateProperty(properties, "pwd", arg_0 -> ((DBPConnectionConfiguration)newConfiguration).setUserPassword(arg_0));
        newConfiguration.setProperties(properties);
    }

    public boolean migrationRequired(@NotNull DBPConnectionConfiguration configuration) {
        return configuration.getProviderProperty("odbc-connection-mode") == null;
    }

    private static boolean migrateProperty(@NotNull Map<String, String> properties, @NotNull String name, @NotNull Consumer<String> setter) {
        setter.accept("");
        return properties.entrySet().removeIf(entry -> {
            if (((String)entry.getKey()).equalsIgnoreCase(name)) {
                if (entry.getValue() != null) {
                    setter.accept((String)entry.getValue());
                }
                return true;
            }
            return false;
        });
    }
}

