/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite;

import com.dbeaver.db.sqlite.SQLiteDataSourceExt;
import com.dbeaver.db.sqlite.model.SQLiteAttachedDatabase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SQLiteMetaModelExt
extends SQLiteMetaModel {
    public boolean isSystemSchema(GenericSchema schema) {
        return schema.getName().equals("temp");
    }

    @NotNull
    protected String getFullyQualifiedName(@NotNull GenericStructContainer genericStructContainer, String value) {
        return String.valueOf(genericStructContainer instanceof SQLiteAttachedDatabase ? String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)genericStructContainer)) + "." : "") + value;
    }

    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new SQLiteDataSourceExt(monitor, container, (GenericMetaModel)this);
    }

    public List<GenericSchema> loadSchemas(@NotNull JDBCSession session, @NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog) throws DBException {
        if (!CommonUtils.toBoolean((Object)dataSource.getContainer().getConnectionConfiguration().getProviderProperty("use-attached-databases"))) {
            return super.loadSchemas(session, dataSource, catalog);
        }
        String sql = "SELECT * from pragma_database_list";
        boolean schemaReadFailed = false;
        ArrayList<GenericSchema> result = new ArrayList<GenericSchema>();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (JDBCStatement dbStat = session.createStatement();){
                Throwable throwable2 = null;
                Object var11_15 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery(sql);){
                    while (dbResult.next()) {
                        int seq = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"seq");
                        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
                        String file = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"file");
                        SQLiteAttachedDatabase schema = new SQLiteAttachedDatabase(dataSource, catalog, name, seq, file);
                        result.add(schema);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            if (dataSource.discoverErrorType((Throwable)e) == DBPErrorAssistant.ErrorType.CONNECTION_LOST) {
                throw new DBException((Throwable)e, (DBPDataSource)dataSource);
            }
            schemaReadFailed = true;
        }
        if (schemaReadFailed) {
            return super.loadSchemas(session, dataSource, catalog);
        }
        return result;
    }

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT type AS TABLE_TYPE, name AS TABLE_NAME, tbl_name, rootpage FROM " + this.getFullyQualifiedName(owner, "sqlite_master") + " WHERE (type = 'table' OR type = 'view')" + (CommonUtils.isNotEmpty((String)objectName) || object != null ? " AND name LIKE ?" : ""));
        if (object != null || CommonUtils.isNotEmpty((String)objectName)) {
            dbStat.setString(1, JDBCUtils.escapeWildCards((JDBCSession)session, (String)(objectName == null ? object.getName() : objectName)));
        }
        return dbStat;
    }
}

