/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum ParameterMode {
    In(1, true, false),
    Inout(2, true, true),
    Out(4, false, true),
    Unknown(-1, false, false);

    private static final ParameterMode[] VALUES;
    private final int _value;
    private final boolean _isInput;
    private final boolean _isOutput;

    public static ParameterMode decode(int value) {
        if (Integer.bitCount(value) != 1) {
            return Unknown;
        }
        int ordinal = Integer.numberOfTrailingZeros(value);
        return ordinal >= 0 && ordinal < VALUES.length - 1 ? VALUES[ordinal] : Unknown;
    }

    public static String getDisplayName(int value) {
        return ParameterMode.decode(value).name() + '(' + value + ')';
    }

    private ParameterMode(int value, boolean isInput, boolean isOutput) {
        if (Integer.numberOfTrailingZeros(value) != this.ordinal() && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
        this._value = value;
        this._isInput = isInput;
        this._isOutput = isOutput;
    }

    public int getValue() {
        return this._value;
    }

    public boolean isInput() {
        return this._isInput;
    }

    public boolean isOutput() {
        return this._isOutput;
    }

    static {
        VALUES = ParameterMode.values();
    }
}

