/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.util.regex.Pattern;
import nl.knaw.dans.common.dbflib.AbstractDataValidator;
import nl.knaw.dans.common.dbflib.DataMismatchException;
import nl.knaw.dans.common.dbflib.DbfLibException;
import nl.knaw.dans.common.dbflib.Field;
import nl.knaw.dans.common.dbflib.Type;

class LogicalFormatValidator
extends AbstractDataValidator {
    private static final Pattern booleanPattern = Pattern.compile("[YNTF ]");

    LogicalFormatValidator(Field field) {
        super(field);
        assert (field.getType() == Type.LOGICAL) : "Can only be validator for LOGICAL fields";
    }

    @Override
    public void validate(Object typedObject) throws DbfLibException {
        if (typedObject instanceof Boolean) {
            return;
        }
        if (typedObject instanceof String) {
            String booleanString = (String)typedObject;
            if (!booleanPattern.matcher(booleanString).matches()) {
                throw new DataMismatchException("Boolean must be one of Y, N, T, F or a space");
            }
            return;
        }
        throw new DataMismatchException("Cannot write objects of type '" + typedObject.getClass().getName() + "' to a LOGICAL field");
    }
}

