/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.jalapeno.ObjectManager;
import com.jalapeno.tools.objects.ClassIterationTask;
import com.jalapeno.tools.objects.ant.NamedEntity;
import java.util.ArrayList;
import java.util.Map;

public class PopulateClassTask
extends ClassIterationTask {
    private ArrayList mPostProcessList = new ArrayList();
    private int mNumRootInstances = 10;
    private int mCorrelationFactor = 5;

    @Override
    protected void performOneAction(ObjectManager objectManager, Class clazz, Object object) throws Exception {
        int n = ((NamedEntity)object).getNumber();
        if (n < 0) {
            this.mPostProcessList.add(clazz);
            return;
        }
        n = objectManager.extentManager().populate(clazz, n);
        this.log("Class " + clazz.getName() + " populated with " + n + " instances.");
    }

    @Override
    protected void postAction(ObjectManager objectManager) throws Exception {
        if (this.mPostProcessList.isEmpty()) {
            return;
        }
        Map map = objectManager.extentManager().populate(this.mPostProcessList, this.mNumRootInstances, this.mCorrelationFactor);
        for (Map.Entry entry : map.entrySet()) {
            if ("TOTAL".equals(entry.getKey())) {
                this.log("Total populated instances: " + entry.getValue());
                continue;
            }
            this.log("Class " + entry.getKey() + " populated with " + entry.getValue() + " instances.");
        }
    }

    public NamedEntity createClass() {
        NamedEntity namedEntity = new NamedEntity();
        this.getClasses().add(namedEntity);
        return namedEntity;
    }

    public int getCorrelationFactor() {
        return this.mCorrelationFactor;
    }

    public void setCorrelationFactor(int n) {
        this.mCorrelationFactor = n;
    }

    public int getNumRootInstances() {
        return this.mNumRootInstances;
    }

    public void setNumRootInstances(int n) {
        this.mNumRootInstances = n;
    }
}

