/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.cache.ClassAnalizer;
import com.jalapeno.annotations.Access;
import com.jalapeno.annotations.CacheClass;
import com.jalapeno.annotations.CacheProperty;
import com.jalapeno.annotations.ClassParameter;
import com.jalapeno.annotations.ClassParameters;
import com.jalapeno.annotations.Collection;
import com.jalapeno.annotations.Embeddable;
import com.jalapeno.annotations.Extends;
import com.jalapeno.annotations.FetchType;
import com.jalapeno.annotations.ID;
import com.jalapeno.annotations.IDType;
import com.jalapeno.annotations.Implements;
import com.jalapeno.annotations.Index;
import com.jalapeno.annotations.Indices;
import com.jalapeno.annotations.Lob;
import com.jalapeno.annotations.LobType;
import com.jalapeno.annotations.ManyToOne;
import com.jalapeno.annotations.OneToMany;
import com.jalapeno.annotations.PropertyParameter;
import com.jalapeno.annotations.PropertyParameters;
import com.jalapeno.annotations.Queries;
import com.jalapeno.annotations.Query;
import com.jalapeno.annotations.Relationship;
import com.jalapeno.annotations.RelationshipType;
import com.jalapeno.annotations.Transient;
import com.jalapeno.annotations.Version;
import com.jalapeno.tools.objects.ClassMetadata;
import com.jalapeno.tools.objects.PropertyMetadata;
import com.jalapeno.tools.objects.RelationshipMetadata;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;

public class JalapenoAnnotationProcessor {
    static void processCacheClassAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        CacheClass cacheClass = clazz.getAnnotation(CacheClass.class);
        if (cacheClass != null) {
            classMetadata.setClassName(cacheClass.name());
            classMetadata.setSQLSchemaName(cacheClass.sqlSchemaName());
            classMetadata.setPackageName(cacheClass.packageName());
            classMetadata.setSQLTableName(cacheClass.sqlTableName());
            classMetadata.setJavaProjectionPackageName(cacheClass.javaProjectionPackageName());
            classMetadata.setJavaProjectionClassName(cacheClass.javaProjectionClassName());
            classMetadata.setPopulatable(cacheClass.populatable());
            classMetadata.setXMLSerializable(cacheClass.xmlSerializable());
        }
    }

    static boolean processPropertyAnnotation(Member member, PropertyMetadata propertyMetadata) {
        CacheProperty cacheProperty = null;
        if (member instanceof Field) {
            cacheProperty = ((Field)member).getAnnotation(CacheProperty.class);
        } else if (member instanceof Method) {
            cacheProperty = ((Method)member).getAnnotation(CacheProperty.class);
        }
        if (cacheProperty == null) {
            return false;
        }
        propertyMetadata.setName(cacheProperty.name());
        propertyMetadata.setType(cacheProperty.type());
        propertyMetadata.setSQLColumnName(cacheProperty.sqlColumnName());
        if (cacheProperty.required()) {
            propertyMetadata.setIsRequired();
        }
        return true;
    }

    static boolean processManyToOneAnnotation(Member member, PropertyMetadata propertyMetadata) {
        ManyToOne manyToOne = null;
        if (member instanceof Field) {
            manyToOne = ((Field)member).getAnnotation(ManyToOne.class);
        } else if (member instanceof Method) {
            manyToOne = ((Method)member).getAnnotation(ManyToOne.class);
        }
        if (manyToOne == null) {
            return false;
        }
        RelationshipMetadata relationshipMetadata = new RelationshipMetadata(false, false, manyToOne.inverseClass(), manyToOne.inverseProperty(), "");
        propertyMetadata.setRelationship(relationshipMetadata);
        if (manyToOne.fetch() == FetchType.EAGER) {
            propertyMetadata.setFetchTypeEager();
        }
        return true;
    }

    static boolean processOneToManyAnnotation(Member member, PropertyMetadata propertyMetadata) {
        OneToMany oneToMany = null;
        if (member instanceof Field) {
            oneToMany = ((Field)member).getAnnotation(OneToMany.class);
        } else if (member instanceof Method) {
            oneToMany = ((Method)member).getAnnotation(OneToMany.class);
        }
        if (oneToMany == null) {
            return false;
        }
        RelationshipMetadata relationshipMetadata = new RelationshipMetadata(true, oneToMany.dependent(), oneToMany.inverseClass(), oneToMany.inverseProperty(), oneToMany.orderBy());
        propertyMetadata.setRelationship(relationshipMetadata);
        if (oneToMany.fetch() == FetchType.EAGER) {
            propertyMetadata.setFetchTypeEager();
        }
        return true;
    }

    static boolean processRelationshipAnnotation(Member member, PropertyMetadata propertyMetadata) {
        Relationship relationship = null;
        if (member instanceof Field) {
            relationship = ((Field)member).getAnnotation(Relationship.class);
        } else if (member instanceof Method) {
            relationship = ((Method)member).getAnnotation(Relationship.class);
        }
        if (relationship == null) {
            return false;
        }
        boolean bl = false;
        if (relationship.type() == RelationshipType.ONE_TO_MANY) {
            bl = true;
        }
        RelationshipMetadata relationshipMetadata = new RelationshipMetadata(bl, relationship.parentChild(), relationship.inverseClass(), relationship.inverseProperty(), "");
        propertyMetadata.setRelationship(relationshipMetadata);
        if (relationship.fetch() == FetchType.EAGER) {
            propertyMetadata.setFetchTypeEager();
        }
        return true;
    }

    static boolean processLobAnnotation(Member member, PropertyMetadata propertyMetadata) {
        Lob lob = null;
        if (member instanceof Field) {
            lob = ((Field)member).getAnnotation(Lob.class);
        } else if (member instanceof Method) {
            lob = ((Method)member).getAnnotation(Lob.class);
        }
        if (lob == null) {
            return false;
        }
        if (lob.type() == LobType.BLOB) {
            propertyMetadata.setKind(32);
        } else {
            propertyMetadata.setKind(64);
        }
        if (lob.fetch() == FetchType.EAGER) {
            propertyMetadata.setFetchTypeEager();
        }
        return true;
    }

    static void processVersionAnnotation(Member member, ClassMetadata classMetadata) {
        String string;
        Version version = null;
        if (member instanceof Field) {
            version = ((Field)member).getAnnotation(Version.class);
            if (version != null) {
                classMetadata.setVersionID(member.getName());
            }
        } else if (member instanceof Method && (version = ((Method)member).getAnnotation(Version.class)) != null && (string = ClassAnalizer.methodName2PropertyName(member.getName())) != null) {
            classMetadata.setVersionID(string);
        }
    }

    static boolean processDatabaseIDAnnotation(Member member, ClassMetadata classMetadata) {
        ID iD = null;
        if (member instanceof Field) {
            iD = ((Field)member).getAnnotation(ID.class);
        } else if (member instanceof Method) {
            iD = ((Method)member).getAnnotation(ID.class);
        }
        if (iD == null) {
            return false;
        }
        if (iD.type() == IDType.SYSTEM_ASSIGNED) {
            classMetadata.setDatabaseIDType(0);
        } else {
            classMetadata.setDatabaseIDType(1);
        }
        String string = member.getName();
        if (member instanceof Method) {
            string = ClassAnalizer.methodName2PropertyName(string);
        }
        classMetadata.setDatabaseID(string);
        return true;
    }

    static boolean processPropertyParameterAnnotation(Member member, PropertyMetadata propertyMetadata) {
        PropertyParameter propertyParameter = null;
        if (member instanceof Field) {
            propertyParameter = ((Field)member).getAnnotation(PropertyParameter.class);
        } else if (member instanceof Method) {
            propertyParameter = ((Method)member).getAnnotation(PropertyParameter.class);
        }
        if (propertyParameter == null) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put(propertyParameter.name(), propertyParameter.value());
        propertyMetadata.setPropertyParameters(hashMap);
        return true;
    }

    static boolean processPropertyParametersAnnotation(Member member, PropertyMetadata propertyMetadata) {
        PropertyParameters propertyParameters = null;
        if (member instanceof Field) {
            propertyParameters = ((Field)member).getAnnotation(PropertyParameters.class);
        } else if (member instanceof Method) {
            propertyParameters = ((Method)member).getAnnotation(PropertyParameters.class);
        }
        if (propertyParameters == null) {
            return false;
        }
        PropertyParameter[] propertyParameterArray = propertyParameters.value();
        HashMap<String, String> hashMap = new HashMap<String, String>(propertyParameterArray.length);
        for (int i = 0; i < propertyParameterArray.length; ++i) {
            PropertyParameter propertyParameter = propertyParameterArray[i];
            hashMap.put(propertyParameter.name(), propertyParameter.value());
        }
        propertyMetadata.setPropertyParameters(hashMap);
        return true;
    }

    static void processClassParameterAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        ClassParameter classParameter = clazz.getAnnotation(ClassParameter.class);
        if (classParameter != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(1);
            hashMap.put(classParameter.name(), classParameter.value());
            classMetadata.setClassParameters(hashMap);
        }
    }

    static void processClassParametersAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        ClassParameters classParameters = clazz.getAnnotation(ClassParameters.class);
        if (classParameters == null) {
            return;
        }
        ClassParameter[] classParameterArray = classParameters.value();
        HashMap<String, String> hashMap = new HashMap<String, String>(classParameterArray.length);
        for (int i = 0; i < classParameterArray.length; ++i) {
            ClassParameter classParameter = classParameterArray[i];
            hashMap.put(classParameter.name(), classParameter.value());
        }
        classMetadata.setClassParameters(hashMap);
    }

    static boolean processCollectionAnnotation(Member member, PropertyMetadata propertyMetadata) {
        Collection collection = null;
        if (member instanceof Field) {
            collection = ((Field)member).getAnnotation(Collection.class);
        } else if (member instanceof Method) {
            collection = ((Method)member).getAnnotation(Collection.class);
        }
        if (collection == null) {
            return false;
        }
        if (collection.fetch() == FetchType.EAGER) {
            propertyMetadata.setFetchTypeEager();
        }
        propertyMetadata.setCollectionType(collection.type());
        propertyMetadata.setType(collection.elementType());
        return true;
    }

    static void processIndicesAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        Indices indices = clazz.getAnnotation(Indices.class);
        if (indices == null) {
            return;
        }
        Index[] indexArray = indices.value();
        for (int i = 0; i < indexArray.length; ++i) {
            Index index = indexArray[i];
            classMetadata.setIndex(index.data(), index.description(), index.isIdKey(), index.name(), index.isPrimaryKey(), index.propertyNames(), index.sqlName(), index.type(), index.isUnique(), index.collation());
        }
    }

    static void processIndexAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        Index index = clazz.getAnnotation(Index.class);
        if (index != null) {
            classMetadata.setIndex(index.data(), index.description(), index.isIdKey(), index.name(), index.isPrimaryKey(), index.propertyNames(), index.sqlName(), index.type(), index.isUnique(), index.collation());
        }
    }

    static void processExtendsAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        Extends extends_ = clazz.getAnnotation(Extends.class);
        if (extends_ != null) {
            classMetadata.setExtendedClass(extends_.className());
        }
    }

    static void processImplementsAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        Implements implements_ = clazz.getAnnotation(Implements.class);
        if (implements_ != null) {
            classMetadata.setImplementedClasses(implements_.classNames());
        }
    }

    static boolean processTransientAnnotation(Object object, Object object2) {
        if (object instanceof Class) {
            if (((Class)object).getClass().getAnnotation(Transient.class) != null) {
                ((ClassMetadata)object2).setIsTransient();
                return true;
            }
            return false;
        }
        if (object instanceof Field) {
            if (((Field)object).getAnnotation(Transient.class) != null) {
                ((PropertyMetadata)object2).setIsTransient();
                return true;
            }
            return false;
        }
        if (object instanceof Method) {
            if (((Method)object).getAnnotation(Transient.class) != null) {
                ((PropertyMetadata)object2).setIsTransient();
                return true;
            }
            return false;
        }
        return false;
    }

    static void processEmbeddableAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        Embeddable embeddable = clazz.getAnnotation(Embeddable.class);
        if (embeddable != null) {
            classMetadata.setIsSerial();
        }
    }

    static void processAccessAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        Access access = clazz.getAnnotation(Access.class);
        if (access != null) {
            classMetadata.setAccessLevel(access.level());
            classMetadata.setAccessType(access.type());
        }
    }

    static void processQueriesAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        Queries queries = clazz.getAnnotation(Queries.class);
        if (queries == null) {
            return;
        }
        Query[] queryArray = queries.value();
        for (int i = 0; i < queryArray.length; ++i) {
            Query query = queryArray[i];
            classMetadata.setNamedQuery(query.name(), query.sqlText(), query.resultClass());
        }
    }

    static void processQueryAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        Query query = clazz.getAnnotation(Query.class);
        if (query == null) {
            return;
        }
        classMetadata.setNamedQuery(query.name(), query.sqlText(), query.resultClass());
    }
}

