/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.objects.CacheException;
import com.intersys.objects.Logger;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.jalapeno.runtime.CacheObjectManager;
import com.jalapeno.runtime.JalapenoHelperInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ObjectBackedMap
implements Map {
    private Object mObject;
    private JalapenoHelperInterface mHelper;
    private CacheClass mCacheClass;
    private int mSize;

    public ObjectBackedMap(CacheObjectManager cacheObjectManager, CacheClass cacheClass) throws Exception {
        this.mCacheClass = cacheClass;
        this.mHelper = cacheObjectManager.getHelper(cacheClass);
        this.mObject = this.mHelper.newInstance();
        this.mSize = cacheClass.getFields().length;
    }

    protected Object getObject() {
        return this.mObject;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object object) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("Key can only be a String: " + object);
        }
        try {
            return this.mCacheClass.getField((String)object) != null;
        }
        catch (CacheException cacheException) {
            return false;
        }
    }

    @Override
    public boolean containsValue(Object object) {
        boolean bl = object == null;
        try {
            CacheField[] cacheFieldArray = this.mCacheClass.getFields();
            for (int i = 0; i < cacheFieldArray.length; ++i) {
                CacheField cacheField = cacheFieldArray[i];
                Object object2 = this.mHelper.get(this.mObject, cacheField.getII());
                if (!(bl ? object2 == null : object.equals(object2))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public Object get(Object object) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("Key can only be a String: " + object);
        }
        try {
            CacheField cacheField = this.mCacheClass.getField((String)object);
            if (cacheField == null) {
                return null;
            }
            return this.mHelper.get(this.mObject, cacheField.getII());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object put(Object object, Object object2) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("Key can only be a String: " + object);
        }
        try {
            CacheField cacheField = this.mCacheClass.getField((String)object);
            if (cacheField == null) {
                throw new IllegalArgumentException("Property " + object + " is not declared");
            }
            Object object3 = this.mHelper.get(this.mObject, cacheField.getII());
            this.mHelper.set(this.mObject, cacheField.getII(), object2);
            return object3;
        }
        catch (Exception exception) {
            if (Logger.debugOn()) {
                exception.printStackTrace(Logger.out);
            }
            throw new IllegalStateException("Error setting value for key " + object + ": " + exception.getMessage());
        }
    }

    public Object remove(Object object) {
        return this.put(object, (Object)null);
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        CacheField[] cacheFieldArray = null;
        try {
            cacheFieldArray = this.mCacheClass.getFields();
        }
        catch (CacheException cacheException) {
            if (Logger.debugOn()) {
                cacheException.printStackTrace(Logger.out);
            }
            return;
        }
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            CacheField cacheField = cacheFieldArray[i];
            try {
                this.mHelper.set(this.mObject, cacheField.getII(), null);
                continue;
            }
            catch (Exception exception) {
                if (!Logger.debugOn()) continue;
                exception.printStackTrace(Logger.out);
            }
        }
    }

    public Set keySet() {
        CacheField[] cacheFieldArray = null;
        try {
            cacheFieldArray = this.mCacheClass.getFields();
        }
        catch (CacheException cacheException) {
            if (Logger.debugOn()) {
                cacheException.printStackTrace(Logger.out);
            }
            throw new IllegalStateException(cacheException.getMessage());
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            treeSet.add(cacheFieldArray[i].getName());
        }
        return treeSet;
    }

    public Collection values() {
        CacheField[] cacheFieldArray = null;
        try {
            cacheFieldArray = this.mCacheClass.getFields();
        }
        catch (CacheException cacheException) {
            if (Logger.debugOn()) {
                cacheException.printStackTrace(Logger.out);
            }
            throw new IllegalStateException(cacheException.getMessage());
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(cacheFieldArray.length);
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            CacheField cacheField = cacheFieldArray[i];
            Object object = null;
            try {
                object = this.mHelper.get(this.mObject, cacheField.getII());
            }
            catch (Exception exception) {
                if (Logger.debugOn()) {
                    exception.printStackTrace(Logger.out);
                }
                throw new IllegalStateException("Error getting value for key " + cacheField.getName() + ": " + exception.getMessage());
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    public Set entrySet() {
        CacheField[] cacheFieldArray = null;
        try {
            cacheFieldArray = this.mCacheClass.getFields();
        }
        catch (CacheException cacheException) {
            if (Logger.debugOn()) {
                cacheException.printStackTrace(Logger.out);
            }
            throw new IllegalStateException(cacheException.getMessage());
        }
        TreeSet<E> treeSet = new TreeSet<E>();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            E e = new E(cacheFieldArray[i].getName());
            treeSet.add(e);
        }
        return treeSet;
    }

    private class E
    implements Map.Entry {
        private String key;

        private E(String string) {
            this.key = string;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return ObjectBackedMap.this.get(this.key);
        }

        public Object setValue(Object object) {
            return ObjectBackedMap.this.put(this.key, object);
        }
    }
}

