/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.idecommon.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadConfigFile
extends DefaultHandler {
    private SAXParser saxParser;
    private HashMap<String, ArrayList<String>> projects;
    private ArrayList<String> currentProject;
    private String currentValue;
    private String projectName;
    private HashMap<String, String> importOptions;
    private HashMap<String, String> buildOptions;
    private HashMap<String, String> refactoringOptions;
    private boolean disableIDEWarnings;
    private boolean useJPA;
    private boolean syncOnConnect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadConfigFile() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            sAXParserFactory.setValidating(false);
            this.saxParser = sAXParserFactory.newSAXParser();
            this.projects = new HashMap();
            this.importOptions = new HashMap();
            this.buildOptions = new HashMap();
            this.refactoringOptions = new HashMap();
            this.disableIDEWarnings = false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public boolean parse(File file) {
        try {
            this.saxParser.parse(file, (DefaultHandler)this);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!string3.equals("class")) {
            if (string3.equals("project")) {
                if (attributes.getQName(0).equals("name")) {
                    this.projectName = attributes.getValue(0);
                }
            } else if (string3.equals("persistent-classes")) {
                this.currentProject = new ArrayList();
            } else if (string3.equals("import-options")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.getImportOptions().put(attributes.getQName(i), attributes.getValue(i));
                }
            } else if (string3.equals("build-options")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.getBuildOptions().put(attributes.getQName(i), attributes.getValue(i));
                }
            } else if (string3.equals("refactoring-options")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.getRefactoringOptions().put(attributes.getQName(i), attributes.getValue(i));
                }
            } else if (string3.equals("ide-warnings")) {
                this.disableIDEWarnings = attributes.getValue(0).equals("true");
            } else if (string3.equals("jpa-mode")) {
                this.useJPA = attributes.getValue(0).equals("true");
            } else if (string3.equals("sync-on-connect")) {
                this.syncOnConnect = attributes.getValue(0).equals("true");
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.currentValue = String.valueOf(cArray, n, n2).trim();
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("class")) {
            this.currentProject.add(this.currentValue);
        } else if (!string3.equals("project")) {
            if (string3.equals("persistent-classes")) {
                this.projects.put(this.projectName, this.currentProject);
            } else if (string3.equals("exclusions")) {
                this.getImportOptions().put("exclusions", this.currentValue);
            }
        }
    }

    public HashMap<String, ArrayList<String>> getProjectInfo() {
        return this.projects;
    }

    public HashMap<String, String> getImportOptions() {
        return this.importOptions;
    }

    public HashMap<String, String> getBuildOptions() {
        return this.buildOptions;
    }

    public HashMap<String, String> getRefactoringOptions() {
        return this.refactoringOptions;
    }

    public boolean isDisableIDEWarnings() {
        return this.disableIDEWarnings;
    }

    public boolean isJPAMode() {
        return this.useJPA;
    }

    public boolean isSyncOnConnect() {
        return this.syncOnConnect;
    }
}

