/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.xep;

import com.intersys.mds.MDSException;
import com.intersys.mds.internal.MDSClassInternal;
import com.intersys.mds.internal.MDSNodeReferenceInternal;
import com.intersys.xep.EventPersister;
import com.intersys.xep.EventQuery;
import com.intersys.xep.XEPException;
import com.intersys.xep.internal.TypeMap;
import com.intersys.xep.internal.filter.Filter;
import java.util.Stack;

public class Event {
    private String className;
    private Class clazz;
    private EventPersister persister;
    private MDSNodeReferenceInternal node;
    private MDSClassInternal eventClass;
    private long lastIdInserted;

    public Event() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Event(EventPersister eventPersister, String string, MDSClassInternal mDSClassInternal) throws XEPException {
        this.className = string;
        this.persister = eventPersister;
        this.eventClass = mDSClassInternal;
        try {
            this.clazz = Class.forName(this.className);
            MDSClassInternal mDSClassInternal2 = this.eventClass;
            synchronized (mDSClassInternal2) {
                this.node = this.eventClass.createNodeReferenceInternal();
            }
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
        this.initIndexing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long store(Object object) throws XEPException {
        if (object == null) {
            throw new XEPException("Cannot store null object");
        }
        if (this.clazz != object.getClass()) {
            throw new XEPException("Cannot store an instance of " + object.getClass() + "\r\nThis event already in use for instances of " + this.clazz.getName());
        }
        try {
            MDSNodeReferenceInternal mDSNodeReferenceInternal = this.node;
            synchronized (mDSNodeReferenceInternal) {
                this.lastIdInserted = this.node.setNextSubNodeAsList(object);
                return this.lastIdInserted;
            }
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] store(Object[] objectArray) throws XEPException {
        if (objectArray == null || objectArray.length == 0) {
            throw new XEPException("Cannot store null object");
        }
        if (this.clazz != objectArray[0].getClass()) {
            throw new XEPException("Cannot store an instance of " + objectArray[0].getClass() + "\r\nThis event already in use for instances of " + this.clazz.getName());
        }
        try {
            MDSNodeReferenceInternal mDSNodeReferenceInternal = this.node;
            synchronized (mDSNodeReferenceInternal) {
                long[] lArray = this.node.setNextSubNodeAsList(objectArray);
                if (lArray != null) {
                    this.lastIdInserted = lArray[lArray.length - 1];
                }
                return lArray;
            }
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    public <E> EventQuery<E> createQuery(String string) throws Exception {
        return new EventQuery(this.node, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(long l) throws XEPException {
        try {
            MDSNodeReferenceInternal mDSNodeReferenceInternal = this.node;
            synchronized (mDSNodeReferenceInternal) {
                return this.node.getObject(l, null);
            }
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(long l, Object object) throws XEPException {
        try {
            MDSNodeReferenceInternal mDSNodeReferenceInternal = this.node;
            synchronized (mDSNodeReferenceInternal) {
                this.node.updateObject(l, object);
            }
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(long l) throws XEPException {
        try {
            MDSNodeReferenceInternal mDSNodeReferenceInternal = this.node;
            synchronized (mDSNodeReferenceInternal) {
                this.node.deleteObject(l);
            }
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExtent() throws XEPException {
        try {
            MDSClassInternal mDSClassInternal = this.eventClass;
            synchronized (mDSClassInternal) {
                this.eventClass.killExtent();
            }
        }
        catch (MDSException mDSException) {
            throw new XEPException(mDSException);
        }
    }

    public void isEvent(Object object) throws XEPException {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        TypeMap.isEvent(clazz, new Stack<Class>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws XEPException {
        if (this.persister.getOption(2) == 9) {
            this.stopIndexing();
        }
        MDSNodeReferenceInternal mDSNodeReferenceInternal = this.node;
        synchronized (mDSNodeReferenceInternal) {
            this.node.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(String string) throws XEPException {
        block6: {
            if (string != null) {
                try {
                    byte[] byArray = Filter.processFilter(string, this.className, null);
                    if (byArray == null) break block6;
                    MDSNodeReferenceInternal mDSNodeReferenceInternal = this.node;
                    synchronized (mDSNodeReferenceInternal) {
                        this.node.setFilter(byArray);
                    }
                }
                catch (Exception exception) {
                    throw new XEPException(exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startIndexing() throws XEPException {
        if (this.eventClass == null) {
            throw new XEPException("No event class found");
        }
        try {
            MDSClassInternal mDSClassInternal = this.eventClass;
            synchronized (mDSClassInternal) {
                this.eventClass.startIndexing();
            }
        }
        catch (MDSException mDSException) {
            throw new XEPException(mDSException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIndexing() throws XEPException {
        if (this.eventClass == null) {
            throw new XEPException("No event class found");
        }
        try {
            MDSClassInternal mDSClassInternal = this.eventClass;
            synchronized (mDSClassInternal) {
                this.eventClass.stopIndexing();
            }
        }
        catch (MDSException mDSException) {
            throw new XEPException(mDSException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForIndexing(int n, boolean bl) throws XEPException {
        if (this.eventClass == null) {
            throw new XEPException("No event class found");
        }
        try {
            MDSClassInternal mDSClassInternal = this.eventClass;
            synchronized (mDSClassInternal) {
                long l = bl ? this.lastIdInserted : 0L;
                return this.eventClass.waitForIndexing(n, l);
            }
        }
        catch (MDSException mDSException) {
            throw new XEPException(mDSException);
        }
    }

    private void initIndexing() throws XEPException {
        int n = this.persister.getOption(1);
        if (n == 6) {
            this.startIndexing();
        } else if (n == 7) {
            this.stopIndexing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUp() throws XEPException {
        MDSNodeReferenceInternal mDSNodeReferenceInternal = this.node;
        synchronized (mDSNodeReferenceInternal) {
            this.node.cleanup();
        }
        if (this.persister.getOption(2) == 2) {
            this.stopIndexing();
        }
    }
}

