/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.cache.quick.LightDatabase;
import com.intersys.classes.CacheRootObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.Logger;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class POJOIterator
implements Iterator {
    private Iterator mIterator;
    private boolean mAllowProxy;

    public POJOIterator(Iterator iterator, boolean bl) {
        this.mIterator = iterator;
        this.mAllowProxy = bl;
    }

    @Override
    public void remove() {
        this.mIterator.remove();
    }

    @Override
    public boolean hasNext() {
        return this.mIterator.hasNext();
    }

    public Object next() {
        Object object = null;
        CacheRootObject cacheRootObject = null;
        try {
            object = this.mIterator.next();
            cacheRootObject = (CacheRootObject)object;
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchElementException("Next object is instance of class " + object.getClass().getName() + " that is not supported in POJO mode");
        }
        try {
            return cacheRootObject.detach(this.mAllowProxy);
        }
        catch (CacheException cacheException) {
            if (Logger.debugOn()) {
                cacheException.printFullTrace(Logger.out);
            }
            throw new RuntimeException(cacheException.getMessage(), cacheException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            if (Logger.debugOn()) {
                exception.printStackTrace(Logger.out);
            }
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    public void closeStatement() throws SQLException {
        LightDatabase.closeStatement(this.mIterator);
    }
}

