/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.cache.jbind.JBindDatabase;
import com.intersys.classes.BinaryStream;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheIOException;
import com.intersys.objects.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class CacheOutputStream
extends OutputStream
implements Serializable {
    private static final int OLD_LIMIT = 30000;
    private BinaryStream mStream;
    private Boolean mStreamIOSupported = null;

    public CacheOutputStream(BinaryStream binaryStream) throws CacheException {
        this.mStream = binaryStream;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.write(byArray2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        try {
            if (this.isStreamIOSupported()) {
                String string = Streams.getOref(this.mStream);
                JBindDatabase jBindDatabase = (JBindDatabase)this.mStream.getDatabase();
                jBindDatabase.sendBinaryStream(string, new ByteArrayInputStream(byArray), byArray.length);
            } else if (byArray.length < 30000) {
                this.mStream._write(byArray);
            } else {
                this.writeOldLongStream(byArray);
            }
        }
        catch (CacheException cacheException) {
            throw new CacheIOException(cacheException);
        }
    }

    private void writeOldLongStream(byte[] byArray) throws CacheException {
        for (int i = 0; i < byArray.length; i += 30000) {
            int n = byArray.length > i + 30000 ? 30000 : byArray.length - i;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, i, byArray2, 0, n);
            this.mStream._write(byArray2);
        }
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray);
    }

    @Override
    public void flush() throws IOException {
        try {
            this.mStream._flush();
        }
        catch (CacheException cacheException) {
            throw new CacheIOException(cacheException);
        }
    }

    private boolean isStreamIOSupported() throws IOException {
        if (this.mStreamIOSupported == null) {
            if (this.mStream == null) {
                return false;
            }
            this.mStreamIOSupported = Streams.isStreamIOSupported(this.mStream);
        }
        return this.mStreamIOSupported;
    }

    public void rewind() throws CacheException {
        this.mStream._rewind();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        try {
            this.rewind();
        }
        catch (CacheException cacheException) {
            throw new IOException(cacheException.toString());
        }
    }
}

