/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jsp;

import com.intersys.cache.CacheClassLoader;
import com.intersys.jsp.DBHelper;
import com.intersys.objects.CacheDatabase;
import com.intersys.objects.Database;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class ConnectTag
extends TagSupport {
    private Database mDB = null;
    private String mUser;
    private String mPassword;
    private String mNamespace;
    private int mPort = 1972;
    private String mHost = "localhost";
    private boolean mUseCustomClassLoader = true;
    private String mScratchDir = null;
    private String mClassDir = null;
    private static final String PROTOCOL = "jdbc:Cache";

    public int doStartTag() throws JspException {
        this.retrieveConnector();
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            this.ifConnect();
        }
        catch (Exception exception) {
            throw new JspException("Exception during connection: \n" + exception.toString(), (Throwable)exception);
        }
        this.storeConnector();
        return 6;
    }

    public void ifConnect() throws Exception {
        if (this.mDB == null) {
            this.reConnect();
        }
    }

    public void reConnect() throws Exception {
        this.mDB = CacheDatabase.getDatabase(this.getURL(), this.getUser(), this.getPassword());
        if (this.mUseCustomClassLoader) {
            CacheClassLoader cacheClassLoader = new CacheClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.getClassdir(), this.getScratchdir(), this.mDB);
            this.mDB.setClassLoader(cacheClassLoader);
        }
    }

    protected void storeConnector() throws JspException {
        DBHelper.setDBConnectionInSession(this.pageContext, this.mDB);
    }

    protected void retrieveConnector() throws JspException {
        if (this.mDB != null) {
            return;
        }
        if (this.pageContext == null) {
            if (DBHelper.getDefaultDebugLevel() > 0) {
                System.out.println("Can not create connector: Page context is null");
            }
            return;
        }
        this.mDB = DBHelper.getDBConnectionFromSession(this.pageContext);
        if (this.mDB == null) {
            try {
                this.reConnect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new JspException((Throwable)exception);
            }
        }
    }

    public String getURL() {
        return "jdbc:Cache://" + this.mHost + ':' + this.mPort + '/' + this.mNamespace;
    }

    public String getUser() {
        return this.mUser;
    }

    public void setUser(String string) {
        this.mUser = string;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String string) {
        this.mPassword = string;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public void setNamespace(String string) {
        this.mNamespace = string;
    }

    public String getPort() {
        return String.valueOf(this.mPort);
    }

    public void setPort(String string) {
        this.mPort = Integer.parseInt(string);
    }

    public String getHost() {
        return this.mHost;
    }

    public void setHost(String string) {
        this.mHost = string;
    }

    public String getAutoload() {
        return String.valueOf(this.mUseCustomClassLoader);
    }

    public void setAutoload(String string) {
        this.mUseCustomClassLoader = Boolean.valueOf(string);
    }

    public String getScratchdir() {
        if (this.mScratchDir != null) {
            return this.mScratchDir;
        }
        return this.getWebInfDir() + File.separator + "src";
    }

    public void setScratchdir(String string) {
        this.mScratchDir = string;
    }

    public String getClassdir() {
        if (this.mClassDir != null) {
            return this.mClassDir;
        }
        return this.getWebInfDir() + File.separator + "classes";
    }

    public void setClassdir(String string) {
        this.mClassDir = string;
    }

    private String getWebInfDir() {
        String string = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
        String string2 = this.pageContext.getServletContext().getRealPath("");
        return string2 + File.separator + "WEB-INF";
    }
}

