/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.Stream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

class FakeStream
extends Stream {
    Object data;
    int dataOffset;

    FakeStream(Object object, int n, int n2, int n3) throws SQLException {
        super(n, n2, n3);
        if (object == null) {
            this.size = -1;
            this.available = -1;
            return;
        }
        if (object instanceof byte[]) {
            this.size = ((byte[])object).length;
            this.data = new byte[this.size];
        } else if (object instanceof char[]) {
            this.size = ((char[])object).length;
            this.data = new char[this.size];
        }
        try {
            System.arraycopy(object, 0, this.data, 0, this.size);
        }
        catch (Exception exception) {
            throw new SQLException("error reading stream data " + exception.getMessage(), "S1000");
        }
        this.available = this.size;
        this.dataOffset = 0;
    }

    @Override
    synchronized int fetchStream(Object object, int n, int n2) throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        if (this.available <= 0 || this.maxStreamSize == 0) {
            return -1;
        }
        if (n2 > this.available) {
            n2 = this.available;
        }
        if (this.maxStreamSize > 0 && n2 > this.maxStreamSize) {
            n2 = this.maxStreamSize;
        }
        System.arraycopy(this.data, this.dataOffset, object, n, n2);
        this.dataOffset += n2;
        if (this.maxStreamSize != 0) {
            this.maxStreamSize -= n2;
        }
        this.available -= n2;
        return n2;
    }

    @Override
    boolean isNull() {
        return this.size == -1;
    }

    @Override
    synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.size = 0;
        this.data = null;
        this.dataOffset = 0;
        this.available = 0;
        this.closed = true;
    }

    static Object sendStream(Object object, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        if (n2 == 4) {
            int n5;
            Reader reader = (Reader)object;
            char[] cArray = new char[n];
            while (n > 0 && (n5 = reader.read(cArray, n4, n)) != -1) {
                n4 += n5;
                n -= n5;
            }
            return cArray;
        }
        InputStream inputStream = (InputStream)object;
        byte[] byArray = new byte[n];
        while (n > 0 && (n3 = inputStream.read(byArray, n4, n)) != -1) {
            n4 += n3;
            n -= n3;
        }
        return byArray;
    }
}

