/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;

public class CacheSavepoint
implements Savepoint {
    private Connection connection;
    private String name;
    private int id;
    private Statement statement;
    private boolean released;

    CacheSavepoint(CacheConnection cacheConnection, String string, int n) throws SQLException {
        this.connection = cacheConnection;
        this.name = string;
        this.id = n;
        this.released = false;
        this.statement = cacheConnection.createStatement();
        this.statement.executeUpdate("SAVEPOINT " + this.name);
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Savepoint object does not have a numeric identifier");
        }
        return this.id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.id != -1) {
            throw new SQLException("Savepoint object does not have a String identifier");
        }
        return this.name;
    }

    void rollback() throws SQLException {
        if (this.released) {
            throw new SQLException("Savepoint has already been relased");
        }
        this.statement.executeUpdate("ROLLBACK TO SAVEPOINT " + this.name);
    }

    void release() {
        this.released = true;
        this.statement = null;
    }
}

