/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.codegenerator.java;

import com.intersys.codegenerator.java.Java;
import com.intersys.codegenerator.java.OutputFile;

public class JavaDoc {
    private Java mJava;
    OutputFile mOut;
    private final String[] mConstructorDatabase = new String[]{"    /**", "       Creates a new instance of object \"<CacheClassName>\" in Cache", "       database and corresponding object of class", "       <code><JavaClassName></code>.", "", "       @param db <code>Database</code> object used for connection with", "       Cache database.", "       ", "       @throws CacheException in case of error.", "              ", "              @see #_open(com.intersys.objects.Database, com.intersys.objects.Oid)", "     */"};
    private final String[] mConstructorCacheObject = new String[]{"    /**", "           NB: DO NOT USE IN APPLICATION!", "           Use <code><JavaClassName>._open</code> instead.", "           <p>", "           Used to construct a Java object, corresponding to existing object", "           in Cache database.", "           ", "           @see #_open(com.intersys.objects.Database, com.intersys.objects.Oid)", "    */"};
    private final String[] mOpenWithId = new String[]{"    /**", "       Runs method <code> %OpenId </code> in Cache to open an object", "       from Cache database and creates corresponding object of class", "       <code><JavaClassName></code>.", "", "       @return <code> RegisteredObject </code>, corresponding to opened", "       object. This object may be of <code><JavaClassName></code> or of ", "      any of its subclasses. Cast to <code><JavaClassName></code> is ", "      guaranteed to pass without <code>ClassCastException</code> exception.", "", "       @param db <code>Database</code> object used for connection with", "       Cache database.", "", "       @param id ID as specified in Cache represented as ", "      <code>Id</code>.", "       ", "       @throws CacheException in case of error.", "      @see java.lang.ClassCastException", "           @see #_open(com.intersys.objects.Database, com.intersys.objects.Oid)", "           @see #<JavaClassName>", "     */"};
    private final String[] mOpenWithOid = new String[]{"    /**", "       Runs method <code> %Open </code> in Cache to open an object", "       from Cache database and creates corresponding object of class", "       <code><JavaClassName></code>.", "", "       @return <code> RegisteredObject </code>, corresponding to opened", "       object. This object may be of <code><JavaClassName></code> or of ", "      any of its subclasses. Cast to <code><JavaClassName></code> is ", "      guaranteed to pass without <code>ClassCastException</code> exception.", "", "       @param db <code>Database</code> object used for connection with", "       Cache database.", "       @param oid Object ID as specified in Cache. represented as ", "      <code>Oid</code>.", "", "       ", "       @throws CacheException in case of error.", "      @see java.lang.ClassCastException", "           @see #_open(com.intersys.objects.Database, com.intersys.objects.Id)", "           @see #<JavaClassName>(com.intersys.objects.Database)", "     */"};
    private final String[] mGetCacheClassName = new String[]{"    /**", "       Returns class name of the class <JavaClassName> as it is in ", "      Cache Database. Note, that this is a static method, so no", "      object specific information can be returned. Use ", "      <code>getCacheClass().geName()</code> to get the class name", "      for specific object.", "       @return Cache class name as a <code>String</code>", "      @see #getCacheClass()", "      @see com.intersys.objects.reflect.CacheClass#getName()", "     */"};
    private final String[] mGetCacheClass = new String[]{"   /**", "           Allows access metadata information about type of this object ", "           in Cache database. Also can be used for dynamic binding (accessing", "           properties and calling methods without particular class known).", "           ", "           @return <code>CacheClass</code> object for this object type.", "   */"};
    private final String[] mCheckAllFieldsValid = new String[]{"    /**", "       Verifies that all fields from Cache class are exposed with", "       accessor methods in Java class and that values for indexes in", "       zObjVal are the same as in Cache. It does not return anything", "       but it throws an exception in case of inconsistency.", "", "       <p>But if there is any inconsistency in zObjVal indexes this is fatal and class can not work correctly and must be regenerated", "", "       @param db Database used for connection. Note that if you are", "       using multiple databases the class can be consistent with one", "       and inconsistent with another.", "       @throws InvalidClassException if any inconsistency is found.", "       @throws CacheException if any error occurred during", "       verification, e.g. communication error with Database.", "       @see com.intersys.objects.InvalidPropertyException", "", "     */"};
    private final String[] mCheckAllMethods = new String[]{"    /**", "       Verifies that all methods from Cache class are exposed with", "       accessor methods in Java class and that they are consistent", "       with methods in Cache. It does not return anything but it", "       throws an exception in case of inconsistency.", "", "       @param db Database used for connection. Note that if you are", "       using multiple databases the class can be consistent with one", "       and inconsistent with another.", "       @throws InvalidClassException if any inconsistency is found.", "       @throws CacheException if any error occurred during", "       verification, e.g. communication error with Database.", "       @see InvalidMethodException", "", "     */"};
    private final String[] mCheckPropNameValid = new String[]{"    /**", "       Verifies that indexes for property <code><PropName></code> in", "       zObjVal are the same as in Cache. It does not return anything", "       but it throws an exception in case of inconsistency.", "", "       <p> Please note, that if there is any inconsistency in zObjVal", "       indexes this is fatal and class can not work correctly and must", "       be regenerated.", "", "       @param db Database used for connection. Note that if you are", "       using multiple databases the class can be consistent with one", "       and inconsistent with another.", "       @throws InvalidClassException if any inconsistency is found.", "       @throws CacheException if any error occurred during", "       verification, e.g. communication error with Database.", "       @see #checkAllFieldsValid", "", "     */"};
    private final String[] mGetMethod = new String[]{"    /**", "       Returns value of property <code><PropName></code>", "       @return current value of <code><PropName></code> represented as", "       <code><PropType></code>", "", "       @throws CacheException if any error occurred during value retrieval."};
    private final String[] mSetMethod = new String[]{"    /**", "       Sets new value for <code><PropName></code>.", "       @param value new value to be set represented as", "       <code><PropType></code>.", "       @throws CacheException if any error occurred during value setting."};

    JavaDoc(Java java, OutputFile outputFile) {
        this.mJava = java;
        this.mOut = outputFile;
    }

    public void genConstructorDatabaseArg(String string) {
        String[] stringArray = this.mConstructorDatabase;
        this.driver(stringArray, string);
    }

    public void genConstructorCacheObject(String string) {
        String[] stringArray = this.mConstructorCacheObject;
        this.driver(stringArray, string);
    }

    public void genOpenWithId(String string) {
        String[] stringArray = this.mOpenWithId;
        this.driver(stringArray, string);
    }

    public void genOpenWithOid(String string) {
        String[] stringArray = this.mOpenWithOid;
        this.driver(stringArray, string);
    }

    public void genGetCacheClass(String string) {
        String[] stringArray = this.mGetCacheClass;
        this.driver(stringArray, string);
    }

    public void genCacheClassName(String string) {
        String[] stringArray = this.mGetCacheClassName;
        this.driver(stringArray, string);
    }

    public void genCheckAllFieldsValid(String string) {
        String[] stringArray = this.mCheckAllFieldsValid;
        this.driver(stringArray, string);
    }

    public void genCheckAllMethods(String string) {
        String[] stringArray = this.mCheckAllFieldsValid;
        this.driver(stringArray, string);
    }

    public void genCheckPropNameValid(String string, String string2) {
        String[] stringArray = this.mCheckPropNameValid;
        this.driver(stringArray, string, string2);
    }

    public void genGetMethod(String string, String string2, String string3, String string4) {
        String[] stringArray = this.mGetMethod;
        this.genAccessorMethod(stringArray, string, string2, string3, string4);
    }

    public void genSetMethod(String string, String string2, String string3, String string4) {
        String[] stringArray = this.mSetMethod;
        this.genAccessorMethod(stringArray, string, string2, string3, string4);
    }

    public void genAccessorMethod(String[] stringArray, String string, String string2, String string3, String string4) {
        String string5;
        this.driver(stringArray, string, string2, string3);
        String string6 = string;
        if (string6.charAt(0) == '%') {
            string6 = "%25" + string6.substring(1);
        }
        if ((string5 = this.mJava.getCommentNameSpace()).charAt(0) == '%') {
            string5 = "%25" + string5.substring(1);
        }
        String string7 = this.mJava.getHost();
        this.mOut.genE("       Description: " + string4);
        this.mOut.genE("       @see <a href = \"http://" + string7 + ":" + this.mJava.getPort() + "/csp/docbook/%25CSP.Documatic.cls?APP=1&PAGE=CLASS&LIBRARY=" + string5 + "&CLASSNAME=" + string6 + "#" + string2 + "\"> " + string2 + "</A>");
        this.mOut.genE("    */");
    }

    public void driver(String[] stringArray, String string) {
        this.driver(stringArray, string, "", "");
    }

    public void driver(String[] stringArray, String string, String string2) {
        this.driver(stringArray, string, string2, "");
    }

    public void driver(String[] stringArray, String string, String string2, String string3) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (!string.equals("")) {
                string4 = this.trimIt(string4);
                string4 = this.replace(string4, "<CacheClassName>", string);
                string4 = this.replace(string4, "<JavaClassName>", Java.shortName(string));
            }
            if (!string2.equals("")) {
                string4 = this.replace(string4, "<PropName>", string2);
            }
            if (!string3.equals("")) {
                string4 = this.replace(string4, "<PropType>", string3);
            }
            this.mOut.genE(string4);
        }
    }

    public String replace(String string, String string2, String string3) {
        return string.replaceAll(string2, string3);
    }

    public String trimIt(String string) {
        string = this.blankItIfSpaces(string);
        return this.removeTrailingSpacesLine(string);
    }

    public String removeTrailingSpacesLine(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.charAt(string.length() - 1) != ' ') {
            return string;
        }
        for (int i = string.length() - 1; i >= 0 && string.charAt(i) == ' '; --i) {
            string = string.substring(0, i);
        }
        return string;
    }

    public String blankItIfSpaces(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') continue;
            return string;
        }
        return "";
    }
}

