/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.serial;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.ExternalObjectProvider;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jbind.ReadOnlyDatabase;
import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.cache.metadata.MetadataFactory;
import com.intersys.cache.serial.CacheMetadataFactory;
import com.intersys.cache.serial.SerialCacheClass;
import com.intersys.cache.serial.SerialCacheObject;
import com.intersys.classes.ObjectHandle;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.ObjectFactory;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheInputStream;
import com.intersys.objects.CacheOutputStream;
import com.intersys.objects.CacheReader;
import com.intersys.objects.CacheServerSensitive;
import com.intersys.objects.CacheWriter;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.DatabaseUtilities;
import com.intersys.objects.Id;
import com.intersys.objects.ObjectServerInfo;
import com.intersys.objects.Oid;
import com.intersys.objects.SList;
import com.intersys.objects.StatusCode;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.jalapeno.Utilities;
import com.jalapeno.runtime.DetachedObjectsManager;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SerialObjectFactory
extends ExternalObjectProvider
implements SysDatabase,
ObjectFactory {
    private MetadataFactory mMetadataFactory;
    private Map mClassMap = new HashMap();
    private ConnectionInfo mConnectionInfo = new ConnectionInfo();
    private static Map factories;
    private String mURL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SerialObjectFactory getSerialObjectFactory(Connection connection) throws CacheException {
        Object object = SerialObjectFactory.class;
        synchronized (SerialObjectFactory.class) {
            if (factories == null) {
                factories = new HashMap();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = factories;
            synchronized (object) {
                SerialObjectFactory serialObjectFactory = (SerialObjectFactory)factories.get(connection);
                if (serialObjectFactory != null) {
                    return serialObjectFactory;
                }
                String string = null;
                try {
                    string = connection.getMetaData().getURL();
                }
                catch (SQLException sQLException) {
                    string = connection.toString();
                }
                serialObjectFactory = new SerialObjectFactory(string);
                serialObjectFactory.mConnectionInfo = JDBCAdapter.getCacheConnection(connection).getConnectionInfo();
                CacheMetadataFactory cacheMetadataFactory = null;
                try {
                    cacheMetadataFactory = new CacheMetadataFactory((SysDatabase)serialObjectFactory, connection);
                }
                catch (SQLException sQLException) {
                    throw new CacheException(sQLException);
                }
                serialObjectFactory.setMetadataFactory(cacheMetadataFactory);
                factories.put(connection, serialObjectFactory);
                return serialObjectFactory;
            }
        }
    }

    public static void onConnectionClose(Connection connection) {
        if (factories == null) {
            return;
        }
        SerialObjectFactory serialObjectFactory = (SerialObjectFactory)factories.remove(connection);
        if (serialObjectFactory != null) {
            try {
                serialObjectFactory.close();
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }

    public SerialObjectFactory(String string) {
        this();
        this.mURL = string;
    }

    public SerialObjectFactory() {
    }

    public void setMetadataFactory(MetadataFactory metadataFactory) {
        this.mMetadataFactory = metadataFactory;
    }

    @Override
    public String getConnectionString() {
        return this.mURL;
    }

    public List getStaticDictionary() throws CacheException {
        byte[] byArray = new byte[]{};
        try {
            byArray = this.mMetadataFactory.getStaticDictionary();
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to get static dictionary");
        }
        if (byArray == null) {
            throw new CacheException("Static Metadata Dictionary is not found.");
        }
        Object object = SysListProxy.createSysList(byArray, false, this.mConnectionInfo);
        return new SList(object);
    }

    @Override
    public CacheClass getCacheClass(String string) throws CacheException {
        CacheClass cacheClass = (CacheClass)this.mClassMap.get(string);
        if (cacheClass != null) {
            return cacheClass;
        }
        return this.mMetadataFactory.getCacheClass(string);
    }

    @Override
    public void addClass(CacheClass cacheClass, String string) {
        this.mClassMap.put(cacheClass.getName(), cacheClass);
    }

    @Override
    public CacheObject deserializeObject(String string, byte[] byArray) throws CacheException {
        Object object = SysListProxy.createSysList(byArray, this.mConnectionInfo);
        return this.deserializeObject(string, object);
    }

    @Override
    public Object deserialize(Object object) throws SQLException {
        try {
            return this.deserializeObject(null, object);
        }
        catch (CacheException cacheException) {
            throw new SQLException(cacheException.getMessage());
        }
    }

    @Override
    public CacheObject deserializeObject(String string, Object object) throws CacheException {
        Object object2;
        try {
            SysListProxy.getSysList(object);
            if (!SysListProxy.atEnd(object) && (object2 = SysListProxy.getString(object)) != null && ((String)object2).length() > 0) {
                string = object2;
            }
            SysListProxy.rewind(object);
            if (string == null) {
                throw new CacheException("Can not determine class name: " + object);
            }
        }
        catch (Exception exception) {
            throw new CacheException(exception, "Can not determine class name: " + object);
        }
        object2 = (SerialCacheClass)this.getCacheClass(string);
        return new SerialCacheObject(this, (SerialCacheClass)object2, object);
    }

    @Override
    public CacheObject openCacheObject(String string, byte[] byArray) throws CacheException {
        return this.deserializeObject(string, byArray);
    }

    @Override
    public CacheObject openCacheObject(String string, byte[] byArray, int n) throws CacheException {
        return this.openCacheObject(string, byArray);
    }

    @Override
    public CacheObject openCacheObject(String string, byte[] byArray, int n, int n2) throws CacheException {
        return this.openCacheObject(string, byArray);
    }

    @Override
    public Map close() throws CacheException {
        this.mClassMap.clear();
        this.mMetadataFactory.close();
        return null;
    }

    @Override
    public CacheObject openCacheObject(String string, String string2) throws CacheException {
        throw new UnsupportedOperationException("Method openCacheObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheObject openCacheObject(String string, String string2, int n) throws CacheException {
        throw new UnsupportedOperationException("Method openCacheObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheObject openCacheObject(String string, String string2, int n, int n2) throws CacheException {
        throw new UnsupportedOperationException("Method openCacheObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheObject newCacheObject(String string) throws CacheException {
        throw new UnsupportedOperationException("Method newCacheObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheObject newClientObject(String string) throws CacheException {
        throw new UnsupportedOperationException("Method newClientObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheObject newCacheObject(String string, String string2) throws CacheException {
        throw new UnsupportedOperationException("Method newCacheObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheObject getCacheObjectUnsafe(String string, int n) throws CacheException {
        throw new UnsupportedOperationException("Method getCacheObjectUnsafe() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public Object getListBuffer(int n, int n2, int n3) throws CacheException {
        throw new UnsupportedOperationException("Method getListBuffer() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public Object getArrayBuffer(int n, String string, int n2, int n3) throws CacheException {
        throw new UnsupportedOperationException("Method getArrayBuffer() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public Object getObjectListBuffer(int n, int n2, int n3) throws CacheException {
        throw new UnsupportedOperationException("Method getObjectListBuffer() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public Object getObjectArrayBuffer(int n, String string, int n2, int n3) throws CacheException {
        throw new UnsupportedOperationException("Method getObjectArrayBuffer() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void processObjectBuffer(Object object, Object object2, CacheServerSensitive cacheServerSensitive) throws CacheException {
        throw new UnsupportedOperationException("Method processObjectBuffer() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void decreaseServerReferenceCount(int n, int n2) throws CacheException {
        throw new UnsupportedOperationException("Method decreaseServerReferenceCount() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public boolean existsObject(Oid oid) throws CacheException {
        throw new UnsupportedOperationException("Method existsObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public boolean existsObject(String string, Id id) throws CacheException {
        throw new UnsupportedOperationException("Method existsObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void deleteObject(Oid oid) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void deleteObject(Oid oid, int n) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void deleteObject(String string, Id id, int n) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void deleteObject(String string, Id id) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public boolean deleteObject(String string, CandidateKey candidateKey) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void removeClass(CacheClass cacheClass) throws CacheException {
        throw new UnsupportedOperationException("Method removeClass() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public Dataholder[] runClassMethod(String string, String string2, int[] nArray, Dataholder[] dataholderArray, int n) throws CacheException {
        throw new UnsupportedOperationException("Method runClassMethod() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public Dataholder runClassMethod(String string, String string2, Dataholder[] dataholderArray, int n) throws CacheException {
        throw new UnsupportedOperationException("Method runClassMethod() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void setCacheObjectReadDirty(Oid oid) throws CacheException {
        throw new UnsupportedOperationException("Method setCacheObjectReadDirty() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void registerClass(String string, CacheClass cacheClass) {
        throw new UnsupportedOperationException("Method registerClass() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void printStatistics() {
        throw new UnsupportedOperationException("Method printStatistics() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void printStatistics(PrintStream printStream) {
        throw new UnsupportedOperationException("Method printStatistics() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public Statement createStatement() throws CacheException {
        throw new UnsupportedOperationException("Method createStatement() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws CacheException {
        throw new UnsupportedOperationException("Method prepareStatement() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CallableStatement prepareCall(String string) throws CacheException {
        throw new UnsupportedOperationException("Method prepareCall() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void closeObject(int n) throws CacheException {
        throw new UnsupportedOperationException("Method closeObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void closeObject(Object object) throws CacheException {
        throw new UnsupportedOperationException("Method closeObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void releaseObject(Object object) throws CacheException {
        throw new UnsupportedOperationException("Method releaseObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void closeAllObjects(boolean bl) throws CacheException {
        throw new UnsupportedOperationException("Method closeAllObjects() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void closeAllObjects() throws CacheException {
        this.closeAllObjects(false);
    }

    @Override
    public void flush() {
    }

    @Override
    public boolean isLowLevelConnectionClosed() throws CacheException {
        throw new UnsupportedOperationException("Method isLowLevelConnectionClosed() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public boolean isOpen() {
        throw new UnsupportedOperationException("Method isOpen() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public ObjectServerInfo getServerInfo() {
        throw new UnsupportedOperationException("Method getServerInfo() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public boolean isLightConnection() {
        throw new UnsupportedOperationException("Method isLightConnection() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public int parseStatus(Dataholder dataholder) throws CacheException {
        throw new UnsupportedOperationException("Method parseStatus() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public int parseStatus(StatusCode statusCode) throws CacheException {
        throw new UnsupportedOperationException("Method parseStatus() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public Iterator openByQuery(String string, String string2, Object[] objectArray) throws CacheException {
        throw new UnsupportedOperationException("Method openByQuery() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public Iterator openByQuery(String string, String string2) throws CacheException {
        throw new UnsupportedOperationException("Method openByQuery() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public Iterator openByQuery(String string, Object[] objectArray) throws CacheException {
        throw new UnsupportedOperationException("Method openByQuery() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public Iterator openByQuery(String string) throws CacheException {
        throw new UnsupportedOperationException("Method openByQuery() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void createObjects(String string, Collection collection) throws CacheException {
        throw new UnsupportedOperationException("Method createObjects() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void saveObjects(String string, Collection collection) throws CacheException {
        throw new UnsupportedOperationException("Method saveObjects() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void saveAllObjects() throws CacheException {
        throw new UnsupportedOperationException("Method saveAllObjects() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public DatabaseUtilities utilities() {
        throw new UnsupportedOperationException("Method utilities() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive) {
        throw new UnsupportedOperationException("Method registerSensitiveObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, ObjectHandle objectHandle) throws CacheException {
        throw new UnsupportedOperationException("Method registerSensitiveObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, int n) throws CacheException {
        throw new UnsupportedOperationException("Method registerSensitiveObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, Set set) throws CacheException {
        throw new UnsupportedOperationException("Method registerSensitiveObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public boolean unRegisterSensitiveObject(CacheServerSensitive cacheServerSensitive) throws CacheException {
        throw new UnsupportedOperationException("Method unRegisterSensitiveObject() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void transactionStart() throws CacheException {
        throw new UnsupportedOperationException("Method transactionStart() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void transactionCommit() throws CacheException {
        throw new UnsupportedOperationException("Method transactionCommit() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void transactionRollback() throws CacheException {
        throw new UnsupportedOperationException("Method transactionRollback() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public int getCacheType() throws CacheException {
        throw new UnsupportedOperationException("Method getCacheType() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public int getNumberOfOpenObjects() {
        throw new UnsupportedOperationException("Method getNumberOfOpenObjects() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public long getServerTime() throws CacheException {
        throw new UnsupportedOperationException("Method getServerTime() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public int getNumberOfServerCalls() throws CacheException {
        throw new UnsupportedOperationException("Method getNumberOfServerCalls() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public long getServerTime(int n) throws CacheException {
        throw new UnsupportedOperationException("Method getServerTime() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public int getNumberOfServerCalls(int n) throws CacheException {
        throw new UnsupportedOperationException("Method getNumberOfServerCalls() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public Map getSentMessages(int n) {
        throw new UnsupportedOperationException("Method getSentMessages() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void setProfileOn(int n) throws CacheException {
        throw new UnsupportedOperationException("Method setProfileOn() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void resetProfile(int n) throws CacheException {
        throw new UnsupportedOperationException("Method resetProfile() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void setProfileOff(int n) throws CacheException {
        throw new UnsupportedOperationException("Method setProfileOff() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        throw new UnsupportedOperationException("Method setClassLoader() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void setConsoleOutput(PrintStream printStream) {
        throw new UnsupportedOperationException("Method setConsoleOutput() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public boolean addListener(EventListener eventListener) {
        throw new UnsupportedOperationException("Method addListener() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public boolean removeListener(EventListener eventListener) {
        throw new UnsupportedOperationException("Method removeListener() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public int transactionLevel(boolean bl) throws CacheException {
        return 0;
    }

    @Override
    public boolean getDefaultLockMode() {
        throw new UnsupportedOperationException("Method getDefaultLockMode() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void setDefaultLockMode(boolean bl) {
        throw new UnsupportedOperationException("Method setDefaultLockMode() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public Utilities xmlUtils() {
        throw new UnsupportedOperationException("Method xmlUtils() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheClass getCacheClassIfLoaded(String string) throws CacheException {
        throw new UnsupportedOperationException("Method getCacheClassIfLoaded() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public String getCacheClassName(String string) throws CacheException {
        throw new UnsupportedOperationException("Method getCacheClassName() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public ClassLoader getClassLoader() {
        return null;
    }

    @Override
    public String getProcessNumber() {
        throw new UnsupportedOperationException("Method getProcessNumber() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public boolean ensureInMap(int n, String string) throws CacheException {
        throw new UnsupportedOperationException("Method ensureInMap() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void releaseFromMap(int n) throws CacheException {
        throw new UnsupportedOperationException("Method releaseFromMap() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheInputStream getInputStream(int n) throws CacheException {
        throw new UnsupportedOperationException("Method getInputStream() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheOutputStream getOutputStream(int n) throws CacheException {
        throw new UnsupportedOperationException("Method getOutputStream() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheInputStream getInputStream(CacheObject cacheObject) throws CacheException {
        throw new UnsupportedOperationException("Method getInputStream() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheOutputStream getOutputStream(CacheObject cacheObject) throws CacheException {
        throw new UnsupportedOperationException("Method getOutputStream() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public ResultSet getCacheResultSet(String string) throws CacheException {
        throw new UnsupportedOperationException("Method getCacheResultSet() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheReader getReader(int n) throws CacheException {
        throw new UnsupportedOperationException("Method getReader() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheWriter getWriter(int n) throws CacheException {
        throw new UnsupportedOperationException("Method getWriter() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheReader getReader(CacheObject cacheObject) throws CacheException {
        throw new UnsupportedOperationException("Method getReader() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheWriter getWriter(CacheObject cacheObject) throws CacheException {
        throw new UnsupportedOperationException("Method getWriter() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    public CacheField createCacheField(String string, String string2, String string3, String string4, int n, int n2, int n3) {
        throw new UnsupportedOperationException("Method createCacheField() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public int getReflectionVersion() throws CacheException {
        throw new UnsupportedOperationException("Method getReflectionVersion() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public ReadOnlyDatabase getReadOnlyDatabase() throws CacheException {
        throw new UnsupportedOperationException("Method getReadOnlyDatabase() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public SysDatabase getLightDatabase() throws CacheException {
        throw new UnsupportedOperationException("Method getLightDatabase() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public CacheObject openByKey(String string, CandidateKey candidateKey, int n) throws CacheException {
        throw new UnsupportedOperationException("Method openByKey() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public DetachedObjectsManager getDetachedObjectsManager() {
        throw new UnsupportedOperationException("Method getDetachedObjectsManager() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void setConnectionOwner(boolean bl) {
        throw new UnsupportedOperationException("Method setConnectionOwner() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        return (ConnectionInfo)this.mConnectionInfo.clone();
    }

    @Override
    public void removeClass(String string) {
        throw new UnsupportedOperationException("Method removeClass() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public String getCacheClassForJavaClassSQL() {
        throw new UnsupportedOperationException("Method getCacheClassForJavaClassSQL() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }

    @Override
    public void onConnectionClosed() {
        throw new UnsupportedOperationException("Method onConnectionClosed() is not implemented in class com.intersys.cache.serial.SerialObjectFactory");
    }
}

