/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.StreamAccessHelper;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.metadata.AbstractCacheField;
import com.intersys.cache.quick.ChidTableClass;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.Mappings;
import com.intersys.cache.quick.QuickCacheClassNew;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.QuickCollectionObject;
import com.intersys.cache.quick.QuickPersistentObject;
import com.intersys.cache.quick.QuickReaderObject;
import com.intersys.cache.quick.QuickStreamObject;
import com.intersys.classes.Compiler.LG.JavaPropDef;
import com.intersys.classes.ObjectHandle;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheOutputStream;
import com.intersys.objects.CacheWriter;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheModifier;
import com.intersys.objects.reflect.CacheSerialStorageMetadata;
import com.intersys.objects.reflect.SQLColumn;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.Date;

abstract class QuickCacheField
extends AbstractCacheField
implements Mappings,
ColumnBasedField {
    private int mColumnIdxForGet = -1;
    protected int mColumnIdxForSet = -1;
    private int mSerialStorageIdx = -1;
    protected LightDatabase mDB;
    private Boolean mEmbedded = null;

    QuickCacheField(QuickCacheClassNew quickCacheClassNew, JavaPropDef javaPropDef, boolean bl) throws CacheException {
        super((CacheClass)quickCacheClassNew, javaPropDef);
        this.mDB = (LightDatabase)quickCacheClassNew.getDatabase();
        this.init(bl);
    }

    private void init(boolean bl) {
        if (bl) {
            this.initEmbedded();
        } else {
            this.initNormal();
        }
        this.checkColumnIndices();
    }

    private void checkColumnIndices() {
        if (!this.isMappedToTable()) {
            return;
        }
        SQLColumn sQLColumn = this.getSQLColumn();
        if (sQLColumn != null) {
            CacheClass cacheClass = this.getDeclaringCacheClass();
            if (cacheClass instanceof ChidTableClass) {
                if (((ChidTableClass)cacheClass).isArray()) {
                    this.mColumnIdxForGet = sQLColumn.getNumber() - 1;
                    this.mColumnIdxForSet = sQLColumn.getNumber();
                } else if (((ChidTableClass)cacheClass).isList()) {
                    this.mColumnIdxForGet = sQLColumn.getNumber() - 2;
                    this.mColumnIdxForSet = sQLColumn.getNumber();
                }
            } else if (cacheClass.isChild()) {
                this.mColumnIdxForGet = sQLColumn.getNumber() + 1;
                this.mColumnIdxForSet = sQLColumn.getNumber();
            } else {
                this.mColumnIdxForGet = sQLColumn.getNumber();
                this.mColumnIdxForSet = sQLColumn.getNumber() - 1;
            }
        }
    }

    private void initNormal() {
    }

    private void initEmbedded() {
        String string;
        QuickCacheClassNew quickCacheClassNew = (QuickCacheClassNew)this.getDeclaringCacheClass();
        CacheSerialStorageMetadata.StorageElemt storageElemt = quickCacheClassNew.getSerialElementByName(string = this.getName());
        if (storageElemt == null) {
            return;
        }
        this.mSerialStorageIdx = storageElemt.getIndex();
    }

    public CacheField cloneForColumn(SQLColumn sQLColumn, QuickCacheClassNew quickCacheClassNew) throws CacheException {
        QuickCacheField quickCacheField = (QuickCacheField)super.cloneForColumn(sQLColumn, quickCacheClassNew);
        quickCacheField.mColumnIdxForGet = -1;
        quickCacheField.mColumnIdxForSet = -1;
        return quickCacheField;
    }

    protected CacheField cloneForSerialElement(CacheSerialStorageMetadata.StorageElemt storageElemt, QuickCacheClassNew quickCacheClassNew) throws CacheException {
        QuickCacheField quickCacheField = (QuickCacheField)this.cloneFor(quickCacheClassNew);
        quickCacheField.mSerialStorageIdx = storageElemt.getIndex();
        return quickCacheField;
    }

    protected CacheField cloneForChildTable(QuickCacheClassNew quickCacheClassNew, int n) throws CacheException {
        QuickCacheField quickCacheField = (QuickCacheField)this.cloneFor(quickCacheClassNew);
        quickCacheField.mColumnIdxForSet = n;
        return quickCacheField;
    }

    @Override
    public int getColumnIndexForGet() throws CacheException {
        if (this.mColumnIdxForGet < 0 && this.isMappedToTable()) {
            this.checkColumnIndices();
        }
        return this.mColumnIdxForGet;
    }

    @Override
    public final int getColumnIndexForSet() throws CacheException {
        if (this.mColumnIdxForSet < 0 && this.isMappedToTable()) {
            this.checkColumnIndices();
            if (this.mColumnIdxForSet < 0 && this.isCalculated() && !this.isSQLComputed()) {
                throw new CacheException("Calculated property must be also SQLComputed to be usable from Light Java Binding. Property: " + this.getName() + " of class " + this.getDeclaringCacheClass().getName());
            }
        }
        return this.mColumnIdxForSet;
    }

    @Override
    public final int getSerialStorageIndex() {
        return this.mSerialStorageIdx - 1;
    }

    @Override
    public SysDatabase getDatabase() {
        return this.mDB;
    }

    @Override
    public final boolean isEmbedded() {
        if (this.mEmbedded == null) {
            this.mEmbedded = this.isCollection() ? new Boolean(false) : (this.getSQLColumn() == null ? new Boolean(false) : new Boolean(this.getSQLColumn().isForEmbeddedObject()));
        }
        return this.mEmbedded;
    }

    @Override
    public final Object get(int n) throws CacheException {
        throw new CacheException("Not supported in this implementation.");
    }

    @Override
    public final Object get(Object object) throws CacheException {
        CacheObject cacheObject;
        if (this.isTransient() && !this.isCollection()) {
            return null;
        }
        if (object instanceof ObjectHandle) {
            cacheObject = ((ObjectHandle)object).getProxy();
        } else if (object instanceof CacheObject) {
            cacheObject = (CacheObject)object;
        } else {
            throw new CacheException("Can not get field value on object of type " + object.getClass().getName());
        }
        boolean bl = CacheModifier.isLiteral(this.getModifiers());
        Dataholder dataholder = cacheObject instanceof QuickPersistentObject && cacheObject.getCacheClass().equals(this.getDeclaringCacheClass()) ? ((QuickPersistentObject)cacheObject).getProperty(this) : cacheObject.getProperty(this.mName, !bl);
        if (this.isJavaChar() && this.isString()) {
            String string = dataholder.getString();
            if (string == null || string.length() == 0) {
                return null;
            }
            return new Character(string.charAt(0));
        }
        if (bl) {
            int n = 0;
            try {
                n = this.getJavaTypeDHType();
            }
            catch (CacheException cacheException) {
                return dataholder.getObject();
            }
            try {
                return dataholder.getObject(n);
            }
            catch (Exception exception) {
                return dataholder.getObject();
            }
        }
        CacheObject cacheObject2 = dataholder.getType() == 1028 ? this.mDB.openCacheObject(this.mTypeName, dataholder.getString()) : dataholder.getCacheObject();
        if (cacheObject2 == null) {
            return null;
        }
        return cacheObject2.newJavaInstance(true);
    }

    @Override
    public final void set(int n, Object object) throws CacheException {
        throw new CacheException("Not supported in this implementation.");
    }

    @Override
    public final void set(Object object, Object object2) throws CacheException {
        boolean bl;
        if (this.isTransient() && !this.isCollection()) {
            return;
        }
        Dataholder dataholder = null;
        if (!(object instanceof ObjectHandle)) {
            throw new CacheException("Can not set field value on object of type " + object.getClass().getName());
        }
        CacheObject cacheObject = ((ObjectHandle)object).getProxy();
        boolean bl2 = bl = !CacheModifier.isLiteral(this.getModifiers());
        if (bl && object2 instanceof ObjectHandle) {
            ObjectHandle objectHandle = (ObjectHandle)object2;
            dataholder = new Dataholder(1026, objectHandle.getProxy());
        } else if (Date.class.getName().endsWith(this.mJavaTypeName)) {
            dataholder = Dataholder.create(object2);
            dataholder = new Dataholder(64, dataholder.getDate());
        } else {
            if (this.isStream()) {
                StreamAccessHelper.setStreamValue(this, object2, cacheObject);
                return;
            }
            if (this.isCollection() && !(object2 instanceof QuickCacheObject)) {
                this.setCollection(cacheObject, object2);
                return;
            }
            dataholder = object2 != null && object2 instanceof Character && this.isJavaChar() && this.isString() ? new Dataholder(24, String.valueOf(((Character)object2).charValue())) : Dataholder.create(object2);
        }
        cacheObject.setProperty(this.mName, dataholder);
    }

    private boolean isString() {
        if (!this.isLiteral()) {
            return false;
        }
        String string = this.getTypeName();
        if ("%Library.String".equals(string)) {
            return true;
        }
        if ("%Library.CacheString".equals(string)) {
            return true;
        }
        if ("%String".equals(string)) {
            return true;
        }
        return "%CacheString".equals(string);
    }

    private boolean isJavaChar() {
        String string = this.getJavaTypeName();
        return Character.TYPE.getName().equals(string) || Character.class.getName().equals(string);
    }

    @Override
    public Writer getWriter(CacheObject cacheObject) throws CacheException {
        Dataholder dataholder = cacheObject.getProperty(this.mName, true);
        QuickReaderObject quickReaderObject = (QuickReaderObject)dataholder.getCacheObject();
        CacheWriter cacheWriter = quickReaderObject.getOut();
        return cacheWriter;
    }

    @Override
    public OutputStream getBStream(CacheObject cacheObject) throws CacheException {
        Dataholder dataholder = cacheObject.getProperty(this.mName, true);
        QuickStreamObject quickStreamObject = (QuickStreamObject)dataholder.getCacheObject();
        CacheOutputStream cacheOutputStream = quickStreamObject.getOut();
        return cacheOutputStream;
    }

    private void setCollection(CacheObject cacheObject, Object object) throws CacheException {
        Dataholder dataholder = cacheObject.getProperty(this.mName, !this.isLiteral());
        QuickCollectionObject quickCollectionObject = (QuickCollectionObject)dataholder.getCacheObject();
        quickCollectionObject.setCollection(object);
    }
}

