/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.quick.DBAdapter;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.QuickBulkInsertWorker;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheServerException;

public class QuickBulkInsertWorkerPT
extends QuickBulkInsertWorker {
    private DBAdapter mDBAdapter;
    private String mDBProcess;
    private int mNoLock;
    private Worker mWorker;

    public QuickBulkInsertWorkerPT(LightDatabase lightDatabase, int n) {
        this.mDBAdapter = lightDatabase.myAdapter();
        this.mDBProcess = lightDatabase.getServerInfo().processNumberString;
        this.mNoLock = n;
    }

    @Override
    public synchronized void doIt(String string, String string2, Object object) throws CacheServerException {
        this.mDBAdapter.bulkCreateNoIds(string, string2, 4, object, this.mNoLock);
    }

    @Override
    public synchronized void doConcurrently(String string, String string2, Object object) throws Exception {
        Exception exception;
        if (this.mWorker == null) {
            this.mWorker = new Worker();
            this.mWorker.start();
        }
        if ((exception = this.mWorker.getException()) != null) {
            throw exception;
        }
        this.mWorker.submit(string, string2, object);
    }

    @Override
    public void checkForException() throws Exception {
        if (this.mWorker == null) {
            return;
        }
        Exception exception = this.mWorker.getException();
        if (exception != null) {
            throw exception;
        }
    }

    private class Worker
    extends Thread {
        private String schema;
        private String table;
        private Object wire;
        private Exception mException;
        private boolean isBusy;

        private Worker() {
            super("Bulk Insert Worker - " + QuickBulkInsertWorkerPT.this.mDBProcess);
            this.setDaemon(true);
            this.isBusy = false;
        }

        public synchronized void submit(String string, String string2, Object object) throws InterruptedException {
            while (this.isBusy) {
                this.wait();
            }
            this.setData(string, string2, object);
            this.isBusy = true;
            this.notify();
        }

        public void setData(String string, String string2, Object object) {
            this.schema = string;
            this.table = string2;
            this.wire = SysListProxy.createSysList(SysListProxy.getBinaryData(object), true, SysListProxy.getConnectionInfo(object));
            this.mException = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exception getException() {
            Worker worker = this;
            synchronized (worker) {
                while (this.isBusy) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return interruptedException;
                    }
                }
            }
            return this.mException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Worker worker = this;
                synchronized (worker) {
                    while (!this.isBusy) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.mException = interruptedException;
                            return;
                        }
                    }
                    this.process();
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process() {
            try {
                QuickBulkInsertWorkerPT.this.doIt(this.schema, this.table, this.wire);
            }
            catch (CacheServerException cacheServerException) {
                this.mException = cacheServerException;
            }
            finally {
                this.isBusy = false;
            }
        }
    }
}

