/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.Dataholder;
import com.intersys.cache.metadata.CacheClassMetadataImpl;
import com.intersys.cache.metadata.Dictionary;
import com.intersys.classes.Compiler.LG.JavaClassDef;
import com.intersys.classes.Compiler.LG.JavaClassDefPointer;
import com.intersys.classes.Compiler.LG.JavaElemDef;
import com.intersys.classes.Compiler.LG.MetaElemDef;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheNullValueException;
import com.intersys.objects.reflect.AbstractElementInfoImpl;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassMetadata;
import com.intersys.objects.reflect.CacheElementInfo;
import com.intersys.objects.reflect.TypeModifierHelper;

class CacheElementMetadataImpl
extends AbstractElementInfoImpl
implements CacheElementInfo {
    protected Dictionary mDictionary;
    protected String mName;
    protected String mJavaName;
    protected Object mDefaultValue;
    protected String mDefaultValueString;
    protected CacheClassMetadataImpl mType;
    protected String mTypeName;
    protected String mElementTypeName;
    private int mJavaTypeDHType = -1;
    protected String mJavaTypeName;
    protected int mModifier;
    protected int mTypeModifier;
    protected int mClientTypeId;
    protected String mAccessorName;
    private int mJDBCType = -1;
    private String mRealClass;
    private boolean mRealClassSet = false;
    protected MetaElemDef mElemDef;
    protected JavaElemDef mJElemDef;

    public CacheElementMetadataImpl(CacheClassMetadataImpl cacheClassMetadataImpl, JavaElemDef javaElemDef, MetaElemDef metaElemDef) throws CacheException {
        JavaClassDefPointer javaClassDefPointer;
        JavaClassDef javaClassDef;
        int n;
        this.mElemDef = metaElemDef;
        this.mJElemDef = javaElemDef;
        this.mDictionary = cacheClassMetadataImpl.getDictionary();
        try {
            n = this.mElemDef.getclientObjTypeClassifier();
            this.classifyObject(n);
        }
        catch (CacheNullValueException cacheNullValueException) {
            // empty catch block
        }
        n = -1;
        try {
            n = this.mElemDef.getclientObjTypeId();
        }
        catch (CacheNullValueException cacheNullValueException) {
            // empty catch block
        }
        Integer n2 = this.mElemDef.getclientTypeId();
        this.mClientTypeId = n2 == null ? 0 : n2;
        if (CacheElementMetadataImpl.isLiteral(n2)) {
            this.addModifier(16);
        }
        if (n >= 0) {
            int n3 = 0;
            try {
                int n4 = this.mElemDef.getcolnElemTypeId();
                n3 = n4 == 4 ? this.mElemDef.getcolnElemObjTypeClassifier() : 0;
            }
            catch (CacheNullValueException cacheNullValueException) {
                // empty catch block
            }
            this.processObjectType(n, n3);
        }
        if ((javaClassDef = (JavaClassDef)(javaClassDefPointer = this.mJElemDef.getcacheType()).getJavaClassDef()) != null) {
            this.mType = (CacheClassMetadataImpl)cacheClassMetadataImpl.getAClass(javaClassDef);
        } else {
            this.mTypeName = cacheClassMetadataImpl.lookupName(javaClassDefPointer.getName());
        }
        this.mJavaTypeName = cacheClassMetadataImpl.lookupName(this.mJElemDef.gettype());
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final String getJavaName() {
        return this.mJavaName;
    }

    @Override
    public final String getDefaultValueString() {
        return this.mDefaultValueString;
    }

    @Override
    public final Object getDefaultValue() {
        return this.mDefaultValue;
    }

    @Override
    public final CacheClass getType() throws CacheException {
        if (this.mType == null) {
            this.mType = (CacheClassMetadataImpl)this.getTypeInternal();
        }
        return this.mType;
    }

    @Override
    public final String getTypeName() {
        if (this.mTypeName == null && this.mType != null) {
            this.mTypeName = this.mType.getName();
        }
        return this.mTypeName;
    }

    @Override
    public final String getElementTypeName() {
        return this.mElementTypeName;
    }

    @Override
    public final String getJavaTypeName() {
        return this.mJavaTypeName;
    }

    public final int getJavaTypeDHType() throws CacheException {
        if (this.mJavaTypeDHType < 0) {
            this.mJavaTypeDHType = Dataholder.toIntType(this.mJavaTypeName);
        }
        return this.mJavaTypeDHType;
    }

    @Override
    public final int getModifiers() {
        return this.mModifier;
    }

    @Override
    public final int getTypeModifiers() {
        return this.mTypeModifier;
    }

    public final void addModifier(int n) {
        this.mModifier |= n;
    }

    public final void addTypeModifier(int n) {
        this.mTypeModifier |= n;
    }

    @Override
    public boolean isLiteral(boolean bl) {
        return TypeModifierHelper.isPrimitive(this.mClientTypeId, bl);
    }

    protected static boolean isLiteral(Integer n) {
        if (n == null) {
            return false;
        }
        return TypeModifierHelper.isPrimitive(n, true);
    }

    protected CacheClassMetadata getTypeInternal() throws CacheException {
        return null;
    }

    protected void classifyObject(int n) {
        if (n == 1) {
            this.addTypeModifier(4608);
        }
        if (n == 2) {
            this.addTypeModifier(8704);
        }
    }

    protected void processObjectType(int n, int n2) {
        switch (n) {
            case 1: {
                this.addTypeModifier(264);
                break;
            }
            case 2: {
                this.addTypeModifier(257);
                break;
            }
            case 3: {
                this.addTypeModifier(520);
                break;
            }
            case 4: {
                this.addTypeModifier(513);
                break;
            }
            case 5: {
                this.addTypeModifier(17);
                break;
            }
            case 6: {
                this.addTypeModifier(32);
                this.addTypeModifier(512);
                break;
            }
            case 7: {
                this.addTypeModifier(64);
                this.addTypeModifier(512);
                break;
            }
            default: {
                return;
            }
        }
        int n3 = 8192;
        this.mTypeModifier &= ~n3;
        this.classifyObject(n2);
    }

    @Override
    public int getClientTypeId() {
        return this.mClientTypeId;
    }

    @Override
    public String getAccessorName() throws CacheException {
        if (this.mAccessorName == null) {
            this.mAccessorName = this.mDictionary.lookup(this.mJElemDef.getAccessorName());
        }
        return this.mAccessorName;
    }

    @Override
    public int getJDBCType() throws CacheException {
        if (this.mJDBCType == -1) {
            this.mJDBCType = this.mJElemDef.getJDBCType();
        }
        return this.mJDBCType;
    }

    @Override
    public String getRealClass() throws CacheException {
        if (!this.mRealClassSet) {
            this.mRealClassSet = true;
            this.mRealClass = this.mDictionary.lookup(this.mJElemDef.getRealClass());
        }
        return this.mRealClass;
    }
}

