/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jni;

import com.intersys.cache.AbstractCacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jni.CacheJNI;
import com.intersys.cache.jni.CallinException;
import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;

public class CacheExternalOref
extends AbstractCacheObject {
    static final int CLOSED_OREF = -123;
    protected SysDatabase mDB;
    protected String mTypeName;
    private int mRef = -123;
    protected int mServerSideReferences = 0;
    protected CacheClass mCacheClass = null;
    private Object mUserData = null;
    private int mOrefBeforeClose = 0;
    private int mCount = -1;
    private int mOnHold = 0;
    private Oid mOid = null;

    public CacheExternalOref() throws CacheException {
        super(null, "", 0);
        this.mRef = this.init();
    }

    public CacheExternalOref(CacheExternalOref cacheExternalOref) throws CacheException {
        super(null, "", cacheExternalOref.mRef);
        try {
            this.incrementRefCount();
        }
        catch (CallinException callinException) {
            this.mRef = -123;
            throw callinException;
        }
    }

    protected CacheExternalOref(int n) {
        super(null, "", n);
    }

    @Override
    public final Object getZRef() throws CacheException {
        int n = this.getOref();
        return String.valueOf(n) + "@" + this.mTypeName;
    }

    private Id getIdInternal() throws CacheException {
        CacheJNI.getLock();
        CacheJNI.native_PushMethod(this.mRef, "%Id", 1);
        CacheJNI.InvokeMethod(0);
        String string = CacheJNI.PopString();
        CacheJNI.releaseLock();
        return new Id(string);
    }

    @Override
    public void delete() throws CacheException {
    }

    @Override
    public Dataholder getProperty(String string, boolean bl) throws CacheException {
        return null;
    }

    @Override
    public void setProperty(String string, Dataholder dataholder) throws CacheException {
    }

    @Override
    public Dataholder getProperty(int n, int n2, int n3, String string) throws CacheException {
        return null;
    }

    @Override
    public void setProperty(int n, int n2, int n3, int n4, String string, Dataholder dataholder) throws CacheException {
    }

    @Override
    public Oid getOid() throws CacheException {
        return this.getOidInternal();
    }

    @Override
    protected Oid getOidInternal() throws CacheException {
        CacheJNI.getLock();
        CacheJNI.native_PushMethod(this.mRef, "%Oid", 1);
        CacheJNI.InvokeMethod(0);
        String string = CacheJNI.PopString();
        CacheJNI.releaseLock();
        return new Oid(string);
    }

    public int save() throws CacheException {
        CacheJNI.getLock();
        CacheJNI.native_PushMethod(this.mRef, "%Save", 1);
        CacheJNI.InvokeMethod(0);
        int n = CacheJNI.PopInt();
        CacheJNI.releaseLock();
        return 1;
    }

    @Override
    public Dataholder[] runInstanceMethod(String string, int[] nArray, Dataholder[] dataholderArray, int n) throws CacheException {
        return null;
    }

    @Override
    public Dataholder runInstanceMethod(String string, Dataholder[] dataholderArray, int n) throws CacheException {
        try {
            CacheJNI.getLock();
            if (n == 3) {
                CacheJNI.native_PushMethod(this.mRef, string, 0);
            } else {
                CacheJNI.native_PushMethod(this.mRef, string, 1);
            }
            int n2 = dataholderArray.length;
            for (int i = 0; i < n2; ++i) {
            }
            CacheJNI.InvokeMethod(0);
            CacheJNI.releaseLock();
        }
        catch (CallinException callinException) {
            CacheJNI.releaseLock();
            throw callinException;
        }
        return null;
    }

    @Override
    public int getState() {
        throw new UnsupportedOperationException("Method getState() is not implemented in class com.intersys.cache.jni.CacheExternalOref");
    }

    @Override
    public void clearReadState() {
        throw new UnsupportedOperationException("Method clearReadState() is not implemented in class com.intersys.cache.jni.CacheExternalOref");
    }

    @Override
    public CacheClass getCacheClass() throws CacheException {
        if (this.mCacheClass == null) {
            try {
                CacheJNI.getLock();
                CacheJNI.native_PushMethod(this.mRef, "%ClassName", 1);
                CacheJNI.InvokeMethod(0);
                String string = CacheJNI.PopString();
                CacheJNI.releaseLock();
                this.mTypeName = string;
            }
            catch (CallinException callinException) {
                CacheJNI.releaseLock();
                throw callinException;
            }
        }
        return this.mCacheClass;
    }

    @Override
    public void setCacheClass(CacheClass cacheClass) throws CacheException {
        if (this.mCacheClass != null && !this.mCacheClass.equals(cacheClass)) {
            throw new SystemError("Attempt to replace CacheClass");
        }
        this.mCacheClass = cacheClass;
        this.mTypeName = this.mCacheClass.getName();
    }

    protected void incrementRefCount() throws CallinException {
        CacheJNI.getLock();
        try {
            CacheJNI.CloseOref(this.mRef);
        }
        catch (CallinException callinException) {
            // empty catch block
        }
        CacheJNI.releaseLock();
    }

    @Override
    protected void finalize() throws Throwable {
        CacheJNI.getLock();
        try {
            CacheJNI.CloseOref(this.mRef);
        }
        catch (CallinException callinException) {
            // empty catch block
        }
        CacheJNI.releaseLock();
    }

    @Override
    protected void close() throws CacheException {
    }

    protected int init() throws CacheException {
        return -123;
    }

    protected int init(String string, boolean bl) throws CacheException {
        return this.init();
    }
}

