/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.mail;

import com.dbeaver.data.transfer.mail.SMTPAuthentication;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class SMTPProfile {
    private static final String TEST_PING_MAIL = "non-existent-mail";
    private final String id;
    private final String hostname;
    private final int port;
    private final SMTPAuthentication authentication;

    public SMTPProfile(@NotNull String id, @NotNull String hostname, int port, @Nullable SMTPAuthentication authentication) {
        this.id = id;
        this.hostname = hostname;
        this.port = port;
        this.authentication = authentication;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public SMTPAuthentication getAuthentication() {
        return this.authentication;
    }

    @Nullable
    public Authenticator createAuthenticator() {
        if (this.authentication != null) {
            return new ProfileAuthenticator(this.authentication);
        }
        return null;
    }

    public void testConnection(@NotNull DBRProgressMonitor monitor) throws DBException {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", this.hostname);
        properties.put("mail.smtp.port", (Object)this.port);
        properties.put("mail.smtp.auth", (Object)(this.authentication != null ? 1 : 0));
        properties.put("mail.smtp.starttls.enable", (Object)true);
        try {
            Session session = Session.getInstance((Properties)properties, (Authenticator)this.createAuthenticator());
            InternetAddress address = new InternetAddress(this.authentication != null ? this.authentication.getUsername() : TEST_PING_MAIL);
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (Transport transport = session.getTransport((Address)address);){
                    monitor.beginTask("Connecting to SMTP server", 1);
                    transport.connect();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                monitor.done();
            }
        }
        catch (MessagingException e) {
            throw new DBException("Error establishing SMTP connection", (Throwable)e);
        }
    }

    public String toString() {
        if (this.authentication != null) {
            return String.valueOf(this.authentication.getUsername()) + " (" + this.hostname + ":" + this.port + ")";
        }
        return String.valueOf(this.hostname) + ":" + this.port;
    }

    private static class ProfileAuthenticator
    extends Authenticator {
        private final SMTPAuthentication authentication;

        public ProfileAuthenticator(@NotNull SMTPAuthentication authentication) {
            this.authentication = authentication;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.authentication.getUsername(), this.authentication.getPassword());
        }
    }
}

