/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.sql;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.netezza.Driver;
import org.netezza.core.Encoding;
import org.netezza.datasource.NzDatasource;
import org.netezza.error.NzFeatureNotSupportedException;
import org.netezza.error.NzMethodNotImplementedException;
import org.netezza.error.NzSQLException;
import org.netezza.error.NzUnknownBackendResponseException;
import org.netezza.internal.ColumnMetadata;
import org.netezza.internal.NZDigest;
import org.netezza.internal.NzFeature;
import org.netezza.internal.NzKrb5GSSAuthentication;
import org.netezza.internal.NzNumeric;
import org.netezza.internal.NzQuery;
import org.netezza.internal.NzSimpleQuery;
import org.netezza.internal.NzSocket;
import org.netezza.internal.NzType;
import org.netezza.internal.ParseException;
import org.netezza.internal.PgProtocol;
import org.netezza.internal.QueryExecutor;
import org.netezza.internal.Tuple;
import org.netezza.internal.UnixCrypt;
import org.netezza.logging.LogLevel;
import org.netezza.logging.Logger;
import org.netezza.logging.LoggerFactory;
import org.netezza.logging.LoggerType;
import org.netezza.sql.NzCallableStatement;
import org.netezza.sql.NzDatabaseMetadata;
import org.netezza.sql.NzPreparedStatament;
import org.netezza.sql.NzResultSet;
import org.netezza.sql.NzResultSetMetadata;
import org.netezza.sql.NzStatement;
import org.netezza.util.ComProtocol;
import org.netezza.util.NzSecurityLevel;

public class NzConnection
implements Connection {
    private final NzDatasource datasource;
    public Logger LOGGER;
    private final Initializer INITIALIZER;
    private int comProtocolVersion = 3;
    private Driver driver;
    private PgProtocol pgProtocol;
    public int pid;
    public int client_pid;
    public int ckey;
    private int databaseMajorVersion;
    private int databaseVersion;
    private int databaseMinorVersion;
    private int databaseSubMinorVersion;
    private String about;
    public boolean transactionBegun = false;
    public boolean isTLSSecurity = false;
    public boolean isHostSSL = false;
    public SQLWarning warning = null;
    private byte[] buffer = new byte[8192];
    public boolean stopLoading;
    public boolean loading = false;
    private NzSocket socket;
    private boolean analyze = false;
    private boolean isReOpened = false;
    public static final short NOT_CONNECTED = 0;
    public static final short CONNECTED = 1;
    public static final short EXECUTING = 2;
    public static final short FETCHING = 3;
    public static final short CANCELLED = 4;
    public static final short INITIALIZING = 5;
    public short STATE = 0;
    private QueryExecutor executor;
    private boolean upperCase;
    private NzDatabaseMetadata metadata;
    private int isolationLevel;
    private Properties clientInfo;
    private static final String PROCESSOR_BITS = System.getProperty("sun.arch.data.model") + "-BIT";
    private static final String USER_NAME = System.getProperty("user.name") != null ? System.getProperty("user.name") : System.getenv("USERNAME");
    private static final String OS_NAME = System.getProperty("os.name");
    private int commandNumber;
    private boolean readOnly = false;
    private boolean autoCommit = true;
    private boolean bulkLoad;
    private Map<String, Class<?>> typeMap;
    public static final float JDBC_SPEC_VERSION;

    public NzConnection(NzDatasource datasource) {
        this.datasource = datasource;
        this.INITIALIZER = new Initializer();
        this.pgProtocol = PgProtocol.getLatest();
        this.metadata = new NzDatabaseMetadata(this);
        this.isolationLevel = 2;
        this.typeMap = new HashMap();
        this.commandNumber = -1;
        this.clientInfo = new Properties();
        this.clientInfo.put("applicationName", this.datasource.getClientApplicationName());
        this.clientInfo.put("clientUser", this.datasource.getClientUser());
        this.clientInfo.put("clientHostName", this.datasource.getClientHostName());
    }

    public void open() throws SQLException {
        block10: {
            String method = "open";
            this.LOGGER = LoggerFactory.LOGGER_FACTORY.getLogger(LoggerType.getLoggerType(this.datasource.getLoggerType()), LogLevel.valueOf(this.datasource.getLogLevel()), this.datasource.getLogDirPath());
            this.LOGGER.entry(NzConnection.class, "open");
            this.LOGGER.info(NzConnection.class, "open", "\nConnection Properties: \n" + Driver.toString(this.datasource, true));
            this.validateDatasource();
            this.LOGGER.info(NzConnection.class, "open", "Initializing Socket");
            this.initSocket();
            this.LOGGER.info(NzConnection.class, "open", "Initializing Connection");
            try {
                this.INITIALIZER.init();
            }
            catch (IOException e) {
                if (NzSecurityLevel.getSecurityLevel(this.datasource.getSecurityLevel()) == NzSecurityLevel.preferredSecured || NzSecurityLevel.getSecurityLevel(this.datasource.getSecurityLevel()) == NzSecurityLevel.onlySecured || NzSecurityLevel.getSecurityLevel(this.datasource.getSecurityLevel()) == NzSecurityLevel.preferredUnsecured && this.isHostSSL) {
                    this.isTLSSecurity = true;
                    this.isReOpened = true;
                    try {
                        this.INITIALIZER.init();
                    }
                    catch (IOException eReOpened) {
                        if (NzSecurityLevel.getSecurityLevel(this.datasource.getSecurityLevel()) == NzSecurityLevel.preferredSecured) {
                            this.datasource.setSecurityLevel(NzSecurityLevel.onlyUnsecured.toString());
                            this.isReOpened = true;
                            try {
                                this.INITIALIZER.init();
                            }
                            catch (IOException enotpossible) {
                                enotpossible.printStackTrace();
                            }
                            break block10;
                        }
                        NzSQLException etothrow = new NzSQLException(eReOpened.getMessage(), "08001", 1114, new Object[0]);
                        this.LOGGER.fatal(NzConnection.class, "open", etothrow);
                        throw etothrow;
                    }
                }
                NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
                this.LOGGER.fatal(NzConnection.class, "open", etothrow);
                throw etothrow;
            }
        }
        this.STATE = 1;
        this.executor = new QueryExecutor(this);
        this.commandNumber = -1;
        this.setBackendProperties();
        this.LOGGER.info(this.getClass(), "open", "Getting Version Information");
        this.getBackendVersion();
        this.LOGGER.info(this.getClass(), "open", "Setting client (driver) version to back end.");
        this.setClientVersion();
        this.LOGGER.info(this.getClass(), "open", "Setting schema to back end.");
        this.setSchema(this.datasource.getCurrentSchema());
        this.LOGGER.info(this.getClass(), "open", "Getting Supported Features");
        this.getSupportedDatabaseFeatures();
        this.getBackendInfo();
        this.LOGGER.info(this.getClass(), "open", "Logging driver version in pg.log file");
        this.logDriverVersionInBackendLog();
        this.setAutoCommit(this.datasource.isAutoCommit());
        this.setReadOnly(this.datasource.isReadOnly());
        try {
            this.setClientInfo("applicationName", this.clientInfo.getProperty("applicationName"));
            this.setClientInfo("clientUser", this.clientInfo.getProperty("clientUser"));
            this.setClientInfo("clientHostName", this.clientInfo.getProperty("clientHostName"));
        }
        catch (SQLClientInfoException e) {
            throw new SQLException(e.getMessage());
        }
        this.commandNumber = 1;
        this.LOGGER.exit(this.getClass(), "open");
    }

    public void addWarning(String msg) {
        String method = "addWarning";
        this.LOGGER.entry(this.getClass(), method, msg);
        if (this.warning != null) {
            this.warning.setNextWarning(new SQLWarning(msg));
        } else {
            this.warning = new SQLWarning(msg);
        }
        this.LOGGER.exit(this.getClass(), method);
    }

    public void sendInt(int i, int size) throws SQLException {
        byte[] buf = new byte[size];
        while (size-- > 0) {
            buf[size] = (byte)(i & 0xFF);
            i >>= 8;
        }
        this.sendBytes(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChar(char val) throws SQLException {
        try {
            NzSocket nzSocket = this.socket;
            synchronized (nzSocket) {
                this.socket.sendChar(val);
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), "sendChar", e);
            throw etothrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendByte(byte b) throws SQLException {
        try {
            NzSocket nzSocket = this.socket;
            synchronized (nzSocket) {
                this.socket.sendByte(b);
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), "sendByte", e);
            throw etothrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBytes(byte[] bs) throws SQLException {
        try {
            NzSocket nzSocket = this.socket;
            synchronized (nzSocket) {
                this.socket.sendBytes(bs);
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), "sendBytes", e);
            throw etothrow;
        }
    }

    public void sendBytes(byte[] bs, int len) throws SQLException {
        this.sendBytes(bs, 0, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBytes(byte[] bs, int off, int len) throws SQLException {
        try {
            NzSocket nzSocket = this.socket;
            synchronized (nzSocket) {
                this.socket.sendBytes(bs, off, len);
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), "sendBytes", e);
            throw etothrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte receiveByte() throws SQLException {
        try {
            NzSocket nzSocket = this.socket;
            synchronized (nzSocket) {
                return this.socket.receiveByte();
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), "receiveByte", e);
            throw etothrow;
        }
    }

    public char receiveChar() throws SQLException {
        return (char)this.receiveByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveInt() throws SQLException {
        try {
            NzSocket nzSocket = this.socket;
            synchronized (nzSocket) {
                return this.socket.receiveInt();
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), "receiveInt", e);
            throw etothrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveInt(int len) throws SQLException {
        try {
            NzSocket nzSocket = this.socket;
            synchronized (nzSocket) {
                return this.socket.receiveInt(len);
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), "receiveInt", e);
            throw etothrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveIntR(int len) throws SQLException {
        try {
            NzSocket nzSocket = this.socket;
            synchronized (nzSocket) {
                return this.socket.receiveIntR(len);
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), "receiveIntR", e);
            throw etothrow;
        }
    }

    public String receiveString() throws SQLException {
        return this.receiveString(Encoding.UNICODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String receiveString(Encoding encoding) throws SQLException {
        int s = 0;
        byte[] bs = this.buffer;
        try {
            int buflen = bs.length;
            boolean done = false;
            block5: while (!done) {
                while (s < buflen) {
                    int c;
                    NzSocket nzSocket = this.socket;
                    synchronized (nzSocket) {
                        c = this.socket.receiveInt();
                    }
                    if (c < 0) {
                        throw new NzSQLException("netezza.con.closed.illegal.op", "HY000", 1115, new Object[0]);
                    }
                    if (c == 0) {
                        bs[s] = 0;
                        done = true;
                        continue block5;
                    }
                    bs[s++] = (byte)c;
                    if (s < buflen) continue;
                    byte[] newrst = new byte[buflen *= 2];
                    System.arraycopy(bs, 0, newrst, 0, s);
                    bs = newrst;
                }
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), "receiveString", e);
            throw etothrow;
        }
        return encoding.decode(bs, 0, s);
    }

    public Tuple receivePgTuple(int columncount) throws SQLException {
        int numberOfBits = (columncount + 7) / 8;
        byte[] bitmask = this.receiveBytes(numberOfBits);
        byte[][] answer = new byte[columncount][0];
        int whichbit = 128;
        int whichbyte = 0;
        for (int i = 0; i < columncount; ++i) {
            boolean isNull;
            boolean bl = isNull = (bitmask[whichbyte] & whichbit) == 0;
            if (isNull) {
                answer[i] = null;
            } else {
                int length = this.receiveIntR(4);
                if ((length -= 4) < 0) {
                    length = 0;
                }
                answer[i] = this.receiveBytes(length);
            }
            if ((whichbit >>= 1) != 0) continue;
            ++whichbyte;
            whichbit = 128;
        }
        return new Tuple(answer);
    }

    public Tuple receiveDbosTuple(NzResultSetMetadata metadata) throws SQLException {
        int tupleLength = this.receiveIntR(4);
        if (tupleLength > metadata.getMaxRecordSize()) {
            metadata.setMaxRecordSize(tupleLength);
        }
        byte[] tupleData = new byte[tupleLength];
        this.receiveBytes(tupleData, 0, tupleLength);
        int columnCount = metadata.getColumnCount();
        byte[][] finalData = new byte[columnCount][];
        for (int i = 0; i < finalData.length; ++i) {
            ColumnMetadata columnMetadata = metadata.getColumnMetadata(i + 1);
            int length = columnMetadata.getSize();
            if (this.isNull(metadata, tupleData, i)) {
                finalData[i] = null;
                continue;
            }
            if (columnMetadata.getFixedSize() != 0) {
                if (columnMetadata.getType() == NzType.NZ_NUMERIC) {
                    int size = columnMetadata.getSize();
                    int prec = size >> 8 & 0x7F;
                    int numParts = NzNumeric.getNumParts(prec);
                    length = numParts * 4;
                }
                byte[] value = new byte[length];
                int offset = columnMetadata.getOffset();
                System.arraycopy(tupleData, offset, value, 0, length);
                finalData[i] = value;
                continue;
            }
            int len = metadata.getFixedFieldsSize();
            for (int j = 0; j < columnMetadata.getOffset(); ++j) {
                int value = tupleData[len] & 0xFF;
                value = (tupleData[len + 1] & 0xFF) << 8 | value;
                len += value + 1 & 0xFFFFFFFE;
            }
            int strlen = tupleData[len] & 0xFF;
            strlen = (tupleData[len + 1] & 0xFF) << 8 | strlen;
            strlen -= 2;
            len += 2;
            if (columnMetadata.getType() == NzType.NZ_VARFIXEDCHAR) {
                finalData[i] = new byte[length];
                System.arraycopy(tupleData, len, finalData[i], 0, strlen);
                for (int j = strlen; j < length; ++j) {
                    finalData[i][j] = 32;
                }
                continue;
            }
            if (columnMetadata.getType() == NzType.NZ_NCHAR) {
                int charCount = 0;
                for (int in = len; in < strlen + len; ++in) {
                    ++charCount;
                    if ((tupleData[in] & 0x80) == 0) continue;
                    if ((tupleData[in] & 0xFE) == 252) {
                        in += 5;
                        continue;
                    }
                    if ((tupleData[in] & 0xFC) == 248) {
                        in += 4;
                        continue;
                    }
                    if ((tupleData[in] & 0xF8) == 240) {
                        in += 3;
                        continue;
                    }
                    if ((tupleData[in] & 0xF0) == 224) {
                        in += 2;
                        continue;
                    }
                    if ((tupleData[in] & 0xE0) != 192) continue;
                    ++in;
                }
                finalData[i] = new byte[strlen + (length - charCount)];
                System.arraycopy(tupleData, len, finalData[i], 0, strlen);
                for (int j = 0; j < length - charCount; ++j) {
                    finalData[i][strlen + j] = 32;
                }
                continue;
            }
            finalData[i] = new byte[strlen];
            System.arraycopy(tupleData, len, finalData[i], 0, strlen);
        }
        return new Tuple(finalData);
    }

    public byte[] receiveBytes(int len) throws SQLException {
        byte[] bs = new byte[len];
        this.receiveBytes(bs, 0, len);
        return bs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveBytes(byte[] b, int off, int len) throws SQLException {
        try {
            NzSocket nzSocket = this.socket;
            synchronized (nzSocket) {
                return this.socket.receiveBytes(b, off, len);
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), "receiveBytes", e);
            throw etothrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws SQLException {
        try {
            NzSocket nzSocket = this.socket;
            synchronized (nzSocket) {
                this.socket.flush();
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
            this.LOGGER.fatal(NzConnection.class, "flush", etothrow.getMessage());
            throw etothrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSocket() throws SQLException {
        char c = '\u0000';
        int cmdlength = -1;
        try {
            while (true) {
                NzSocket nzSocket = this.socket;
                synchronized (nzSocket) {
                    c = this.socket.receiveChar();
                }
                if (c < '\u0000') {
                    throw new NzSQLException("netezza.con.closed.illegal.op", "HY000", 1115, new Object[0]);
                }
                if (c == 'Z') {
                    this.receiveIntR(4);
                    this.receiveIntR(4);
                    return;
                }
                this.receiveIntR(4);
                cmdlength = this.receiveIntR(4);
                this.receiveBytes(cmdlength);
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
            this.LOGGER.fatal(NzConnection.class, "clearSocket", etothrow.getMessage());
            throw etothrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSocket() throws SQLException {
        try {
            NzSocket nzSocket = this.socket;
            synchronized (nzSocket) {
                this.socket.resetSocket();
            }
            this.STATE = 1;
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
            this.LOGGER.fatal(NzConnection.class, "resetSocket", etothrow.getMessage());
            throw etothrow;
        }
    }

    public void clearUnloadData() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataAvailable(long readTimeout) throws SQLException {
        try {
            NzSocket nzSocket = this.socket;
            synchronized (nzSocket) {
                return this.socket.isDataAvailable(readTimeout);
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
            this.LOGGER.fatal(NzConnection.class, "isDataAvailable", etothrow.getMessage());
            throw etothrow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshStreams(Socket socket) throws SQLException {
        try {
            Socket socket2 = socket;
            synchronized (socket2) {
                this.socket.refreshStreams(socket);
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
            this.LOGGER.fatal(NzConnection.class, "refreshStreams", etothrow);
            throw etothrow;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new NzStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new NzPreparedStatament(this, sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return new NzSimpleQuery(sql).parse().toNativeString();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        String method = "setAutoCommit";
        this.LOGGER.entry(this.getClass(), method, autoCommit);
        if (this.autoCommit != autoCommit) {
            if (!this.autoCommit && this.transactionBegun) {
                this.commit();
            }
            this.autoCommit = autoCommit;
        }
        this.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        String method = "commit";
        this.LOGGER.entry(this.getClass(), method);
        if (this.getAutoCommit()) {
            NzSQLException etothrow = new NzSQLException("netezza.con.mode.autocommit", "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        this.execute(NzQuery.COMMIT_QUERY);
        this.transactionBegun = false;
        this.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public void rollback() throws SQLException {
        String method = "rollback";
        this.LOGGER.entry(this.getClass(), method);
        if (!this.getAutoCommit()) {
            if (!this.transactionBegun) {
                return;
            }
        } else {
            NzSQLException etothrow = new NzSQLException("netezza.con.mode.autocommit", "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        this.execute(NzQuery.ROLLBACK_QUERY);
        this.transactionBegun = false;
        this.LOGGER.exit(this.getClass(), method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        String method = "close";
        if (this.socket != null) {
            try {
                NzSocket nzSocket = this.socket;
                synchronized (nzSocket) {
                    if (this.socket.getSocket() != null) {
                        this.socket.sendChar('X');
                        this.LOGGER.info(this.getClass(), method, "Flushing stream.....");
                        this.socket.flush();
                        this.LOGGER.info(this.getClass(), method, "Closing stream.....");
                        this.socket.close();
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.socket == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        String method = "setReadOnly";
        this.LOGGER.entry(this.getClass(), method, readOnly);
        if (this.readOnly != readOnly) {
            String stxnCh = readOnly ? "read only" : "read write";
            NzSimpleQuery query = new NzSimpleQuery("set session " + stxnCh);
            this.execute(query);
            this.readOnly = readOnly;
        }
        this.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        String method = "setCatalog";
        this.LOGGER.entry(this.getClass(), method, catalog);
        this.close();
        if (catalog != null) {
            String backup = this.datasource.getDatabase();
            try {
                this.LOGGER.info(this.getClass(), method, "Reconnecting with : " + catalog);
                this.reconnect(catalog);
            }
            catch (SQLException e) {
                this.LOGGER.info(this.getClass(), method, "Reconnecting with : " + backup);
                this.reconnect(backup);
            }
        }
        this.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.datasource.getDatabase();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        String method = "setTransactionIsolation";
        this.LOGGER.entry(this.getClass(), method, level);
        String isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL ";
        switch (level) {
            case 2: {
                isolationLevelSQL = isolationLevelSQL + "READ COMMITTED";
                this.isolationLevel = 2;
                break;
            }
            case 8: {
                isolationLevelSQL = isolationLevelSQL + "SERIALIZABLE";
                this.isolationLevel = 8;
                break;
            }
            default: {
                throw new NzSQLException("netezza.trans.isolation.level.invalid", "HY000", 1131, level);
            }
        }
        NzSimpleQuery query = new NzSimpleQuery(isolationLevelSQL);
        this.execute(query);
        this.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        String method = "getTransactionIsolation";
        this.LOGGER.entry(this.getClass(), method);
        String level = null;
        SQLWarning saveWarnings = this.getWarnings();
        this.clearWarnings();
        NzResultSet rs = this.execute(NzQuery.GET_TRANSACTION_ISOLATION_QUERY);
        if (rs != null && rs.next()) {
            level = rs.getString(1);
            rs.close();
        } else {
            SQLWarning warning = this.getWarnings();
            if (warning != null) {
                level = warning.getMessage();
            }
            this.clearWarnings();
        }
        this.LOGGER.info(this.getClass(), method, "Level : " + level);
        if (saveWarnings != null) {
            this.addWarning(saveWarnings.getMessage());
        }
        int retVal = 2;
        if (level != null) {
            if (level.indexOf("READ COMMITTED") != -1) {
                retVal = 2;
            } else if (level.indexOf("READ UNCOMMITTED") != -1) {
                retVal = 1;
            } else if (level.indexOf("REPEATABLE READ") != -1) {
                retVal = 4;
            } else if (level.indexOf("SERIALIZABLE") != -1) {
                retVal = 8;
            }
        }
        this.LOGGER.exit(this.getClass(), method, retVal);
        return retVal;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warning = null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        String message;
        String method = "createStatement";
        NzStatement statement = new NzStatement(this);
        if (resultSetType != 1003) {
            message = "Option value " + resultSetType + " for ResultSetType not supported.";
            statement.addWarning(message);
            this.LOGGER.debug(this.getClass(), method, message);
        }
        if (resultSetConcurrency != 1007) {
            message = "Option value " + resultSetConcurrency + " for ResultSetConcurrency not supported.";
            statement.addWarning(message);
            this.LOGGER.debug(this.getClass(), method, message);
        }
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new NzPreparedStatament(this, sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> typeMap) throws SQLException {
        if (!(typeMap instanceof Map)) {
            throw new NzSQLException("The Parameter is not a java.util.Map", "HY000", 1100, new Object[0]);
        }
        this.typeMap = typeMap;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        switch (holdability) {
            case 1: {
                this.addWarning("Option value 1 for ResultSetHoldability not supported.");
            }
            case 2: {
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.res.holdability.invalid", "HY000", 1130, new Object[0]);
                this.LOGGER.fatal(this.getClass(), "setHoldability", etothrow);
                throw etothrow;
            }
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String message;
        String method = "createStatement";
        NzStatement statement = new NzStatement(this);
        if (resultSetType != 1003) {
            message = "Option value " + resultSetType + " for ResultSetType not supported.";
            statement.addWarning(message);
            this.LOGGER.debug(this.getClass(), method, message);
        }
        if (resultSetConcurrency != 1007) {
            message = "Option value " + resultSetConcurrency + " for ResultSetConcurrency not supported.";
            statement.addWarning(message);
            this.LOGGER.debug(this.getClass(), method, message);
        }
        if (resultSetHoldability != 2) {
            message = "Option value " + resultSetHoldability + " for ResultSetHoldability not supported.";
            statement.addWarning(message);
            this.LOGGER.debug(this.getClass(), method, message);
        }
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new NzPreparedStatament(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        sql = sql.trim();
        return new NzCallableStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String message;
        String method = "prepareCall";
        NzCallableStatement statement = new NzCallableStatement(this, sql);
        if (resultSetType != 1003) {
            message = "Option value " + resultSetType + " for ResultSetType not supported.";
            statement.addWarning(message);
            this.LOGGER.debug(this.getClass(), method, message);
        }
        if (resultSetConcurrency != 1007) {
            message = "Option value " + resultSetConcurrency + " for ResultSetConcurrency not supported.";
            statement.addWarning(message);
            this.LOGGER.debug(this.getClass(), method, message);
        }
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String message;
        String method = "prepareCall";
        NzCallableStatement statement = new NzCallableStatement(this, sql);
        if (resultSetType != 1003) {
            message = "Option value " + resultSetType + " for ResultSetType not supported.";
            statement.addWarning(message);
            this.LOGGER.debug(this.getClass(), method, message);
        }
        if (resultSetConcurrency != 1007) {
            message = "Option value " + resultSetConcurrency + " for ResultSetConcurrency not supported.";
            statement.addWarning(message);
            this.LOGGER.debug(this.getClass(), method, message);
        }
        if (resultSetHoldability != 2) {
            message = "Option value " + resultSetHoldability + " for ResultSetHoldability not supported.";
            statement.addWarning(message);
            this.LOGGER.debug(this.getClass(), method, message);
        }
        return statement;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("SavePoints");
        this.LOGGER.fatal(this.getClass(), "setSavepoint", etothrow);
        throw etothrow;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("SavePoints");
        this.LOGGER.fatal(this.getClass(), "setSavepoint", etothrow);
        throw etothrow;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("SavePoints");
        this.LOGGER.fatal(this.getClass(), "rollBack", etothrow);
        throw etothrow;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("SavePoints");
        this.LOGGER.fatal(this.getClass(), "releaseSavepoint", etothrow);
        throw etothrow;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new NzMethodNotImplementedException("NzConnection", "prepareStatement(String,int)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new NzMethodNotImplementedException("NzConnection", "prepareStatement(String,int[])");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new NzMethodNotImplementedException("NzConnection", "prepareStatement(String,String[])");
    }

    public boolean isBulkLoad() {
        return this.bulkLoad;
    }

    public void setBulkLoad(boolean bulkLoad) {
        this.bulkLoad = bulkLoad;
    }

    private void reconnect(String catalog) throws SQLException {
        this.datasource.setDatabase(catalog);
        this.open();
    }

    private void initSocket() throws SQLException {
        String method = "initSocket";
        this.LOGGER.entry(NzConnection.class, method);
        this.socket = new NzSocket(this.datasource);
        try {
            this.socket.open();
            this.LOGGER.exit(NzConnection.class, method);
        }
        catch (UnknownHostException se) {
            NzSQLException etothrow = new NzSQLException("netezza.con.refused", "08001", 1114, new Object[0]);
            this.LOGGER.fatal(NzSocket.class, method, etothrow);
            throw etothrow;
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
            this.LOGGER.fatal(NzConnection.class, method, etothrow);
            throw etothrow;
        }
    }

    public NzResultSet execute(NzQuery query) throws SQLException {
        String method = "execute";
        this.LOGGER.entry(this.getClass(), method, query);
        NzResultSet set = this.execute(null, query);
        this.LOGGER.exit(this.getClass(), method, set);
        return set;
    }

    public NzResultSet execute(NzStatement statement, NzQuery query) throws SQLException {
        if (this.isClosed()) {
            NzSQLException ex = new NzSQLException("netezza.con.closed", "08003", 1111, new Object[0]);
            this.LOGGER.fatal(this.getClass(), "execute", ex);
            throw ex;
        }
        try {
            if (!this.autoCommit && !this.transactionBegun) {
                NzSimpleQuery beginQuery = new NzSimpleQuery("begin;" + this.getIsolationLevelSQL());
                this.executor.execute(statement, beginQuery);
                this.transactionBegun = true;
            }
            return this.executor.execute(statement, query.parse());
        }
        catch (ParseException e) {
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), "execute", etothrow);
            throw etothrow;
        }
    }

    public void updateResultSet(NzResultSet set) throws SQLException {
        boolean isBatchQuery = false;
        try {
            isBatchQuery = ((NzStatement)set.getStatement()).query.getQueryType() == NzQuery.QueryType.BATCH;
        }
        catch (NullPointerException e) {
            isBatchQuery = false;
        }
        this.executor.update(set, isBatchQuery);
    }

    public NzResultSet getNextResult(NzStatement statement) throws SQLException {
        boolean isBatchQuery = false;
        try {
            isBatchQuery = statement.query.getQueryType() == NzQuery.QueryType.BATCH;
        }
        catch (NullPointerException e) {
            isBatchQuery = false;
        }
        return this.executor.getNextResult(statement, isBatchQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        this.stopLoading = true;
        NzSocket cancelSocket = new NzSocket(this.datasource);
        try {
            cancelSocket.open();
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
            this.LOGGER.fatal(NzConnection.class, "cancel", etothrow);
            throw etothrow;
        }
        try {
            NzSocket e = cancelSocket;
            synchronized (e) {
                cancelSocket.sendInt(16, 4);
                cancelSocket.sendInt(80877102, 4);
                cancelSocket.sendInt(this.pid, 4);
                cancelSocket.sendInt(this.ckey, 4);
                cancelSocket.flush();
            }
        }
        catch (IOException e) {
            this.close();
            NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
            this.LOGGER.fatal(NzConnection.class, "cancel", etothrow);
            throw etothrow;
        }
        finally {
            try {
                this.STATE = (short)4;
                if (cancelSocket != null) {
                    cancelSocket.close();
                }
                this.yieldToThread();
            }
            catch (IOException e) {
                this.close();
            }
        }
    }

    public void yieldToThread() {
        try {
            if (this.loading) {
                while (this.stopLoading) {
                    Thread.sleep(10L);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateDatasource() throws SQLException {
        String method = "validateDatasource";
        this.LOGGER.entry(NzConnection.class, "validateDatasource");
        NzSQLException e = null;
        if (this.datasource.getUser() == null) {
            e = this.datasource.isClientKrbSSODelegated() ? new NzSQLException("GSSException: No valid credentials provided through Kerberos SSO Delegation", "28000", 11201, new Object[0]) : new NzSQLException("netezza.con.user", "28000", 11201, new Object[0]);
        } else if (this.datasource.getPassword() == null && !this.datasource.isClientKrbSSODelegated()) {
            e = new NzSQLException("netezza.con.pass", "28000", 11202, new Object[0]);
        } else if (this.datasource.getHost() == null || this.datasource.getPort() <= 0) {
            e = new NzSQLException("netezza.con.host.or.port", "08001", 1114, new Object[0]);
        }
        if (e != null) {
            this.LOGGER.fatal(NzConnection.class, "validateDatasource", e);
            throw e;
        }
        this.LOGGER.exit(NzConnection.class, "validateDatasource");
    }

    private void setBackendProperties() throws SQLException {
        String method = "setBackendProperties";
        this.LOGGER.entry(this.getClass(), method);
        this.LOGGER.info(this.getClass(), method, "Setting datastyle to ISO");
        this.execute(NzQuery.SET_DATESTYLE_QUERY);
        this.LOGGER.info(this.getClass(), method, "Setting encoding to UTF8");
        this.execute(NzQuery.SET_ENCODING_QUERY);
        this.LOGGER.exit(this.getClass(), method);
    }

    private void getBackendVersion() throws SQLException {
        String method = "getBackendVersion";
        this.LOGGER.entry(this.getClass(), method);
        NzResultSet result = this.execute(NzQuery.VERSION_QUERY);
        if (!result.next()) {
            NzSQLException etothrow = new NzSQLException("netezza.bknd.ver", "08001", 1114, new Object[0]);
            this.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        this.about = result.getString(1);
        result.close();
        int[] relArray = new int[5];
        StringTokenizer versionParts = new StringTokenizer(this.about, " ,");
        versionParts.nextToken();
        String _databaseVersion = versionParts.nextToken();
        String[] splits = _databaseVersion.split("[.]");
        for (int i = 0; i < splits.length; ++i) {
            try {
                switch (i) {
                    case 0: {
                        this.databaseMajorVersion = Integer.parseInt(splits[i]);
                        this.LOGGER.debug(this.getClass(), method, "Major Version: " + this.databaseMajorVersion);
                        break;
                    }
                    case 1: {
                        this.databaseMinorVersion = Integer.parseInt(splits[i]);
                        this.LOGGER.debug(this.getClass(), method, "Minor Version: " + this.databaseMinorVersion);
                        break;
                    }
                    case 2: {
                        this.databaseSubMinorVersion = Integer.parseInt(splits[i]);
                        this.LOGGER.debug(this.getClass(), method, "Sub-Minor Version: " + this.databaseSubMinorVersion);
                    }
                }
                continue;
            }
            catch (NumberFormatException e) {
                this.LOGGER.fatal(this.getClass(), method, "Invalid Version String : " + this.about);
            }
        }
        this.getReleaseStringParse(_databaseVersion, relArray);
        this.analyze = this.isRevStreamForPrepare(relArray);
        this.LOGGER.exit(NzConnection.class, method);
    }

    private void setClientVersion() throws SQLException {
        String method = "setClientVersion";
        this.LOGGER.entry(this.getClass(), method);
        if (this.checkBackEndForGivenVersion("7.0.3") != -1) {
            this.execute(new NzSimpleQuery("SET CLIENT_VERSION = '" + Driver.getVersion() + "'"));
        }
        this.LOGGER.exit(NzConnection.class, method);
    }

    public int checkBackEndForGivenVersion(String version) {
        int major = 0;
        int minor = 0;
        int result = -1;
        int sub_minor = 0;
        String method = "checkBackEndForGivenVersion";
        this.LOGGER.entry(this.getClass(), method);
        String[] splits = version.split("[.]");
        for (int i = 0; i < splits.length; ++i) {
            try {
                switch (i) {
                    case 0: {
                        major = Integer.parseInt(splits[i]);
                        break;
                    }
                    case 1: {
                        minor = Integer.parseInt(splits[i]);
                        break;
                    }
                    case 2: {
                        sub_minor = Integer.parseInt(splits[i]);
                    }
                }
                continue;
            }
            catch (NumberFormatException e) {
                this.LOGGER.fatal(this.getClass(), method, "Invalid Version String : " + this.about);
                return -1;
            }
        }
        if (splits.length < 2) {
            return -1;
        }
        if (major == this.databaseMajorVersion && minor == this.databaseMinorVersion && sub_minor == this.databaseSubMinorVersion) {
            return 0;
        }
        if (major < this.databaseMajorVersion) {
            return 1;
        }
        if (major > this.databaseMajorVersion) {
            return -1;
        }
        if (minor < this.databaseMinorVersion) {
            return 1;
        }
        if (minor > this.databaseMinorVersion) {
            return -1;
        }
        if (sub_minor < this.databaseSubMinorVersion) {
            return 1;
        }
        if (sub_minor > this.databaseSubMinorVersion) {
            return -1;
        }
        this.LOGGER.exit(NzConnection.class, method);
        return result;
    }

    private void getReleaseStringParse(String databaseVer, int[] relArray) {
        int index = 0;
        databaseVer = databaseVer.toUpperCase();
        StringTokenizer tokens = new StringTokenizer(databaseVer, ".-P");
        boolean patchFlg = false;
        int tokenCount = tokens.countTokens();
        if (databaseVer.contains("-P")) {
            patchFlg = true;
        }
        for (int i = 1; tokens.hasMoreTokens() && i <= 5; ++i) {
            try {
                if (i == tokenCount && i < 5 && patchFlg) break;
                relArray[index++] = Integer.parseInt(tokens.nextToken());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private boolean isRevStreamForPrepare(int[] relArray) {
        int majorVer = relArray[0];
        int minorVer = relArray[1];
        int subMinorVer = relArray[2];
        int variant = relArray[3];
        int patchNo = relArray[4];
        if (majorVer == 7) {
            if (minorVer == 0) {
                if (subMinorVer == 2) {
                    return variant >= 14;
                }
                if (subMinorVer == 4) {
                    if (variant == 5) {
                        return patchNo >= 2;
                    }
                    return variant > 5;
                }
                return subMinorVer > 4;
            }
            if (minorVer == 1) {
                if (subMinorVer == 0) {
                    if (variant == 2) {
                        return patchNo >= 2;
                    }
                    return variant >= 3;
                }
                return subMinorVer > 0;
            }
            return minorVer >= 2;
        }
        return majorVer >= 8;
    }

    private void getSupportedDatabaseFeatures() throws SQLException {
        String method = "getSupportedDatabaseFeatures";
        this.LOGGER.entry(this.getClass(), "getSupportedDatabaseFeatures");
        NzResultSet result = this.execute(new NzSimpleQuery("select feature :: int1 from _v_jdbc_feature where spec_level = '3.0'"));
        try {
            while (result.next()) {
                NzFeature.setFeature(result.getByte(1));
            }
        }
        catch (SQLException sqle) {
            this.LOGGER.info(this.getClass(), "getSupportedDatabaseFeatures", sqle.getMessage());
        }
        result.close();
        this.LOGGER.exit(NzConnection.class, "getSupportedDatabaseFeatures");
    }

    private void getBackendInfo() throws SQLException {
        String method = "getBackendInfo";
        this.LOGGER.entry(this.getClass(), "getBackendInfo");
        if (NzFeature.SQL_IDENTIFIER_CASE.isSet()) {
            NzResultSet result = this.execute(new NzSimpleQuery("select identifier_case, current_catalog, current_user"));
            while (result.next()) {
                String _case = result.getString(1);
                this.LOGGER.debug(this.getClass(), "getBackendInfo", "Identifier Case: " + _case);
                this.upperCase = _case.equalsIgnoreCase("uppercase");
                this.datasource.setDatabase(result.getString(2));
                this.datasource.setUser(result.getString(3));
            }
            result.close();
        }
        this.LOGGER.exit(NzConnection.class, "getBackendInfo");
    }

    private void logDriverVersionInBackendLog() throws SQLException {
        String method = "logDriverVersionInBackendLog";
        this.LOGGER.entry(this.getClass(), "logDriverVersionInBackendLog");
        NzResultSet result = this.execute(new NzSimpleQuery("select 'JDBC Client Version: " + Driver.getVersion() + "','" + PROCESSOR_BITS + "','OS Platform: " + OS_NAME + "','OS Username: " + USER_NAME + "'"));
        if (!result.next()) {
            NzSQLException etothrow = new NzSQLException("netezza.driver.ver", "08001", 1114, new Object[0]);
            this.LOGGER.fatal(this.getClass(), "logDriverVersionInBackendLog", etothrow);
            throw etothrow;
        }
        this.LOGGER.exit(this.getClass(), "logDriverVersionInBackendLog");
    }

    private String getIsolationLevelSQL() throws SQLException {
        String method = "getIsolationLevelSQL";
        this.LOGGER.entry(this.getClass(), method);
        StringBuffer sb = new StringBuffer("SET TRANSACTION ISOLATION LEVEL");
        switch (this.isolationLevel) {
            case 2: {
                sb.append(" READ COMMITTED");
                break;
            }
            case 8: {
                sb.append(" SERIALIZABLE");
                break;
            }
            default: {
                NzSQLException etothrow = new NzSQLException("netezza.trans.isolation.level.invalid", "HY000", 1131, this.isolationLevel);
                this.LOGGER.fatal(this.getClass(), method, etothrow);
                throw etothrow;
            }
        }
        this.LOGGER.exit(this.getClass(), method, sb);
        return sb.toString();
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    public PgProtocol getPgProtocol() {
        return this.pgProtocol;
    }

    public int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    public String getDatabaseVersionString() {
        return this.about;
    }

    public int getDatabaseVersion() {
        return this.databaseVersion;
    }

    public NzDatasource getDatasource() {
        return this.datasource;
    }

    public int getCommandNumber() {
        return this.commandNumber;
    }

    private boolean isNull(NzResultSetMetadata metadata, byte[] tupleData, int columnIndex) throws SQLException {
        columnIndex = metadata.getColumnMetadata(columnIndex + 1).getPhysField();
        if (metadata.getNullsAllowed() != 0) {
            return (tupleData[metadata.getSizeWordSize() + columnIndex / 8] & 0xFF & 1 << (columnIndex & 7)) != 0;
        }
        return false;
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public boolean isAnalyze() {
        return this.analyze;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        String method = "getClientInfo";
        this.LOGGER.entry(this.getClass(), method);
        if (this.checkBackEndForGivenVersion("7.1.0") == -1) {
            this.LOGGER.exit(this.getClass(), method, "Returning empty properties object as client info functionality is not supported by current NPS version.");
            return new Properties();
        }
        if (this.isClosed()) {
            NzSQLException etothrow = new NzSQLException("Connection is not open", "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        return this.clientInfo;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        String method = "setClientInfo";
        this.LOGGER.entry(this.getClass(), method);
        Set<String> list = properties.stringPropertyNames();
        Iterator<String> loop = list.iterator();
        if (this.checkBackEndForGivenVersion("7.1.0") == -1) {
            this.LOGGER.exit(this.getClass(), method, "Skipping SET CLIENT INFO as backend version does not support this functionality.");
            return;
        }
        try {
            this.clearClientProperties();
            while (loop.hasNext()) {
                String currProp = loop.next();
                String currValue = properties.get(currProp).toString();
                if (currProp.equalsIgnoreCase("applicationName")) {
                    this.datasource.setClientApplicationName(currValue);
                    this.clientInfo.put("applicationName", currValue);
                    this.execute(new NzSimpleQuery("SET CLIENT_APPLICATION_NAME TO '" + currValue + "'"));
                    continue;
                }
                if (currProp.equalsIgnoreCase("clientUser")) {
                    this.datasource.setClientUser(currValue);
                    this.clientInfo.put("clientUser", currValue);
                    this.execute(new NzSimpleQuery("SET CLIENT_USER_ID TO '" + currValue + "'"));
                    continue;
                }
                if (currProp.equalsIgnoreCase("clientHostName")) {
                    this.datasource.setClientHostName(currValue);
                    this.clientInfo.put("clientHostName", currValue);
                    this.execute(new NzSimpleQuery("SET CLIENT_WORKSTATION_NAME TO '" + currValue + "'"));
                    continue;
                }
                this.addWarning("Skipping non supported Netezza JDBC driver client property \"" + currProp + "\".");
            }
        }
        catch (SQLException e) {
            SQLClientInfoException eThrow = new SQLClientInfoException();
            eThrow.initCause(e);
            this.LOGGER.fatal(this.getClass(), method, e.getMessage());
            throw eThrow;
        }
    }

    private void clearClientProperties() throws SQLException {
        this.datasource.setClientApplicationName("");
        this.clientInfo.put("applicationName", "");
        this.execute(new NzSimpleQuery("RESET CLIENT_APPLICATION_NAME"));
        this.datasource.setClientUser("");
        this.clientInfo.put("clientUser", "");
        this.execute(new NzSimpleQuery("RESET CLIENT_USER_ID"));
        this.datasource.setClientHostName("");
        this.clientInfo.put("clientHostName", "");
        this.execute(new NzSimpleQuery("RESET CLIENT_WORKSTATION_NAME"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getClientInfo(String name) throws SQLException {
        String method = "getClientInfo";
        String clientInfo = "";
        this.LOGGER.entry(this.getClass(), method);
        if (this.checkBackEndForGivenVersion("7.1.0") == -1) {
            this.LOGGER.exit(this.getClass(), method, "Skipping GET CLIENT INFO as backend version does not support this functionality.");
            return null;
        }
        if (name == null) {
            this.LOGGER.exit(this.getClass(), method, "Skipping GET CLIENT INFO as property name provided is null.");
            return null;
        }
        if (!this.isClosed()) {
            if (name.equalsIgnoreCase("applicationName")) {
                clientInfo = this.datasource.getClientApplicationName();
            } else if (name.equalsIgnoreCase("clientUser")) {
                clientInfo = this.datasource.getClientUser();
            } else {
                if (!name.equalsIgnoreCase("clientHostName")) return null;
                clientInfo = this.datasource.getClientHostName();
            }
        } else {
            NzSQLException etothrow = new NzSQLException("Connection is not open", "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        this.LOGGER.debug(this.getClass(), method, "Client info property " + name + " : " + clientInfo);
        this.LOGGER.exit(this.getClass(), method);
        return clientInfo;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        String method = "setClientInfo";
        this.LOGGER.entry(this.getClass(), method);
        if (this.checkBackEndForGivenVersion("7.1.0") == -1) {
            this.LOGGER.exit(this.getClass(), method, "Skipping SET CLIENT INFO as backend version does not support this functionality.");
            return;
        }
        if (name == null) {
            this.LOGGER.exit(this.getClass(), method, "Skipping SET CLIENT INFO as property name provided is null.");
            return;
        }
        if (value == null) {
            value = "";
        }
        try {
            if (name.equalsIgnoreCase("applicationName")) {
                this.datasource.setClientApplicationName(value);
                this.clientInfo.put("applicationName", value);
                this.execute(new NzSimpleQuery("SET CLIENT_APPLICATION_NAME TO '" + value + "'"));
            } else if (name.equalsIgnoreCase("clientUser")) {
                this.datasource.setClientUser(value);
                this.clientInfo.put("clientUser", value);
                this.execute(new NzSimpleQuery("SET CLIENT_USER_ID TO '" + value + "'"));
            } else if (name.equalsIgnoreCase("clientHostName")) {
                this.datasource.setClientHostName(value);
                this.clientInfo.put("clientHostName", value);
                this.execute(new NzSimpleQuery("SET CLIENT_WORKSTATION_NAME TO '" + value + "'"));
            } else {
                this.addWarning("Skipping non supported Netezza JDBC driver client property \"" + name + "\".");
            }
        }
        catch (SQLException e) {
            SQLClientInfoException eThrow = new SQLClientInfoException();
            eThrow.initCause(e);
            this.LOGGER.fatal(this.getClass(), method, e.getMessage());
            throw eThrow;
        }
        this.LOGGER.debug(this.getClass(), method, "Setting client info property " + name + " to " + value);
        this.LOGGER.exit(this.getClass(), method);
    }

    @Override
    public String getSchema() throws SQLException {
        String method = "getSchema";
        String current_schema = "";
        this.LOGGER.entry(this.getClass(), method);
        if (this.isClosed()) {
            NzSQLException etothrow = new NzSQLException("Connection is not open", "HY000", 1100, new Object[0]);
            this.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT CURRENT_SCHEMA");
        rs.next();
        current_schema = rs.getString(1);
        rs.close();
        stmt.close();
        this.LOGGER.exit(this.getClass(), method);
        return current_schema;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        String method = "setSchema";
        this.LOGGER.entry(this.getClass(), method);
        if (schema == null || schema.trim().length() == 0) {
            this.LOGGER.debug(this.getClass(), method, "Connecting to default schema as no schema has been provided.");
            return;
        }
        if (this.checkBackEndForGivenVersion("7.0.3") == -1) {
            this.LOGGER.debug(this.getClass(), method, "Skipping SET SCHEMA as backend version does not support this functionality.");
            return;
        }
        this.execute(new NzSimpleQuery("SET SCHEMA " + schema));
        this.LOGGER.exit(NzConnection.class, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        String method = "isValid";
        boolean valid = false;
        Statement stmt = null;
        this.LOGGER.entry(this.getClass(), method);
        if (timeout < 0) {
            throw new NzSQLException("Invalid timeout value provided.", "HY000", 1100, new Object[0]);
        }
        try {
            if (!this.isClosed()) {
                stmt = this.createStatement();
                stmt.setQueryTimeout(timeout);
                stmt.executeQuery("SELECT 1");
                valid = true;
            } else {
                this.LOGGER.debug(this.getClass(), method, "Connection already closed.");
            }
        }
        catch (SQLException e) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {}
            }
        }
        this.LOGGER.exit(this.getClass(), method);
        return valid;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("getNetworkTimeout");
        this.LOGGER.fatal(this.getClass(), "getNetworkTimeout", etothrow);
        throw etothrow;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("setNetworkTimeout");
        this.LOGGER.fatal(this.getClass(), "setNetworkTimeout", etothrow);
        throw etothrow;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("isWrapperFor");
        this.LOGGER.fatal(this.getClass(), "isWrapperFor", etothrow);
        throw etothrow;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("unwrap");
        this.LOGGER.fatal(this.getClass(), "unwrap", etothrow);
        throw etothrow;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("abort");
        this.LOGGER.fatal(this.getClass(), "abort", etothrow);
        throw etothrow;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("createArrayOf");
        this.LOGGER.fatal(this.getClass(), "createArrayOf", etothrow);
        throw etothrow;
    }

    @Override
    public Blob createBlob() throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("createBlob");
        this.LOGGER.fatal(this.getClass(), "createBlob", etothrow);
        throw etothrow;
    }

    @Override
    public Clob createClob() throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("createClob");
        this.LOGGER.fatal(this.getClass(), "createClob", etothrow);
        throw etothrow;
    }

    @Override
    public NClob createNClob() throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("createNClob");
        this.LOGGER.fatal(this.getClass(), "createNClob", etothrow);
        throw etothrow;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("createSQLXML");
        this.LOGGER.fatal(this.getClass(), "createSQLXML", etothrow);
        throw etothrow;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("createStruct");
        this.LOGGER.fatal(this.getClass(), "createStruct", etothrow);
        throw etothrow;
    }

    static {
        String javaSpecVersion = System.getProperty("java.specification.version");
        JDBC_SPEC_VERSION = Float.parseFloat(javaSpecVersion);
    }

    private class NotValidatingTrustManager
    implements X509TrustManager {
        private NotValidatingTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private class Initializer {
        private static final int DATA_LENGTH = 2;
        private static final int CLIENT_TYPE_JDBC = 3;
        private static final int MAJORPROTOLEN = 2;
        private static final int MINORPROTOLEN = 2;
        int OPCODE_LENGTH = 2;

        private Initializer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init() throws SQLException, IOException {
            String method = "init";
            NzConnection.this.LOGGER.entry(Initializer.class, "init");
            if (NzConnection.this.isReOpened) {
                NzConnection.this.isReOpened = false;
                if (NzConnection.this.socket != null && NzConnection.this.socket.getSocket() != null) {
                    try {
                        NzSocket nzSocket = NzConnection.this.socket;
                        synchronized (nzSocket) {
                            NzConnection.this.socket.close();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    NzConnection.this.socket = null;
                }
                NzConnection.this.initSocket();
            }
            NzConnection.this.LOGGER.info(Initializer.class, "init", "Negotiating The Communication protocol");
            this.negotiateVersion();
            if (NzSecurityLevel.getSecurityLevel(NzConnection.this.datasource.getSecurityLevel()) == NzSecurityLevel.onlySecured && NzConnection.this.comProtocolVersion < 3) {
                NzSQLException e = new NzSQLException("netezza.unsec.session.needed.to.old.bkend", "HY000", 1100, new Object[0]);
                NzConnection.this.LOGGER.fatal(Initializer.class, "init", e);
                throw e;
            }
            NzConnection.this.LOGGER.info(Initializer.class, "init", "Handshake");
            this.handshake();
            this.authenticate();
            this.readyForQuery();
            NzConnection.this.LOGGER.exit(Initializer.class, "init");
        }

        void negotiateVersion() throws SQLException {
            String method = "negotiateVersion";
            NzConnection.this.LOGGER.entry(Initializer.class, "negotiateVersion");
            NzConnection.this.LOGGER.debug(NzConnection.class, "negotiateVersion", "CLIENT BEGIN");
            NzConnection.this.LOGGER.debug(NzConnection.class, "negotiateVersion", "Com protocol version (Supported) : " + NzConnection.this.comProtocolVersion);
            this.sendIntegerData(1, NzConnection.this.comProtocolVersion, 2);
            NzConnection.this.flush();
            char backendResponse = NzConnection.this.receiveChar();
            switch (backendResponse) {
                case 'E': {
                    NzConnection.this.LOGGER.debug(Initializer.class, "negotiateVersion", "ERROR");
                    String error = NzConnection.this.receiveString(Encoding.UNICODE);
                    NzSQLException etothrow = new NzSQLException(error, "08001", 1114, new Object[0]);
                    NzConnection.this.LOGGER.fatal(Initializer.class, "negotiateVersion", error);
                    throw etothrow;
                }
                case 'M': {
                    NzConnection.this.LOGGER.debug(Initializer.class, "negotiateVersion", "NEGOTIATE");
                    char server_version = NzConnection.this.receiveChar();
                    NzConnection.this.comProtocolVersion = server_version == '2' ? 2 : (int)server_version;
                    NzConnection.this.LOGGER.debug(this.getClass(), "negotiateVersion", "Com protocol version (Negotiated) : " + NzConnection.this.comProtocolVersion);
                    break;
                }
                case 'N': {
                    NzConnection.this.LOGGER.debug(Initializer.class, "negotiateVersion", "SUCCESS");
                    break;
                }
                default: {
                    NzUnknownBackendResponseException etothrow = new NzUnknownBackendResponseException(backendResponse);
                    NzConnection.this.LOGGER.fatal(this.getClass(), "negotiateVersion", etothrow);
                }
            }
            NzConnection.this.LOGGER.exit(Initializer.class, "negotiateVersion");
        }

        void handshake() throws SQLException, IOException {
            String method = "handshake";
            NzConnection.this.LOGGER.entry(Initializer.class, "handshake");
            List<Integer> opcodes = ComProtocol.INSTANCE.getOpcodes(NzConnection.this.comProtocolVersion);
            NzConnection.this.LOGGER.debug(this.getClass(), "handshake", "Postgres protocol version (Supported) : " + (Object)((Object)NzConnection.this.pgProtocol));
            NzConnection.this.LOGGER.debug(this.getClass(), "handshake", "States : " + opcodes);
            int length = opcodes.size();
            block13: for (int i = 0; i < length; ++i) {
                int opcode = opcodes.get(i);
                switch (opcode) {
                    case 2: {
                        NzConnection.this.LOGGER.debug(this.getClass(), "handshake", "HSV2_DB");
                        this.sendStringData(opcode, NzConnection.this.datasource.getDatabase());
                        break;
                    }
                    case -1: {
                        NzConnection.this.LOGGER.debug(this.getClass(), "handshake", "HSV2_SSL_BEGIN");
                        if (NzConnection.this.comProtocolVersion < 3) break;
                        this.initializeSSL();
                        continue block13;
                    }
                    case 3: {
                        NzConnection.this.LOGGER.debug(this.getClass(), "handshake", "HSV2_USER");
                        this.sendStringData(opcode, NzConnection.this.datasource.getUser());
                        break;
                    }
                    case 9: {
                        NzConnection.this.LOGGER.debug(this.getClass(), "handshake", "HSV2_PROTOCOL");
                        this.sendPgProtocol(opcode, NzConnection.this.pgProtocol);
                        break;
                    }
                    case 8: {
                        NzConnection.this.LOGGER.debug(this.getClass(), "handshake", "HSV2_CLIENT_TYPE");
                        this.sendIntegerData(opcode, 3, 2);
                        break;
                    }
                    case 1000: {
                        NzConnection.this.LOGGER.debug(this.getClass(), "handshake", "HSV2_CLIENT_DONE");
                        this.sendOpcode(opcode);
                        break;
                    }
                    case 6: {
                        NzConnection.this.LOGGER.debug(this.getClass(), "handshake", "HSV2_REMOTE_PID");
                        String processName = ManagementFactory.getRuntimeMXBean().getName();
                        String[] pArr = processName.split("@");
                        NzConnection.this.client_pid = Integer.parseInt(pArr[0]);
                        this.sendIntegerData(opcode, NzConnection.this.client_pid, 4);
                        break;
                    }
                    default: {
                        NzSQLException etothrow = new NzSQLException("netezza.opcode.unknown", "08001", 1114, opcode);
                        NzConnection.this.LOGGER.fatal(this.getClass(), "handshake", etothrow);
                        throw etothrow;
                    }
                }
                NzConnection.this.flush();
                if (opcode == 1000) break;
                char backendResponse = NzConnection.this.receiveChar();
                switch (backendResponse) {
                    case 'N': {
                        NzConnection.this.LOGGER.debug(this.getClass(), "handshake", "SUCCESS");
                        continue block13;
                    }
                    case 'E': {
                        NzSQLException etothrow;
                        NzConnection.this.LOGGER.debug(this.getClass(), "handshake", "ERROR");
                        String error = NzConnection.this.receiveString(Encoding.UNICODE);
                        NzConnection.this.LOGGER.debug(this.getClass(), "handshake", "ERROR: " + error);
                        if (error.startsWith("Unsupported frontend protocol")) {
                            NzConnection.this.pgProtocol = NzConnection.this.pgProtocol.getPrevious();
                            if (NzConnection.this.pgProtocol == null) {
                                etothrow = new NzSQLException(error, "08001", 1114, new Object[0]);
                                NzConnection.this.LOGGER.fatal(this.getClass(), "handshake", etothrow);
                                throw etothrow;
                            }
                            --i;
                            continue block13;
                        }
                        etothrow = new NzSQLException(error, "08001", 1114, new Object[0]);
                        NzConnection.this.LOGGER.fatal(this.getClass(), "handshake", etothrow);
                        throw etothrow;
                    }
                    default: {
                        NzSQLException etothrow = new NzUnknownBackendResponseException(backendResponse);
                        NzConnection.this.LOGGER.fatal(this.getClass(), "handshake", etothrow);
                        throw etothrow;
                    }
                }
            }
            NzConnection.this.LOGGER.debug(this.getClass(), "handshake", "Postgres protocol version (Negotiated) : " + (Object)((Object)NzConnection.this.pgProtocol));
            NzConnection.this.LOGGER.exit(Initializer.class, "handshake");
        }

        private void initializeSSL() throws SQLException, IOException {
            String method = "initializeSSL";
            NzSecurityLevel securityLevel = NzSecurityLevel.getSecurityLevel(NzConnection.this.datasource.getSecurityLevel());
            SSLSocket socket = null;
            int state = 11;
            block11: while (state != 0) {
                switch (state) {
                    case 11: {
                        this.sendIntegerData(state, securityLevel.getLevel(), 4);
                        state = 12;
                        break;
                    }
                    case 12: {
                        this.sendOpcode(state);
                        state = 0;
                        break;
                    }
                }
                NzConnection.this.flush();
                if (state == 0) {
                    socket.startHandshake();
                    NzConnection.this.refreshStreams(socket);
                }
                char beResponse = NzConnection.this.receiveChar();
                switch (beResponse) {
                    case 'N': {
                        state = 0;
                        continue block11;
                    }
                    case 'E': {
                        String error = NzConnection.this.receiveString(Encoding.UNICODE);
                        NzSQLException e = new NzSQLException(error, "HY000", 1100, new Object[0]);
                        NzConnection.this.LOGGER.fatal(this.getClass(), method, e);
                        throw e;
                    }
                    case 'S': {
                        if (NzSecurityLevel.getSecurityLevel(NzConnection.this.datasource.getSecurityLevel()) == NzSecurityLevel.preferredUnsecured) {
                            NzConnection.this.isHostSSL = true;
                        }
                        try {
                            socket = this.createSSLSocket();
                            continue block11;
                        }
                        catch (IllegalArgumentException eArg) {
                            IOException ioEArg = new IOException(eArg.getLocalizedMessage() + " is not supported protocol.");
                            throw ioEArg;
                        }
                    }
                }
                NzUnknownBackendResponseException e = new NzUnknownBackendResponseException(beResponse);
                NzConnection.this.LOGGER.fatal(this.getClass(), method, e);
                throw e;
            }
        }

        private SSLSocket createSSLSocket() throws SQLException, IllegalArgumentException {
            String method = "createSSLSocket";
            NzConnection.this.LOGGER.entry(this.getClass(), "createSSLSocket");
            SSLContext context = null;
            try {
                context = NzConnection.this.isTLSSecurity ? SSLContext.getInstance("TLS") : SSLContext.getInstance("SSL");
            }
            catch (NoSuchAlgorithmException e) {
                NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
                NzConnection.this.LOGGER.fatal(this.getClass(), "createSSLSocket", etothrow);
                throw etothrow;
            }
            SSLSocket socket = null;
            String certPath = null;
            certPath = NzConnection.this.datasource.getCaCertificate();
            Certificate certificate = this.generateCertificate(certPath);
            TrustManager[] managers = this.geTrustManagers(certificate);
            try {
                String[] protocols;
                context.init(null, managers, new SecureRandom());
                SSLSocketFactory factory = context.getSocketFactory();
                socket = (SSLSocket)factory.createSocket(NzConnection.this.socket.getSocket(), NzConnection.this.datasource.getHost(), NzConnection.this.datasource.getPort(), false);
                if (NzConnection.this.isTLSSecurity) {
                    protocols = new String[]{"TLSv1.2"};
                    String[] newCipher = socket.getSupportedCipherSuites();
                    socket.setEnabledCipherSuites(newCipher);
                } else {
                    protocols = new String[]{"SSLv3"};
                }
                NzConnection.this.LOGGER.debug(this.getClass(), "createSSLSocket", "Security protocol used is " + protocols[0]);
                socket.setEnabledProtocols(protocols);
                NzConnection.this.LOGGER.exit(this.getClass(), "createSSLSocket");
                return socket;
            }
            catch (IOException e) {
                NzConnection.this.close();
                NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
                NzConnection.this.LOGGER.fatal(this.getClass(), "createSSLSocket", etothrow);
                throw etothrow;
            }
            catch (KeyManagementException e) {
                NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
                NzConnection.this.LOGGER.fatal(this.getClass(), "createSSLSocket", etothrow);
                throw etothrow;
            }
        }

        private Certificate generateCertificate(String certpath) throws SQLException {
            if (certpath == null || certpath.trim().length() == 0) {
                return null;
            }
            try {
                FileInputStream _certificate = new FileInputStream(certpath);
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                Certificate certificate = factory.generateCertificate(_certificate);
                return certificate;
            }
            catch (FileNotFoundException e) {
                NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
                NzConnection.this.LOGGER.fatal(this.getClass(), "createSSLSocket", etothrow);
                throw etothrow;
            }
            catch (CertificateException e) {
                NzSQLException etothrow = new NzSQLException(e.getMessage(), "08001", 1114, new Object[0]);
                NzConnection.this.LOGGER.fatal(this.getClass(), "createSSLSocket", etothrow);
                throw etothrow;
            }
        }

        private TrustManager[] geTrustManagers(Certificate certificate) {
            TrustManager[] trustManagerArray;
            TrustManager[] managers = null;
            if (certificate != null) {
                try {
                    KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
                    store.load(null, "netezza".toCharArray());
                    store.setCertificateEntry("NZ", certificate);
                    TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    factory.init(store);
                    managers = factory.getTrustManagers();
                }
                catch (KeyStoreException e) {
                    NzConnection.this.LOGGER.fatal(this.getClass(), "geTrustManagers", e.getMessage() + " : Using Default Trust Managers");
                }
                catch (NoSuchAlgorithmException e) {
                    NzConnection.this.LOGGER.fatal(this.getClass(), "geTrustManagers", e.getMessage() + " : Using Default Trust Managers");
                }
                catch (CertificateException e) {
                    NzConnection.this.LOGGER.fatal(this.getClass(), "geTrustManagers", e.getMessage() + " : Using Default Trust Managers");
                }
                catch (IOException e) {
                    NzConnection.this.LOGGER.fatal(this.getClass(), "geTrustManagers", e.getMessage() + " : Using Default Trust Managers");
                }
            }
            if (managers != null) {
                trustManagerArray = managers;
            } else {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = new NotValidatingTrustManager();
            }
            return trustManagerArray;
        }

        void authenticate() throws SQLException {
            String method = "authenticate";
            NzConnection.this.LOGGER.entry(this.getClass(), "authenticate");
            int areq = -1;
            byte[] rst = new byte[2];
            do {
                char backendResponse = NzConnection.this.receiveChar();
                String salt = null;
                block1 : switch (backendResponse) {
                    case 'E': {
                        NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "ERROR");
                        String error = NzConnection.this.receiveString(Encoding.UNICODE);
                        NzSQLException etothrow = new NzSQLException(error, "08001", 1114, new Object[0]);
                        NzConnection.this.LOGGER.fatal(this.getClass(), "authenticate", etothrow);
                        NzConnection.this.close();
                        throw etothrow;
                    }
                    case 'R': {
                        NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "AUTHENTICATION_REQUEST");
                        areq = NzConnection.this.receiveIntR(4);
                        switch (areq) {
                            case 0: {
                                NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "OK");
                                break block1;
                            }
                            case 1: {
                                NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "KRB4");
                                NzSQLException etothrow = new NzSQLException("netezza.con.kerb4", "08001", 11211, new Object[0]);
                                NzConnection.this.LOGGER.fatal(this.getClass(), "authenticate", etothrow);
                                throw etothrow;
                            }
                            case 2: {
                                NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "KRB5");
                                NzSQLException etothrow = new NzSQLException("netezza.con.kerb5", "08001", 11212, new Object[0]);
                                NzConnection.this.LOGGER.fatal(this.getClass(), "authenticate", etothrow);
                                throw etothrow;
                            }
                            case 3: {
                                NzSQLException e;
                                NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "CLEARTEXT");
                                if (NzConnection.this.datasource.isClientKrbSSODelegated()) {
                                    e = new NzSQLException("krbSSODelegation was set to TRUE but NPS is not configured in Kerberos authentication mode.", "28000", 11202, new Object[0]);
                                    throw e;
                                }
                                NzConnection.this.sendInt(5 + NzConnection.this.datasource.getPassword().length(), 4);
                                NzConnection.this.sendBytes(NzConnection.this.datasource.getPassword().getBytes());
                                NzConnection.this.sendInt(0, 1);
                                NzConnection.this.flush();
                                break block1;
                            }
                            case 4: {
                                NzSQLException e;
                                NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "CRYPT");
                                if (NzConnection.this.datasource.isClientKrbSSODelegated()) {
                                    e = new NzSQLException("krbSSODelegation was set to TRUE but NPS is not configured in Kerberos authentication mode.", "28000", 11202, new Object[0]);
                                    throw e;
                                }
                                rst[0] = NzConnection.this.receiveByte();
                                rst[1] = NzConnection.this.receiveByte();
                                salt = new String(rst, 0, 2);
                                NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "Salt: " + salt);
                                String crypted = UnixCrypt.crypt(salt, NzConnection.this.datasource.getPassword());
                                NzConnection.this.sendInt(5 + crypted.length(), 4);
                                NzConnection.this.sendBytes(crypted.getBytes());
                                NzConnection.this.sendInt(0, 1);
                                NzConnection.this.flush();
                                break block1;
                            }
                            case 5: {
                                NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "MD5");
                                if (NzConnection.this.datasource.isClientKrbSSODelegated()) {
                                    NzSQLException e = new NzSQLException("krbSSODelegation was set to TRUE but NPS is not configured in Kerberos authentication mode.", "28000", 11202, new Object[0]);
                                    throw e;
                                }
                                rst[0] = NzConnection.this.receiveByte();
                                rst[1] = NzConnection.this.receiveByte();
                                salt = new String(rst, 0, 2);
                                NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "Salt: " + salt);
                                String MD5crypted = "";
                                MD5crypted = NZDigest.encode(1, salt, NzConnection.this.datasource.getPassword());
                                NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "MD5: " + MD5crypted);
                                NzConnection.this.sendInt(5 + MD5crypted.length(), 4);
                                NzConnection.this.sendBytes(MD5crypted.getBytes());
                                NzConnection.this.sendInt(0, 1);
                                NzConnection.this.flush();
                                break block1;
                            }
                            case 6: {
                                NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "SHA256");
                                if (NzConnection.this.datasource.isClientKrbSSODelegated()) {
                                    NzSQLException e = new NzSQLException("krbSSODelegation was set to TRUE but NPS is not configured in Kerberos authentication mode.", "28000", 11202, new Object[0]);
                                    throw e;
                                }
                                rst[0] = NzConnection.this.receiveByte();
                                rst[1] = NzConnection.this.receiveByte();
                                salt = new String(rst, 0, 2);
                                NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "Salt: " + salt);
                                String SHA256crypted = "";
                                SHA256crypted = NZDigest.encode(2, salt, NzConnection.this.datasource.getPassword());
                                NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "SHA256: " + SHA256crypted);
                                NzConnection.this.sendInt(5 + SHA256crypted.length(), 4);
                                NzConnection.this.sendBytes(SHA256crypted.getBytes());
                                NzConnection.this.sendInt(0, 1);
                                NzConnection.this.flush();
                                break block1;
                            }
                            case 7: {
                                NzConnection.this.LOGGER.debug(this.getClass(), "authenticate", "KRB5-GSSAPI");
                                try {
                                    NzKrb5GSSAuthentication krbAuth = new NzKrb5GSSAuthentication(NzConnection.this.socket, NzConnection.this.datasource);
                                    krbAuth.authenticate();
                                    break block1;
                                }
                                catch (SQLException eSQL) {
                                    NzConnection.this.LOGGER.fatal(this.getClass(), "authenticate", eSQL);
                                    throw eSQL;
                                }
                            }
                        }
                        NzSQLException etothrow = new NzSQLException("netezza.con.auth", "08001", 11210, areq);
                        NzConnection.this.LOGGER.fatal(this.getClass(), "authenticate", etothrow);
                        throw etothrow;
                    }
                    default: {
                        NzUnknownBackendResponseException etothrow = new NzUnknownBackendResponseException(backendResponse);
                        NzConnection.this.LOGGER.fatal(this.getClass(), "authenticate", etothrow);
                        throw etothrow;
                    }
                }
            } while (areq != 0);
            NzConnection.this.LOGGER.exit(this.getClass(), "authenticate");
        }

        void readyForQuery() throws SQLException {
            String method = "readyForQuery";
            NzConnection.this.LOGGER.entry(Initializer.class, "readyForQuery");
            boolean readyForQuery = false;
            do {
                char backendResponse = NzConnection.this.receiveChar();
                NzConnection.this.receiveIntR(4);
                NzConnection.this.receiveIntR(4);
                switch (backendResponse) {
                    case 'K': {
                        NzConnection.this.LOGGER.debug(this.getClass(), "readyForQuery", "KEY");
                        NzConnection.this.pid = NzConnection.this.receiveIntR(4);
                        NzConnection.this.ckey = NzConnection.this.receiveIntR(4);
                        NzConnection.this.LOGGER.debug(this.getClass(), "readyForQuery", "Pid : " + NzConnection.this.pid + " Cancelation key: " + NzConnection.this.ckey);
                        break;
                    }
                    case 'E': {
                        NzConnection.this.LOGGER.debug(this.getClass(), "readyForQuery", "ERROR");
                        String error = NzConnection.this.receiveString(Encoding.UNICODE);
                        NzSQLException etothrow = new NzSQLException(error, "08001", 1114, new Object[0]);
                        NzConnection.this.LOGGER.fatal(this.getClass(), "readyForQuery", etothrow);
                        throw etothrow;
                    }
                    case 'N': {
                        NzConnection.this.LOGGER.debug(this.getClass(), "readyForQuery", "NOTICE");
                        String warning = NzConnection.this.receiveString(Encoding.UNICODE);
                        break;
                    }
                    case 'Z': {
                        NzConnection.this.LOGGER.debug(this.getClass(), "readyForQuery", "READY");
                        readyForQuery = true;
                        break;
                    }
                    default: {
                        NzSQLException etothrow = new NzSQLException("netezza.con.backend", "08001", 1113, "Protocol error");
                        throw etothrow;
                    }
                }
            } while (!readyForQuery);
            NzConnection.this.LOGGER.exit(Initializer.class, "readyForQuery");
        }

        private void sendIntegerData(int opcode, int data, int length) throws SQLException {
            NzConnection.this.sendInt(4 + this.OPCODE_LENGTH + length, 4);
            NzConnection.this.sendInt(opcode, this.OPCODE_LENGTH);
            NzConnection.this.sendInt(data, length);
        }

        private void sendStringData(int opcode, String data) throws SQLException {
            byte[] dataInBytes = Encoding.UNICODE.encode(data);
            int len = dataInBytes.length;
            NzConnection.this.sendInt(4 + this.OPCODE_LENGTH + len, 4);
            NzConnection.this.sendInt(opcode, this.OPCODE_LENGTH);
            NzConnection.this.sendBytes(dataInBytes, len);
        }

        private void sendOpcode(int opcode) throws SQLException {
            NzConnection.this.sendInt(4 + this.OPCODE_LENGTH, 4);
            NzConnection.this.sendInt(opcode, this.OPCODE_LENGTH);
        }

        private void sendPgProtocol(int opcode, PgProtocol protocol) throws SQLException {
            NzConnection.this.sendInt(4 + this.OPCODE_LENGTH + 2 + 2, 4);
            NzConnection.this.sendInt(opcode, this.OPCODE_LENGTH);
            NzConnection.this.sendInt(protocol.getMajorVersion(), 2);
            NzConnection.this.sendInt(protocol.getMinorVersion(), 2);
        }
    }
}

