/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

import java.sql.SQLException;
import org.netezza.core.Encoding;
import org.netezza.error.NzSQLException;
import org.netezza.error.NzUnknownBackendResponseException;
import org.netezza.externaltable.Loader;
import org.netezza.externaltable.NzUnload;
import org.netezza.internal.ColumnMetadata;
import org.netezza.internal.NzQuery;
import org.netezza.internal.NzType;
import org.netezza.internal.PgType;
import org.netezza.sql.NzConnection;
import org.netezza.sql.NzPreparedStatament;
import org.netezza.sql.NzResultSet;
import org.netezza.sql.NzResultSetMetadata;
import org.netezza.sql.NzStatement;

public class QueryExecutor {
    private final NzConnection connection;
    private Loader loader;
    private NzUnload nzUnload;

    public QueryExecutor(NzConnection connection) {
        this.connection = connection;
    }

    public synchronized NzResultSet execute(NzStatement statement, NzQuery query) throws SQLException {
        boolean isBatchQuery;
        String method = "execute";
        this.connection.LOGGER.entry(this.getClass(), method, statement, query);
        this.sendQuery(query, statement);
        boolean bl = isBatchQuery = query.getQueryType() == NzQuery.QueryType.BATCH;
        if (statement != null) {
            statement.setUpdateCount(-1);
        }
        NzResultSet set = this.getNextResult(statement, isBatchQuery);
        this.connection.LOGGER.exit(this.getClass(), method, set);
        return set;
    }

    public synchronized NzResultSet getNextResult(NzStatement statement, boolean isBatchQuery) throws SQLException {
        String method = "getNextResult";
        this.connection.LOGGER.entry(this.getClass(), method, statement);
        String error = null;
        boolean end = false;
        long timeout = statement == null ? 0L : (long)(statement.getQueryTimeout() * 1000);
        int fetchSize = statement == null ? 0 : statement.getFetchSize();
        String responseMessage = null;
        NzResultSetMetadata metadata = null;
        NzResultSet set = null;
        if (timeout > 0L && !this.connection.isDataAvailable(timeout)) {
            statement.cancel();
            NzSQLException etothrow = new NzSQLException("netezza.query.timeout.expired", "HYT00", 1116, new Object[0]);
            this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            throw etothrow;
        }
        int counter = 0;
        while (!(fetchSize != 0 && counter >= fetchSize || end)) {
            while (this.loader != null && this.loader.isReading()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.connection.LOGGER.fatal(this.getClass(), method, e);
                }
            }
            char backendResponse = this.connection.receiveChar();
            this.connection.receiveIntR(4);
            this.connection.receiveIntR(4);
            this.connection.LOGGER.debug(this.getClass(), method, "Backend Response: " + backendResponse);
            switch (backendResponse) {
                case 'A': {
                    int pid = this.connection.receiveInt(4);
                    String msg = this.connection.receiveString(Encoding.UNICODE);
                    break;
                }
                case 'P': {
                    String pname = this.connection.receiveString(Encoding.UNICODE);
                    this.connection.LOGGER.debug(this.getClass(), method, "Portal Name: " + pname);
                    break;
                }
                case 'T': {
                    this.connection.STATE = (short)3;
                    if (statement != null) {
                        statement.setUpdateCount(-1);
                    }
                    ColumnMetadata[] metadatas = this.receiveColumnMetadata();
                    metadata = new NzResultSetMetadata(this.connection, metadatas);
                    set = new NzResultSet(statement, metadata);
                    break;
                }
                case 'X': {
                    set.makeItDbos();
                    this.receiveDbosColumnMetadata(metadata);
                    break;
                }
                case 'B': 
                case 'D': {
                    ++counter;
                    set.addRow(this.connection.receivePgTuple(metadata.getColumnCount()));
                    break;
                }
                case 'Y': {
                    ++counter;
                    set.addRow(this.connection.receiveDbosTuple(metadata));
                    break;
                }
                case 'C': {
                    responseMessage = this.connection.receiveString(Encoding.UNICODE);
                    this.connection.STATE = (short)2;
                    if (statement != null) {
                        statement.setResponse(responseMessage);
                    }
                    if (!isBatchQuery) break;
                    end = true;
                    break;
                }
                case 'I': {
                    char t = this.connection.receiveChar();
                    break;
                }
                case 'l': {
                    this.loader = statement.getLoader();
                    if (this.connection.isBulkLoad() && this.loader.setUp()) {
                        ((NzPreparedStatament)statement).nzBulkLoad();
                        break;
                    }
                    if (!this.loader.setUp()) break;
                    new Thread(this.loader).start();
                    break;
                }
                case 'x': {
                    this.connection.yieldToThread();
                    if (this.connection.isBulkLoad()) {
                        ((NzPreparedStatament)statement).isExtTblLoadErrorOccurred(true);
                        break;
                    }
                    this.connection.stopLoading = true;
                    break;
                }
                case 'e': {
                    int logType = 0;
                    String logDir = this.connection.receiveString();
                    String filename = this.connection.receiveString();
                    logType = this.connection.receiveIntR(4);
                    if (this.loader == null) {
                        this.loader = statement.getLoader();
                    }
                    this.loader.processLogs(logDir, filename, logType);
                    break;
                }
                case 'u': {
                    this.nzUnload = new NzUnload(this.connection);
                    this.nzUnload.setUpUnload();
                    break;
                }
                case 'U': {
                    this.nzUnload.unload();
                    break;
                }
                case 'E': {
                    this.connection.STATE = (short)2;
                    error = this.connection.receiveString(Encoding.UNICODE);
                    this.connection.STATE = (short)2;
                    break;
                }
                case 'N': {
                    String notice = this.connection.receiveString(Encoding.UNICODE);
                    this.connection.LOGGER.debug(this.getClass(), method, notice);
                    this.connection.addWarning(notice);
                    if (statement == null) break;
                    statement.addWarning(notice);
                    break;
                }
                case 'Z': {
                    this.connection.STATE = 1;
                    end = true;
                    break;
                }
                default: {
                    NzUnknownBackendResponseException etothrow = new NzUnknownBackendResponseException(backendResponse);
                    this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                    throw etothrow;
                }
            }
            if (error != null) {
                if (!this.connection.getAutoCommit()) {
                    this.connection.rollback();
                }
                NzSQLException etothrow = new NzSQLException(error, "HY000", 1100, new Object[0]);
                this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                throw etothrow;
            }
            if (set == null || set.getFetchSize() <= 0 || set.getRow() != set.getFetchSize()) continue;
            this.connection.LOGGER.info(this.getClass(), method, "Batch Break");
            break;
        }
        this.connection.LOGGER.exit(this.getClass(), method, set);
        return set;
    }

    public synchronized void update(NzResultSet set, boolean isBatchQuery) throws SQLException {
        String method = "update";
        this.connection.LOGGER.entry(this.getClass(), method, set);
        set.clean();
        String error = null;
        boolean end = false;
        int fetchSize = set.getFetchSize();
        String responseMessage = null;
        int counter = 0;
        while (!(fetchSize != 0 && counter >= fetchSize || end)) {
            char backendResponse = this.connection.receiveChar();
            this.connection.receiveIntR(4);
            this.connection.receiveIntR(4);
            this.connection.LOGGER.debug(this.getClass(), method, "Backend Response: " + backendResponse);
            switch (backendResponse) {
                case 'A': {
                    int pid = this.connection.receiveInt(4);
                    String msg = this.connection.receiveString(Encoding.UNICODE);
                    break;
                }
                case 'B': 
                case 'D': {
                    ++counter;
                    set.addRow(this.connection.receivePgTuple(set.getMetaData().getColumnCount()));
                    break;
                }
                case 'Y': {
                    ++counter;
                    set.addRow(this.connection.receiveDbosTuple((NzResultSetMetadata)set.getMetaData()));
                    break;
                }
                case 'C': {
                    responseMessage = this.connection.receiveString(Encoding.UNICODE);
                    this.connection.STATE = (short)2;
                    NzStatement statement = (NzStatement)set.getStatement();
                    statement.setResponse(responseMessage);
                    if (!isBatchQuery) break;
                    end = true;
                    break;
                }
                case 'E': {
                    this.connection.STATE = (short)2;
                    error = this.connection.receiveString(Encoding.UNICODE);
                    this.connection.STATE = (short)2;
                    break;
                }
                case 'N': {
                    String notice = this.connection.receiveString(Encoding.UNICODE);
                    this.connection.LOGGER.debug(this.getClass(), method, notice);
                    this.connection.addWarning(notice);
                    if (set.getStatement() == null) break;
                    ((NzStatement)set.getStatement()).addWarning(notice);
                    break;
                }
                case 'Z': {
                    this.connection.STATE = 1;
                    end = true;
                    NzStatement statement = (NzStatement)set.getStatement();
                    break;
                }
                default: {
                    NzUnknownBackendResponseException etothrow = new NzUnknownBackendResponseException(backendResponse);
                    this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                    throw etothrow;
                }
            }
            if (error != null) {
                if (!this.connection.getAutoCommit()) {
                    this.connection.rollback();
                }
                NzSQLException etothrow = new NzSQLException(error, "HY000", 1100, new Object[0]);
                this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                throw etothrow;
            }
            if (set == null || set.getRow() != set.getFetchSize()) continue;
            this.connection.LOGGER.info(this.getClass(), method, "Batch Break");
            break;
        }
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    private void sendQuery(NzQuery query, NzStatement statement) throws SQLException {
        String method = "sendQuery";
        this.connection.LOGGER.entry(this.getClass(), method, query);
        if (!query.isParsed()) {
            query = query.parse();
        }
        NzSQLException etothrow = null;
        switch (this.connection.STATE) {
            case 0: {
                this.connection.LOGGER.debug(this.getClass(), method, "NOT CONNECTED");
                etothrow = new NzSQLException("netezza.con.closed", "08003", 1111, new Object[0]);
                this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
            }
            case 4: {
                this.connection.LOGGER.debug(this.getClass(), method, "CANCELLED");
                this.connection.resetSocket();
                if (this.connection.getAutoCommit()) break;
                this.connection.rollback();
                break;
            }
            case 3: {
                this.connection.LOGGER.debug(this.getClass(), method, "FETCHING");
                etothrow = new NzSQLException("netezza.max.stmt.handles", "HY014", 11403, new Object[0]);
                this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                throw etothrow;
            }
            case 1: {
                this.connection.LOGGER.debug(this.getClass(), method, "CONNECTED");
                break;
            }
            case 2: {
                this.connection.LOGGER.debug(this.getClass(), method, "EXECUTING");
                this.connection.clearSocket();
                break;
            }
            default: {
                etothrow = new NzSQLException("netezza.con.state.undefined", "HY000", 1117, new Object[0]);
                this.connection.LOGGER.fatal(this.getClass(), method, etothrow);
                throw etothrow;
            }
        }
        String nativeQuery = query.toNativeString().trim();
        if (statement != null && statement.getMaxRows() > 0 && query.getQueryType() == NzQuery.QueryType.SELECT && !NzQuery.containsLimitClause(nativeQuery)) {
            int lastIndex = nativeQuery.length() - 1;
            if (nativeQuery.charAt(lastIndex) == ';') {
                nativeQuery = nativeQuery.substring(0, lastIndex);
            }
            nativeQuery = nativeQuery + " limit " + statement.getMaxRows();
        }
        this.connection.LOGGER.info(this.getClass(), method, "Sending query");
        this.connection.sendChar('P');
        this.connection.sendInt(this.connection.getCommandNumber(), 4);
        this.connection.sendBytes(Encoding.UNICODE.encode(nativeQuery));
        this.connection.sendByte((byte)0);
        this.connection.flush();
        this.connection.STATE = (short)2;
        this.connection.LOGGER.exit(this.getClass(), method);
    }

    private ColumnMetadata[] receiveColumnMetadata() throws SQLException {
        String method = "receiveColumnMetadata";
        this.connection.LOGGER.entry(this.getClass(), method);
        int size = this.connection.receiveIntR(2);
        this.connection.LOGGER.debug(this.getClass(), method, "Total Number of Columns: " + size);
        ColumnMetadata[] metadatas = new ColumnMetadata[size];
        for (int i = 0; i < metadatas.length; ++i) {
            metadatas[i] = new ColumnMetadata();
            metadatas[i].setName(this.connection.receiveString(Encoding.UNICODE));
            metadatas[i].setPgType(PgType.getPgType(this.connection.receiveIntR(4)));
            metadatas[i].setLength(this.connection.receiveIntR(2));
            metadatas[i].setModifier(this.connection.receiveIntR(4));
            int nullable = this.connection.receiveByte();
            switch (nullable) {
                case 0: {
                    nullable = 1;
                    break;
                }
                case 1: {
                    nullable = 0;
                    break;
                }
                default: {
                    nullable = 2;
                }
            }
            metadatas[i].setNullAllowed(nullable);
            this.connection.LOGGER.debug(this.getClass(), method, "Metadata: " + metadatas[i]);
        }
        this.connection.LOGGER.exit(this.getClass(), method);
        return metadatas;
    }

    private void receiveDbosColumnMetadata(NzResultSetMetadata metadata) throws SQLException {
        metadata.setVersion(this.connection.receiveIntR(4));
        metadata.setNullsAllowed(this.connection.receiveIntR(4));
        metadata.setSizeWord(this.connection.receiveIntR(4));
        metadata.setSizeWordSize(this.connection.receiveIntR(4));
        metadata.setNumFixedFields(this.connection.receiveIntR(4));
        metadata.setNumVaryingFields(this.connection.receiveIntR(4));
        metadata.setFixedFieldsSize(this.connection.receiveIntR(4));
        metadata.setMaxRecordSize(this.connection.receiveIntR(4));
        metadata.setNumFields(this.connection.receiveIntR(4));
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            ColumnMetadata columnMetadata = metadata.getColumnMetadata(i);
            columnMetadata.setType(NzType.getNzType(this.connection.receiveIntR(4)));
            columnMetadata.setSize(this.connection.receiveIntR(4));
            columnMetadata.setTrueSize(this.connection.receiveIntR(4));
            columnMetadata.setOffset(this.connection.receiveIntR(4));
            columnMetadata.setPhysField(this.connection.receiveIntR(4));
            columnMetadata.setLogField(this.connection.receiveIntR(4));
            columnMetadata.setNullAllowed(this.connection.receiveIntR(4));
            columnMetadata.setFixedSize(this.connection.receiveIntR(4));
            columnMetadata.setSpringField(this.connection.receiveIntR(4));
        }
        metadata.setDateStyle(this.connection.receiveIntR(4));
        metadata.setEuroDates(this.connection.receiveIntR(4));
        metadata.setDbCharset(this.connection.receiveIntR(4));
        if (this.connection.getPgProtocol().getMajorVersion() > 3 || this.connection.getPgProtocol().getMajorVersion() == 3 && this.connection.getPgProtocol().getMinorVersion() >= 5) {
            metadata.setEnableTime24(this.connection.receiveIntR(4));
        } else {
            metadata.setEnableTime24(0);
        }
    }
}

