/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.core;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.netezza.error.NzSQLException;

public enum Encoding {
    UNICODE("UTF8"),
    LATIN9("ISO8859_15_FDIS");

    private String encoding;

    private Encoding(String encoding) {
        this.encoding = encoding;
    }

    public byte[] encode(String string) throws SQLException {
        try {
            return string.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
        }
    }

    public String decode(byte[] bytes, int offset, int length) throws SQLException {
        try {
            return new String(bytes, offset, length, this.encoding);
        }
        catch (Exception e) {
            throw new NzSQLException(e.getMessage(), "HY000", 1100, new Object[0]);
        }
    }

    public String decode(byte[] bytes) throws SQLException {
        return this.decode(bytes, 0, bytes.length);
    }
}

