/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.gpt3;

import java.util.Arrays;
import java.util.Optional;
import org.jkiss.code.NotNull;

public enum GPTModel {
    CODE_CUSHMAN("code-cushman-001", 2048),
    CODE_DAVINCI("code-davinci-002", 2048),
    TEXT_ADA("text-ada-001", 2048),
    TEXT_CURIE("text-curie-001", 2048),
    TEXT_BABBAGE("text-babbage-001", 2048),
    TEXT_DAVINCI01("text-davinci-003", 4096),
    TEXT_DAVINCI02("text-davinci-002", 4096),
    TEXT_DAVINCI03("text-davinci-001", 2048);

    private final String name;
    private final int maxTokens;

    @NotNull
    public static GPTModel getByName(@NotNull String name) {
        Optional<GPTModel> model = Arrays.stream(GPTModel.values()).filter(it -> it.name.equals(name)).findFirst();
        return model.orElse(CODE_DAVINCI);
    }

    private GPTModel(String name, int maxTokens) {
        this.name = name;
        this.maxTokens = maxTokens;
    }

    public int getMaxTokens() {
        return this.maxTokens;
    }

    public String getName() {
        return this.name;
    }
}

