/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.completion;

import java.io.IOException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.completion.DAICompletionScope;
import org.jkiss.dbeaver.model.impl.preferences.BundlePreferenceStore;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DAICompletionSettings {
    private static final Log log = Log.getLog(DAICompletionSettings.class);
    private final DBPDataSourceContainer dataSource;
    private boolean metaTransferConfirmed;
    private boolean allowMetaTransfer;
    private DAICompletionScope scope;
    private String[] customObjectIds;

    public DAICompletionSettings(DBPDataSourceContainer dataSource) {
        this.dataSource = dataSource;
        this.loadSettings();
    }

    public boolean isMetaTransferConfirmed() {
        return this.metaTransferConfirmed;
    }

    public void setMetaTransferConfirmed(boolean metaTransferConfirmed) {
        this.metaTransferConfirmed = metaTransferConfirmed;
    }

    public boolean isAllowMetaTransfer() {
        return this.allowMetaTransfer;
    }

    public void setAllowMetaTransfer(boolean allowMetaTransfer) {
        this.allowMetaTransfer = allowMetaTransfer;
    }

    public DAICompletionScope getScope() {
        return this.scope;
    }

    public void setScope(DAICompletionScope scope) {
        this.scope = scope;
    }

    public String[] getCustomObjectIds() {
        return this.customObjectIds;
    }

    public void setCustomObjectIds(String[] customObjectIds) {
        this.customObjectIds = customObjectIds;
    }

    @NotNull
    private static BundlePreferenceStore getPreferenceStore() {
        return new BundlePreferenceStore("org.jkiss.dbeaver.model.ai");
    }

    private void loadSettings() {
        BundlePreferenceStore preferenceStore = DAICompletionSettings.getPreferenceStore();
        String prefix = "ai-" + this.dataSource.getId() + ".";
        this.metaTransferConfirmed = preferenceStore.getBoolean(String.valueOf(prefix) + "ai.meta.transferConfirmed");
        this.scope = (DAICompletionScope)CommonUtils.valueOf(DAICompletionScope.class, (String)preferenceStore.getString(String.valueOf(prefix) + "ai.meta.scope"), (Enum)DAICompletionScope.CURRENT_SCHEMA);
        String csString = preferenceStore.getString(String.valueOf(prefix) + "ai.meta.customObjects");
        this.customObjectIds = csString == null ? new String[]{} : csString.split(",");
    }

    public void saveSettings() {
        BundlePreferenceStore preferenceStore = DAICompletionSettings.getPreferenceStore();
        String prefix = "ai-" + this.dataSource.getId() + ".";
        preferenceStore.setValue(String.valueOf(prefix) + "ai.meta.transferConfirmed", this.metaTransferConfirmed);
        preferenceStore.setValue(String.valueOf(prefix) + "ai.meta.scope", this.scope.name());
        if (ArrayUtils.isEmpty((Object[])this.customObjectIds)) {
            preferenceStore.setToDefault(String.valueOf(prefix) + "ai.meta.customObjects");
        } else {
            preferenceStore.setValue(String.valueOf(prefix) + "ai.meta.customObjects", String.join((CharSequence)",", this.customObjectIds));
        }
        try {
            preferenceStore.save();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }
}

