/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import com.google.gson.Gson;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIEngineSettings;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionPersistent;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AISettings {
    private static final Log log = Log.getLog(AISettings.class);
    private static final Gson gson = new Gson();
    private static final String AI_CONFIGURATION_JSON = "ai-configuration.json";
    private boolean aiDisabled;
    private final Set<String> disabledConnections = new LinkedHashSet<String>();
    private final Set<String> enabledConnections = new LinkedHashSet<String>();
    private final Map<String, AIEngineSettings> engineConfigurations = new LinkedHashMap<String, AIEngineSettings>();

    private AISettings() {
    }

    public boolean isAiDisabled() {
        return this.aiDisabled;
    }

    public void setAiDisabled(boolean aiDisabled) {
        this.aiDisabled = aiDisabled;
    }

    @NotNull
    public Set<String> getDisabledConnections() {
        return this.disabledConnections;
    }

    @NotNull
    public Set<String> getEnabledConnections() {
        return this.enabledConnections;
    }

    @NotNull
    public Map<String, AIEngineSettings> getEngineConfigurations() {
        return this.engineConfigurations;
    }

    @NotNull
    public AIEngineSettings getEngineConfiguration(String engine) {
        AIEngineSettings settings = this.engineConfigurations.get(engine);
        if (settings == null) {
            settings = new AIEngineSettings();
            settings.setEngineEnabled(!this.aiDisabled);
            this.engineConfigurations.put(engine, settings);
        }
        return settings;
    }

    @NotNull
    public static AISettings getSettings() {
        try {
            AISettings settings = null;
            SMSession session = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
            if (session instanceof SMSessionPersistent) {
                settings = (AISettings)((SMSessionPersistent)session).getAttribute(AISettings.class.getName());
            }
            if (settings == null) {
                String content = DBWorkbench.getPlatform().getProductConfigurationController().loadConfigurationFile(AI_CONFIGURATION_JSON);
                settings = CommonUtils.isEmpty((String)content) ? new AISettings() : (AISettings)gson.fromJson((Reader)new StringReader(content), AISettings.class);
                if (session instanceof SMSessionPersistent) {
                    ((SMSessionPersistent)session).setAttribute(AISettings.class.getName(), (Object)settings);
                }
            }
            if (DBWorkbench.getPlatform().getPreferenceStore().getString("ai.completion.disabled") != null) {
                settings.setAiDisabled(DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.disabled"));
            }
            return settings;
        }
        catch (Exception e) {
            log.error((Object)e);
            return new AISettings();
        }
    }

    public void saveSettings() {
        try {
            String content = gson.toJson((Object)this, AISettings.class);
            DBWorkbench.getPlatform().getProductConfigurationController().saveConfigurationFile(AI_CONFIGURATION_JSON, content);
            DBWorkbench.getPlatform().getPreferenceStore().setValue("ai.completion.disabled", this.aiDisabled);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

