/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.aws;

import com.dbeaver.net.auth.aws.AWSIAMUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSAbstract;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.RdsUtilities;
import software.amazon.awssdk.services.rds.model.GenerateAuthenticationTokenRequest;

public class AuthModelAWSRDS
extends AuthModelAWSAbstract {
    public static final String ID = "iam";
    private static final Log log = Log.getLog(AuthModelAWSRDS.class);

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelAWSCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        if (!CommonUtils.isEmpty((String)configuration.getUserPassword())) {
            return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connProperties);
        }
        String region = credentials.getRegion();
        if (CommonUtils.isEmpty((String)region)) {
            region = configuration.getAuthProperty("iam.region");
        }
        if (CommonUtils.isEmpty((String)region)) {
            region = Region.AWS_GLOBAL.id();
        }
        String secretName = credentials.getSecretName();
        String username = configuration.getUserName();
        DBPConnectionConfiguration realConfig = dataSource.getContainer().getConnectionConfiguration();
        String hostname = realConfig.getHostName();
        int port = Integer.parseInt(realConfig.getHostPort());
        AwsCredentialsProvider credentialsProvider = credentials.getAuthCredentialsProvider(monitor, configuration);
        if (CommonUtils.isEmpty((String)secretName)) {
            this.initRDSTokenAuthentication(credentials, region, username, hostname, port, credentialsProvider);
        } else {
            AWSIAMUtils.initSecretAuthentication(credentials, region, secretName, credentialsProvider, configuration);
        }
        return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connProperties);
    }

    private void initRDSTokenAuthentication(AuthModelAWSCredentials credentials, String region, String username, String hostname, int port, AwsCredentialsProvider credentialsProvider) throws DBException {
        if (CommonUtils.isEmpty((String)username)) {
            throw new DBException("username is empty");
        }
        RdsUtilities rdsUtils = RdsUtilities.builder().credentialsProvider(credentialsProvider).build();
        GenerateAuthenticationTokenRequest req = GenerateAuthenticationTokenRequest.builder().hostname(hostname).port(port).region(Region.of((String)region)).username(username).credentialsProvider(credentialsProvider).build();
        String rdsAuthToken = rdsUtils.generateAuthenticationToken(req);
        credentials.setUserName(username);
        credentials.setUserPassword(rdsAuthToken);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }
}

