/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.WriteApi;
import com.influxdb.client.WriteOptions;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.internal.AbstractWriteClient;
import com.influxdb.client.service.WriteService;
import com.influxdb.client.write.Point;
import com.influxdb.client.write.WriteParameters;
import com.influxdb.client.write.events.AbstractWriteEvent;
import com.influxdb.client.write.events.EventListener;
import com.influxdb.client.write.events.ListenerRegistration;
import com.influxdb.utils.Arguments;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;

final class WriteApiImpl
extends AbstractWriteClient
implements WriteApi {
    WriteApiImpl(@Nonnull WriteOptions writeOptions, @Nonnull WriteService service, @Nonnull InfluxDBClientOptions options, Collection<AutoCloseable> autoCloseables) {
        super(writeOptions, options, writeOptions.getWriteScheduler(), service, autoCloseables);
    }

    @Override
    public void writeRecord(@Nonnull WritePrecision precision, @Nullable String record) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writeRecord(this.options.getBucket(), this.options.getOrg(), precision, record);
    }

    @Override
    public void writeRecord(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nullable String record) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"org");
        Arguments.checkNotNull((Object)((Object)precision), (String)"WritePrecision is required");
        this.writeRecord(record, new WriteParameters(bucket, org, precision));
    }

    @Override
    public void writeRecord(@Nullable String record, @Nonnull WriteParameters parameters) {
        if (record == null) {
            return;
        }
        Arguments.checkNotNull((Object)parameters, (String)"WriteParameters");
        parameters.check(this.options);
        this.write(parameters, (Publisher<AbstractWriteClient.BatchWriteData>)Flowable.just((Object)new AbstractWriteClient.BatchWriteDataRecord(record)));
    }

    @Override
    public void writeRecords(@Nonnull WritePrecision precision, @Nonnull List<String> records) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writeRecords(this.options.getBucket(), this.options.getOrg(), precision, records);
    }

    @Override
    public void writeRecords(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull List<String> records) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"org");
        Arguments.checkNotNull((Object)((Object)precision), (String)"WritePrecision is required");
        Arguments.checkNotNull(records, (String)"records");
        this.writeRecords(records, new WriteParameters(bucket, org, precision));
    }

    @Override
    public void writeRecords(@Nonnull List<String> records, @Nonnull WriteParameters parameters) {
        Arguments.checkNotNull(records, (String)"records");
        Arguments.checkNotNull((Object)parameters, (String)"WriteParameters");
        parameters.check(this.options);
        Flowable stream = Flowable.fromIterable(records).map(AbstractWriteClient.BatchWriteDataRecord::new);
        this.write(parameters, (Publisher<AbstractWriteClient.BatchWriteData>)stream);
    }

    @Override
    public void writePoint(@Nullable Point point) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writePoint(this.options.getBucket(), this.options.getOrg(), point);
    }

    @Override
    public void writePoint(@Nonnull String bucket, @Nonnull String org, @Nullable Point point) {
        this.writePoint(point, new WriteParameters(bucket, org, WriteParameters.DEFAULT_WRITE_PRECISION));
    }

    @Override
    public void writePoint(@Nullable Point point, @Nonnull WriteParameters parameters) {
        if (point == null) {
            return;
        }
        Arguments.checkNotNull((Object)parameters, (String)"WriteParameters");
        parameters.check(this.options);
        this.writePoints(Collections.singletonList(point), parameters);
    }

    @Override
    public void writePoints(@Nonnull List<Point> points) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writePoints(this.options.getBucket(), this.options.getOrg(), points);
    }

    @Override
    public void writePoints(@Nonnull String bucket, @Nonnull String org, @Nonnull List<Point> points) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"org");
        Arguments.checkNotNull(points, (String)"points");
        this.writePoints(points, new WriteParameters(bucket, org, WriteParameters.DEFAULT_WRITE_PRECISION));
    }

    @Override
    public void writePoints(@Nonnull List<Point> points, @Nonnull WriteParameters parameters) {
        Arguments.checkNotNull(points, (String)"points");
        Arguments.checkNotNull((Object)parameters, (String)"WriteParameters");
        parameters.check(this.options);
        Flowable stream = Flowable.fromIterable(points).filter(Objects::nonNull).map(point -> new AbstractWriteClient.BatchWriteDataPoint((Point)point, this.options));
        this.writePoints(parameters, (Flowable<AbstractWriteClient.BatchWriteDataPoint>)stream);
    }

    @Override
    public <M> void writeMeasurement(@Nonnull WritePrecision precision, @Nullable M measurement) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writeMeasurement(this.options.getBucket(), this.options.getOrg(), precision, measurement);
    }

    @Override
    public <M> void writeMeasurement(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nullable M measurement) {
        this.writeMeasurement(measurement, new WriteParameters(bucket, org, precision));
    }

    @Override
    public <M> void writeMeasurement(@Nullable M measurement, @Nonnull WriteParameters parameters) {
        if (measurement == null) {
            return;
        }
        Arguments.checkNotNull((Object)parameters, (String)"WriteParameters");
        parameters.check(this.options);
        this.writeMeasurements(Collections.singletonList(measurement), parameters);
    }

    @Override
    public <M> void writeMeasurements(@Nonnull WritePrecision precision, @Nonnull List<M> measurements) {
        Arguments.checkNotNull((Object)this.options.getBucket(), (String)"InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        this.writeMeasurements(this.options.getBucket(), this.options.getOrg(), precision, measurements);
    }

    @Override
    public <M> void writeMeasurements(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull List<M> measurements) {
        Arguments.checkNonEmpty((String)bucket, (String)"bucket");
        Arguments.checkNonEmpty((String)org, (String)"org");
        Arguments.checkNotNull((Object)((Object)precision), (String)"WritePrecision is required");
        Arguments.checkNotNull(measurements, (String)"records");
        this.writeMeasurements(measurements, new WriteParameters(bucket, org, precision));
    }

    @Override
    public <M> void writeMeasurements(@Nonnull List<M> measurements, @Nonnull WriteParameters parameters) {
        Arguments.checkNotNull(measurements, (String)"points");
        Arguments.checkNotNull((Object)parameters, (String)"WriteParameters");
        parameters.check(this.options);
        Flowable stream = Flowable.fromIterable(measurements).map(it -> new AbstractWriteClient.BatchWriteDataMeasurement(it, parameters.precisionSafe(this.options), this.options, this.measurementMapper));
        this.write(parameters, (Publisher<AbstractWriteClient.BatchWriteData>)stream);
    }

    @Override
    @Nonnull
    public <T extends AbstractWriteEvent> ListenerRegistration listenEvents(@Nonnull Class<T> eventType, @Nonnull EventListener<T> listener) {
        Arguments.checkNotNull(eventType, (String)"Type of listener");
        Arguments.checkNotNull(listener, (String)"Listener");
        Disposable subscribe = super.addEventListener(eventType).subscribe(listener::onEvent);
        return () -> ((Disposable)subscribe).dispose();
    }

    @Override
    public void close() {
        super.close();
    }
}

