/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class URLParameters {
    private boolean m_bJavaSPDefaultConnection = false;
    private int m_nLoginTimeout;
    private boolean m_bLogMechBrowser;
    private int m_nCompatDBS = 0;
    private int m_nCompatIsAutoInc = 0;
    private int m_nCompatIsCurrency = 0;
    private int m_nCompatIsSigned = 0;
    private int m_nCompatIsSearch = 0;
    private String m_sCompatGetSchema = null;
    private String m_sCompatGetTable = null;
    private int m_nCompatIsReadOnly = 0;
    private int m_nCompatIsWritable = 0;
    private int m_nCompatIsDefWrit = 0;
    private int m_nDBSPort = 1025;
    private int m_nHTTPSPort = 443;
    private String m_sSSLMode = null;
    private String m_sSSLProtocol = null;
    private String m_sSSLCipher = null;
    private int m_nSSLModeLevel = 3;
    private boolean m_bSSLDebug = false;
    private String m_sSSLCA = null;
    private String m_sSSLCAPath = null;
    private String m_sSSLTrustStore = null;
    private String m_sLogLevel = "ERROR";
    private boolean m_bCOPDiscovery = true;
    private boolean m_bCOPLast = false;
    private long m_nConnectFailureTTL = 0L;
    private String m_sTCP = null;
    private String m_sCharSet = "ASCII";
    private String m_sClientCharset = null;
    private boolean m_bEncryptData;
    private String m_sLogMech;
    private String m_sLogData;
    private String m_sAccountId = "NO_ACCOUNT_ID";
    private boolean m_bRunStartup = false;
    private boolean m_bIsGoverned = true;
    private int m_nReconnectCount;
    private int m_nReconnectInterval;
    private boolean m_bFinalizeAutoClose = false;
    private Boolean m_bStrictEncode = null;
    private Integer m_nRedrive = null;
    private static final int DEFAULT_MAX_MESSAGE_BODY = 2097000;
    private int m_nMaxMessageBody = 2097000;
    private String m_sUser;
    private String m_sPassword;
    private String m_sNewPassword;
    private String m_sTransactMode = "DEFAULT";
    private String m_sPartition = "DBC/SQL";
    private Integer m_nLogonSequenceNumber = null;
    private short m_nConnectFunction = 0;
    private String m_sLSSType = "";
    private String m_sType = "DEFAULT";
    private int m_nSessions = 0;
    private String m_sDatabaseName = "NO_DEF_DATABASE";
    private String m_sSPL = "SPL";
    private int m_nTimeNano = -1;
    private int m_nTimestampNano = -1;
    private boolean m_bPrepSupport = true;
    private boolean m_bSIPSupport = true;
    private boolean m_bLOBSupport = true;
    private String m_sLOBTempTable;
    private boolean m_bUseXViews = false;
    private boolean m_bTrustedSQLAwareness = false;
    private boolean m_bDataDictStats = false;
    private boolean m_bLiteralUnderscore = false;
    private String m_sFieldSeparator = ",";
    private int m_nSlobReceiveThreshold = 1000;
    private int m_nSlobTransmitThreshold = 1000;
    private boolean m_bCredentialsFromGetURL = false;
    private boolean m_bMayBeNull = false;
    private boolean m_bAccurateColumnNames = false;
    private int m_nErrorQueryCount = 21;
    private int m_nErrorQueryInterval = 500;
    private String m_sErrorTableDatabase = null;
    private String m_sErrorTable1Suffix = "_ERR_1";
    private String m_sErrorTable2Suffix = "_ERR_2";
    private boolean m_bXXEProcessing = false;
    private String m_sBrowser = null;
    private int m_nBrowserTimeout = 180;
    private String m_sOIDCScope = "openid";
    private String m_sOIDCToken = "access_token";
    private boolean m_bFlatten = false;

    protected URLParameters(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20, String string21, String string22, String string23, String string24, String string25, String string26, String string27, String string28, String string29, String string30, String string31, String string32, String string33, String string34, String string35, String string36, String string37, String string38, String string39, String string40, String string41, String string42, String string43, String string44, String string45, String string46, String string47, String string48, String string49, String string50, String string51, String string52, String string53, String string54, String string55, String string56, String string57, String string58, String string59, String string60, String string61, String string62, String string63, String string64, String string65, String string66, String string67, String string68, String string69, String string70, String string71, String string72, String string73, String string74, String string75) throws SQLException {
        this.setLoginTimeout(n);
        this.setCompatDBS(string16);
        this.setCompatIsAutoInc(string17);
        this.setCompatIsCurrency(string18);
        this.setCompatIsSigned(string19);
        this.setCompatIsSearch(string20);
        this.setCompatGetSchema(string21);
        this.setCompatGetTable(string22);
        this.setCompatIsReadOnly(string23);
        this.setCompatIsWritable(string24);
        this.setCompatIsDefWrit(string25);
        this.setDbsPort(string12);
        this.setHTTPSPort(string67);
        this.setSSLMode(string68);
        this.setSSLProtocol(string69);
        this.setSSLCipher(string70);
        this.setSSLDebug(string71);
        this.setSSLCA(string72);
        this.setSSLCAPath(string73);
        this.setSSLTrustStore(string74);
        this.setLogLevel(string28);
        this.setCopDiscovery(string33);
        this.setCOPLast(string34);
        this.setConnectFailureTTL(string36);
        this.setTCP(string37);
        this.setCharSet(string2);
        this.setClientCharset(string10);
        this.setEncryptData(string15);
        this.setLogMech(string13);
        this.setLogData(string14);
        this.setAccountId(string9);
        this.setRunStartup(string35);
        this.setGovern(string6);
        this.setReconnectCount(string43);
        this.setReconnectInterval(string44);
        this.setFinalizeAutoClose(string45);
        this.setStrictEncode(string46);
        this.setRedrive(string47);
        this.setMaxMessageBody(string48);
        this.setNewPassword(string29);
        this.setTransactMode(string);
        this.setPartition(string3);
        this.setLogonSequenceNumber(string51);
        this.setConnectFunction(string52);
        this.setLssType(string53);
        this.setType(string4);
        this.setSessions(string5);
        this.setDatabaseName(string8);
        this.setSpl(string7);
        this.setTimeNano(string26);
        this.setTimestampNano(string27);
        this.setPrepSupport(string32);
        this.setSipSupport(string39);
        this.setLobSupport(string11);
        this.setLobTempTable(string31);
        this.setuseXviews(string30);
        this.setTrustedSQLAwareness(string38);
        this.setDataDictStats(string40);
        this.setLiteralUnderscore(string41);
        this.setFieldSeparator(string42);
        this.setSlobReceiveThreshold(string49);
        this.setSlobTransmitThreshold(string50);
        this.setCredentialsFromGetURL(string54);
        this.setMayBeNull(string55);
        this.setAccurateColumnNames(string56);
        this.setErrorQueryCount(string57);
        this.setErrorQueryInterval(string58);
        this.setErrorTableDatabase(string59);
        this.setErrorTable1Suffix(string60);
        this.setErrorTable2Suffix(string61);
        this.setXXEProcessing(string62);
        this.setBrowser(string63);
        this.setBrowserTimeout(string64);
        this.setOIDCScope(string65);
        this.setOIDCToken(string66);
        this.setFlatten(string75);
        this.validateCombinations();
    }

    public URLParameters(String string) throws SQLException {
        this(string, null);
    }

    public URLParameters(String string, Properties properties) throws SQLException {
        this.setLoginTimeout(DriverManager.getLoginTimeout());
        Properties properties2 = new Properties();
        this.ParseParams(properties2, string);
        boolean bl = this.removeStrictNamesKey(properties, this.removeStrictNamesKey(properties2, true));
        this.setParams(bl, properties2);
        this.setParams(bl, properties);
        this.validateCombinations();
    }

    private boolean removeStrictNamesKey(Properties properties, boolean bl) throws SQLException {
        if (properties != null) {
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (!string.equalsIgnoreCase("STRICT_NAMES")) continue;
                iterator.remove();
                if ("ON".equalsIgnoreCase(string2) || "OFF".equalsIgnoreCase(string2)) {
                    bl = "ON".equalsIgnoreCase(string2);
                    continue;
                }
                throw ErrorFactory.makeDriverJDBCException("TJ843", "STRICT_NAMES", string2);
            }
        }
        return bl;
    }

    private void validateCombinations() throws SQLException {
        boolean bl;
        boolean bl2 = bl = this.m_nSSLModeLevel == 2 || this.m_nSSLModeLevel == 3;
        if (bl && this.m_nDBSPort == this.m_nHTTPSPort) {
            throw ErrorFactory.makeDriverJDBCException("TJ1554", this.m_nDBSPort);
        }
        if (this.m_nCompatDBS == 0 && (this.m_nCompatIsAutoInc != 0 || this.m_nCompatIsCurrency != 0 || this.m_nCompatIsSigned != 0 || this.m_nCompatIsSearch != 0 || this.m_nCompatIsReadOnly != 0 || this.m_nCompatIsWritable != 0 || this.m_nCompatIsDefWrit != 0 || this.m_sCompatGetSchema != null || this.m_sCompatGetTable != null)) {
            throw ErrorFactory.makeDriverJDBCException("TJ366");
        }
    }

    private void setParams(boolean bl, Properties properties) throws SQLException {
        if (properties == null) {
            return;
        }
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (string.equalsIgnoreCase("ACCOUNTID")) {
                this.setAccountId(string2);
                continue;
            }
            if (string.equalsIgnoreCase("ACCOUNT")) {
                this.setAccountId(string2);
                continue;
            }
            if (string.equalsIgnoreCase("BROWSER")) {
                this.setBrowser(string2);
                continue;
            }
            if (string.equalsIgnoreCase("BROWSER_TIMEOUT")) {
                this.setBrowserTimeout(string2);
                continue;
            }
            if (string.equalsIgnoreCase("CHARSET")) {
                this.setCharSet(string2);
                continue;
            }
            if (string.equalsIgnoreCase("CLIENT_CHARSET")) {
                this.setClientCharset(string2);
                continue;
            }
            if (string.equalsIgnoreCase("COLUMN_NAME")) {
                this.setAccurateColumnNames(string2);
                continue;
            }
            if (string.equalsIgnoreCase("COMPAT_DBS")) {
                this.setCompatDBS(string2);
                continue;
            }
            if (string.equalsIgnoreCase("COMPAT_GETSCHEMA")) {
                this.setCompatGetSchema(string2);
                continue;
            }
            if (string.equalsIgnoreCase("COMPAT_GETTABLE")) {
                this.setCompatGetTable(string2);
                continue;
            }
            if (string.equalsIgnoreCase("COMPAT_ISAUTOINC")) {
                this.setCompatIsAutoInc(string2);
                continue;
            }
            if (string.equalsIgnoreCase("COMPAT_ISCURRENCY")) {
                this.setCompatIsCurrency(string2);
                continue;
            }
            if (string.equalsIgnoreCase("COMPAT_ISDEFWRIT")) {
                this.setCompatIsDefWrit(string2);
                continue;
            }
            if (string.equalsIgnoreCase("COMPAT_ISREADONLY")) {
                this.setCompatIsReadOnly(string2);
                continue;
            }
            if (string.equalsIgnoreCase("COMPAT_ISSEARCH")) {
                this.setCompatIsSearch(string2);
                continue;
            }
            if (string.equalsIgnoreCase("COMPAT_ISSIGNED")) {
                this.setCompatIsSigned(string2);
                continue;
            }
            if (string.equalsIgnoreCase("COMPAT_ISWRITABLE")) {
                this.setCompatIsWritable(string2);
                continue;
            }
            if (string.equalsIgnoreCase("CONNECT_FAILURE_TTL")) {
                this.setConnectFailureTTL(string2);
                continue;
            }
            if (string.equalsIgnoreCase("CONNECT_FUNCTION")) {
                this.setConnectFunction(string2);
                continue;
            }
            if (string.equalsIgnoreCase("COP")) {
                this.setCopDiscovery(string2);
                continue;
            }
            if (string.equalsIgnoreCase("COPLAST")) {
                this.setCOPLast(string2);
                continue;
            }
            if (string.equalsIgnoreCase("DATABASE")) {
                this.setDatabaseName(string2);
                continue;
            }
            if (string.equalsIgnoreCase("DBS_PORT")) {
                this.setDbsPort(string2);
                continue;
            }
            if (string.equalsIgnoreCase("DDSTATS")) {
                this.setDataDictStats(string2);
                continue;
            }
            if (string.equalsIgnoreCase("ENCRYPTDATA")) {
                this.setEncryptData(string2);
                continue;
            }
            if (string.equalsIgnoreCase("ERROR_QUERY_COUNT")) {
                this.setErrorQueryCount(string2);
                continue;
            }
            if (string.equalsIgnoreCase("ERROR_QUERY_INTERVAL")) {
                this.setErrorQueryInterval(string2);
                continue;
            }
            if (string.equalsIgnoreCase("ERROR_TABLE_1_SUFFIX")) {
                this.setErrorTable1Suffix(string2);
                continue;
            }
            if (string.equalsIgnoreCase("ERROR_TABLE_2_SUFFIX")) {
                this.setErrorTable2Suffix(string2);
                continue;
            }
            if (string.equalsIgnoreCase("ERROR_TABLE_DATABASE")) {
                this.setErrorTableDatabase(string2);
                continue;
            }
            if (string.equalsIgnoreCase("FIELD_SEP")) {
                this.setFieldSeparator(string2);
                continue;
            }
            if (string.equalsIgnoreCase("FINALIZE_AUTO_CLOSE")) {
                this.setFinalizeAutoClose(string2);
                continue;
            }
            if (string.equalsIgnoreCase("FLATTEN")) {
                this.setFlatten(string2);
                continue;
            }
            if (string.equalsIgnoreCase("GETURL_CREDENTIALS")) {
                this.setCredentialsFromGetURL(string2);
                continue;
            }
            if (string.equalsIgnoreCase("GOVERN")) {
                this.setGovern(string2);
                continue;
            }
            if (string.equalsIgnoreCase("HTTPS_PORT")) {
                this.setHTTPSPort(string2);
                continue;
            }
            if (string.equalsIgnoreCase("LITERAL_UNDERSCORE")) {
                this.setLiteralUnderscore(string2);
                continue;
            }
            if (string.equalsIgnoreCase("LOB_SUPPORT")) {
                this.setLobSupport(string2);
                continue;
            }
            if (string.equalsIgnoreCase("LOB_TEMP_TABLE")) {
                this.setLobTempTable(string2);
                continue;
            }
            if (string.equalsIgnoreCase("LOG")) {
                this.setLogLevel(string2);
                continue;
            }
            if (string.equalsIgnoreCase("LOGMECH")) {
                this.setLogMech(string2);
                continue;
            }
            if (string.equalsIgnoreCase("LOGDATA")) {
                this.setLogData(string2);
                continue;
            }
            if (string.equalsIgnoreCase("LOGON_SEQUENCE_NUMBER")) {
                this.setLogonSequenceNumber(string2);
                continue;
            }
            if (string.equalsIgnoreCase("LSS_TYPE")) {
                this.setLssType(string2);
                continue;
            }
            if (string.equalsIgnoreCase("MAX_MESSAGE_BODY")) {
                this.setMaxMessageBody(string2);
                continue;
            }
            if (string.equalsIgnoreCase("MAYBENULL")) {
                this.setMayBeNull(string2);
                continue;
            }
            if (string.equalsIgnoreCase("NEW_PASSWORD")) {
                this.setNewPassword(string2);
                continue;
            }
            if (string.equalsIgnoreCase("OIDC_SCOPE")) {
                this.setOIDCScope(string2);
                continue;
            }
            if (string.equalsIgnoreCase("OIDC_TOKEN")) {
                this.setOIDCToken(string2);
                continue;
            }
            if (string.equalsIgnoreCase("PARTITION")) {
                this.setPartition(string2);
                continue;
            }
            if (string.equalsIgnoreCase("PASSWORD")) {
                this.m_sPassword = string2;
                continue;
            }
            if (string.equalsIgnoreCase("PREP_SUPPORT")) {
                this.setPrepSupport(string2);
                continue;
            }
            if (string.equalsIgnoreCase("RECONNECT_COUNT")) {
                this.setReconnectCount(string2);
                continue;
            }
            if (string.equalsIgnoreCase("RECONNECT_INTERVAL")) {
                this.setReconnectInterval(string2);
                continue;
            }
            if (string.equalsIgnoreCase("REDRIVE")) {
                this.setRedrive(string2);
                continue;
            }
            if (string.equalsIgnoreCase("RUNSTARTUP")) {
                this.setRunStartup(string2);
                continue;
            }
            if (string.equalsIgnoreCase("SESSIONS")) {
                this.setSessions(string2);
                continue;
            }
            if (string.equalsIgnoreCase("SIP_SUPPORT")) {
                this.setSipSupport(string2);
                continue;
            }
            if (string.equalsIgnoreCase("SLOB_RECEIVE_THRESHOLD")) {
                this.setSlobReceiveThreshold(string2);
                continue;
            }
            if (string.equalsIgnoreCase("SLOB_TRANSMIT_THRESHOLD")) {
                this.setSlobTransmitThreshold(string2);
                continue;
            }
            if (string.equalsIgnoreCase("SSLCA")) {
                this.setSSLCA(string2);
                continue;
            }
            if (string.equalsIgnoreCase("SSLCAPATH")) {
                this.setSSLCAPath(string2);
                continue;
            }
            if (string.equalsIgnoreCase("SSLCIPHER")) {
                this.setSSLCipher(string2);
                continue;
            }
            if (string.equalsIgnoreCase("SSLDEBUG")) {
                this.setSSLDebug(string2);
                continue;
            }
            if (string.equalsIgnoreCase("SSLMODE")) {
                this.setSSLMode(string2);
                continue;
            }
            if (string.equalsIgnoreCase("SSLPROTOCOL")) {
                this.setSSLProtocol(string2);
                continue;
            }
            if (string.equalsIgnoreCase("SSLTRUSTSTORE")) {
                this.setSSLTrustStore(string2);
                continue;
            }
            if (string.equalsIgnoreCase("STRICT_ENCODE")) {
                this.setStrictEncode(string2);
                continue;
            }
            if (string.equalsIgnoreCase("TCP")) {
                this.setTCP(string2);
                continue;
            }
            if (string.equalsIgnoreCase("SP_SPL")) {
                this.setSpl(string2);
                continue;
            }
            if (string.equalsIgnoreCase("TNANO")) {
                this.setTimeNano(string2);
                continue;
            }
            if (string.equalsIgnoreCase("TMODE")) {
                this.setTransactMode(string2);
                continue;
            }
            if (string.equalsIgnoreCase("TRUSTED_SQL")) {
                this.setTrustedSQLAwareness(string2);
                continue;
            }
            if (string.equalsIgnoreCase("TSNANO")) {
                this.setTimestampNano(string2);
                continue;
            }
            if (string.equalsIgnoreCase("TYPE")) {
                this.setType(string2);
                continue;
            }
            if (string.equalsIgnoreCase("USER")) {
                this.m_sUser = string2;
                continue;
            }
            if (string.equalsIgnoreCase("USEXVIEWS")) {
                this.setuseXviews(string2);
                continue;
            }
            if (string.equalsIgnoreCase("XXE_PROCESSING")) {
                this.setXXEProcessing(string2);
                continue;
            }
            if (string.equalsIgnoreCase("CHATTER") || !bl) continue;
            throw ErrorFactory.makeDriverJDBCException("TJ844", string);
        }
    }

    public static void updateForDefaultConnection(URLParameters uRLParameters, URLParameters uRLParameters2) {
        uRLParameters.m_sLogLevel = uRLParameters2.m_sLogLevel;
        uRLParameters.m_sCharSet = uRLParameters2.m_sCharSet;
        uRLParameters.m_bStrictEncode = uRLParameters2.m_bStrictEncode;
        uRLParameters.m_nMaxMessageBody = uRLParameters2.m_nMaxMessageBody;
        uRLParameters.m_bFlatten = uRLParameters2.m_bFlatten;
        uRLParameters.m_sSPL = uRLParameters2.m_sSPL;
        uRLParameters.m_nTimeNano = uRLParameters2.m_nTimeNano;
        uRLParameters.m_nTimestampNano = uRLParameters2.m_nTimestampNano;
        uRLParameters.m_bPrepSupport = uRLParameters2.m_bPrepSupport;
        uRLParameters.m_bSIPSupport = uRLParameters2.m_bSIPSupport;
        uRLParameters.m_bLOBSupport = uRLParameters2.m_bLOBSupport;
        uRLParameters.m_sLOBTempTable = uRLParameters2.m_sLOBTempTable;
        uRLParameters.m_bUseXViews = uRLParameters2.m_bUseXViews;
        uRLParameters.m_bTrustedSQLAwareness = uRLParameters2.m_bTrustedSQLAwareness;
        uRLParameters.m_bLiteralUnderscore = uRLParameters2.m_bLiteralUnderscore;
        uRLParameters.m_nSlobReceiveThreshold = uRLParameters2.m_nSlobReceiveThreshold;
        uRLParameters.m_nSlobTransmitThreshold = uRLParameters2.m_nSlobTransmitThreshold;
        uRLParameters.m_bCredentialsFromGetURL = uRLParameters2.m_bCredentialsFromGetURL;
        uRLParameters.m_bMayBeNull = uRLParameters2.m_bMayBeNull;
        uRLParameters.m_bAccurateColumnNames = uRLParameters2.m_bAccurateColumnNames;
        uRLParameters.m_bXXEProcessing = uRLParameters2.m_bXXEProcessing;
    }

    public String getDelegatedParameters() {
        return this.getDelegatedParameters(false, true);
    }

    public String getDelegatedParameters(boolean bl, boolean bl2) {
        String string = (this.getDbsPort() != 1025 ? "DBS_PORT=" + this.getDbsPort() : "") + (this.getHTTPSPort() != 443 ? ",HTTPS_PORT=" + this.getHTTPSPort() : "") + (this.getSSLMode() != null ? ",SSLMODE=" + this.getSSLMode() : "") + (this.getSSLProtocol() != null ? ",SSLPROTOCOL=" + URLParameters.singleQuoteIfNeeded(this.getSSLProtocol()) : "") + (this.getSSLCipher() != null ? ",SSLCIPHER=" + URLParameters.singleQuoteIfNeeded(this.getSSLCipher()) : "") + (this.getSSLDebug() ? ",SSLDEBUG=ON" : "") + (this.getSSLCA() != null ? ",SSLCA=" + URLParameters.singleQuoteIfNeeded(this.getSSLCA()) : "") + (this.getSSLCAPath() != null ? ",SSLCAPATH=" + URLParameters.singleQuoteIfNeeded(this.getSSLCAPath()) : "") + (this.getSSLTrustStore() != null ? ",SSLTRUSTSTORE=" + URLParameters.singleQuoteIfNeeded(this.getSSLTrustStore()) : "") + (!"ERROR".equals(this.getLogLevel()) || bl2 ? ",LOG=" + this.getLogLevel() : "") + (!this.getCopDiscovery() ? ",COP=OFF" : "") + (this.getCOPLast() ? ",COPLAST=ON" : "") + (this.getConnectFailureTTL() != 0L ? ",CONNECT_FAILURE_TTL=" + this.getConnectFailureTTL() : "") + (this.getTCP() != null ? ",TCP=" + this.getTCP() : "") + (this.getCharSet() != null && !this.getCharSet().equals("ASCII") ? ",CHARSET=" + this.getCharSet() : "") + (this.getClientCharset() != null ? ",CLIENT_CHARSET=" + this.getClientCharset() : "") + (this.getEncryptData() ? ",ENCRYPTDATA=ON" : "") + (this.getLogMech() != null ? ",LOGMECH=" + (bl ? "BROWSER" : this.getLogMech()) : "") + (this.getLogData() != null && !bl ? ",LOGDATA=" + URLParameters.singleQuoteIfNeeded(this.getLogData()) : "") + (this.getAccountId() != null && this.getAccountId().length() > 0 && !this.getAccountId().equals("NO_ACCOUNT_ID") ? ",ACCOUNT=" + URLParameters.singleQuoteIfNeeded(this.getAccountId()) : "") + (this.getRunStartup() ? ",RUNSTARTUP=ON" : "") + (!this.isGoverned() ? ",GOVERN=OFF" : "") + (this.getReconnectCount() != 0 ? ",RECONNECT_COUNT=" + this.getReconnectCount() : "") + (this.getReconnectInterval() != 0 ? ",RECONNECT_INTERVAL=" + this.getReconnectInterval() : "") + (this.getFinalizeAutoClose() ? ",FINALIZE_AUTO_CLOSE=ON" : "") + (this.getStrictEncode() != null ? ",STRICT_ENCODE=" + (Boolean.TRUE.equals(this.getStrictEncode()) ? "ON" : "OFF") : "") + (this.getRedrive() != null ? ",REDRIVE=" + this.getRedrive() : "") + (this.getMaxMessageBody() != 2097000 ? ",MAX_MESSAGE_BODY=" + this.getMaxMessageBody() : "") + (this.getFlatten() ? ",FLATTEN=ON" : "");
        if (string.startsWith(",")) {
            string = string.substring(1);
        }
        return string;
    }

    public String synthesizeURL(GenericTeradataConnection genericTeradataConnection) throws SQLException {
        String string = this.getDelegatedParameters(this.m_bLogMechBrowser, false) + (genericTeradataConnection.getLogonInformation().getUserName() != null && genericTeradataConnection.getLogonInformation().getUserName().length() > 0 && this.getCredentialsFromGetURL() ? ",USER=" + URLParameters.singleQuoteIfNeeded(genericTeradataConnection.getLogonInformation().getUserName()) : "") + (genericTeradataConnection.getLogonInformation().getPassword() != null && genericTeradataConnection.getLogonInformation().getPassword().length() > 0 && this.getCredentialsFromGetURL() ? ",PASSWORD=" + URLParameters.singleQuoteIfNeeded(genericTeradataConnection.getLogonInformation().getPassword()) : "") + (this.getNewPassword() != null && this.getCredentialsFromGetURL() ? ",NEW_PASSWORD=" + URLParameters.singleQuoteIfNeeded(this.getNewPassword()) : "") + ("ANSI".equals(this.getTransactMode()) && !this.isJavaSPDefaultConnection() ? ",TMODE=ANSI" : "") + ("TERA".equals(this.getTransactMode()) && !this.isJavaSPDefaultConnection() ? ",TMODE=TERA" : "") + (this.getPartition() != null && !this.getPartition().equals("DBC/SQL") ? ",PARTITION=" + this.getPartition() : "") + (this.getLogonSequenceNumber() != null ? ",LOGON_SEQUENCE_NUMBER=" + this.getLogonSequenceNumber() : "") + (this.getConnectFunction() != 0 ? ",CONNECT_FUNCTION=" + this.getConnectFunction() : "") + (this.getLssType() != null && !this.getLssType().equals("") ? ",LSS_TYPE=" + this.getLssType() : "") + (this.getType() != null && !this.getType().equals("DEFAULT") ? ",TYPE=" + this.getType() : "") + (this.getSessions() != 0 ? ",SESSIONS=" + this.getSessions() : "") + (this.getDatabaseName() != null && this.getDatabaseName().length() > 0 && !this.getDatabaseName().equals("NO_DEF_DATABASE") ? ",DATABASE=" + URLParameters.singleQuoteIfNeeded(this.getDatabaseName()) : "") + (this.getSpl() != null && !this.getSpl().equals("SPL") ? ",SP_SPL=" + this.getSpl() : "") + (this.getTimeNano() != -1 ? ",TNANO=" + this.getTimeNano() : "") + (this.getTimestampNano() != -1 ? ",TSNANO=" + this.getTimestampNano() : "") + (!this.getPrepSupport() ? ",PREP_SUPPORT=OFF" : "") + (!this.sipSupport() ? ",SIP_SUPPORT=OFF" : "") + (!this.isLobSupported() ? ",LOB_SUPPORT=OFF" : "") + (this.getLobTempTable() != null ? ",LOB_TEMP_TABLE=" + URLParameters.singleQuoteIfNeeded(URLParameters.undoDoubleQuotes(this.getLobTempTable())) : "") + (this.getuseXviews() ? ",USEXVIEWS=ON" : "") + (this.getTrustedSQLAwareness() ? ",TRUSTED_SQL=ON" : "") + (this.getDataDictStats() ? ",DDSTATS=ON" : "") + (this.getLiteralUnderscore() ? ",LITERAL_UNDERSCORE=ON" : "") + (this.getFieldSeparator() != null && !this.getFieldSeparator().equals(",") ? ",FIELD_SEP=" + URLParameters.singleQuoteIfNeeded(this.getFieldSeparator()) : "") + (this.getSlobReceiveThreshold() != 1000 ? ",SLOB_RECEIVE_THRESHOLD=" + this.getSlobReceiveThreshold() : "") + (this.getSlobTransmitThreshold() != 1000 ? ",SLOB_TRANSMIT_THRESHOLD=" + this.getSlobTransmitThreshold() : "") + (this.getCredentialsFromGetURL() ? ",GETURL_CREDENTIALS=ON" : "") + (this.getMayBeNull() ? ",MAYBENULL=ON" : "") + (this.getAccurateColumnNames() ? ",COLUMN_NAME=ON" : "") + (this.getErrorQueryCount() != 21 ? ",ERROR_QUERY_COUNT=" + this.getErrorQueryCount() : "") + (this.getErrorQueryInterval() != 500 ? ",ERROR_QUERY_INTERVAL=" + this.getErrorQueryInterval() : "") + (this.getErrorTableDatabase() != null ? ",ERROR_TABLE_DATABASE=" + URLParameters.singleQuoteIfNeeded(this.getErrorTableDatabase()) : "") + (this.getErrorTable1Suffix() != null && !this.getErrorTable1Suffix().equals("_ERR_1") ? ",ERROR_TABLE_1_SUFFIX=" + URLParameters.singleQuoteIfNeeded(this.getErrorTable1Suffix()) : "") + (this.getErrorTable2Suffix() != null && !this.getErrorTable2Suffix().equals("_ERR_2") ? ",ERROR_TABLE_2_SUFFIX=" + URLParameters.singleQuoteIfNeeded(this.getErrorTable2Suffix()) : "") + (this.getXXEProcessing() ? ",XXE_PROCESSING=ON" : "") + (this.getBrowser() != null ? ",BROWSER=" + URLParameters.singleQuoteIfNeeded(this.getBrowser()) : "") + (this.getBrowserTimeout() != 180 ? ",BROWSER_TIMEOUT=" + this.getBrowserTimeout() : "") + (this.getOIDCScope() != null && !this.getOIDCScope().equals("openid") ? ",OIDC_SCOPE=" + this.getOIDCScope() : "") + (this.getOIDCToken() != null && !this.getOIDCToken().equals("access_token") ? ",OIDC_TOKEN=" + this.getOIDCToken() : "");
        if (string.startsWith(",")) {
            string = string.substring(1);
        }
        if (string.length() > 0) {
            string = "/" + string;
        }
        return (this.isJavaSPDefaultConnection() ? "jdbc:default:connection" : "jdbc:teradata://" + genericTeradataConnection.getIO().getOriginalHostName()) + string;
    }

    public static String undoDoubleQuotes(String string) {
        return string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1).replaceAll("\"\"", "\"") : string;
    }

    public static String singleQuoteIfNeeded(String string) {
        return string.indexOf(32) >= 0 || string.indexOf(44) >= 0 || string.indexOf(39) >= 0 ? "'" + string.replaceAll("'", "''") + "'" : string;
    }

    private void ParseParams(Properties properties, String string) throws SQLException {
        String string2 = string;
        while (string2.length() > 0) {
            int n = (string2 = string2.trim()).indexOf(61, 0);
            if (n >= 0) {
                String string3;
                int n2;
                String string4 = string2.substring(0, n).trim();
                if ((string2 = string2.substring(n + 1).trim()).length() == 0 || string2.charAt(0) == ',') {
                    throw ErrorFactory.makeDriverJDBCException("TJ631", string4);
                }
                int n3 = -1;
                int n4 = -1;
                int n5 = 0;
                n3 = string2.indexOf(39);
                if (n3 != -1) {
                    n2 = n3;
                    while ((n4 = string2.indexOf(39, n2 + 1)) != -1 && string2.length() > n4 + 1 && string2.charAt(n4 + 1) == '\'') {
                        if (n5 == 0) {
                            n5 = n4;
                        }
                        n2 = n4 + 2;
                    }
                }
                n = string2.indexOf(44, 0);
                n2 = string2.indexOf(32, 0);
                if (n != -1 && n > n3 && n < n4) {
                    n = string2.indexOf(44, n4 + 1);
                }
                if (n2 != -1 && n2 > n3 && n2 < n4) {
                    n2 = string2.indexOf(32, n4 + 1);
                }
                int n6 = n;
                if (n < 0) {
                    n6 = n2;
                } else {
                    n6 = n;
                    if (n2 >= 0 && n2 < n) {
                        n6 = n2;
                    }
                }
                if (n6 > 0) {
                    string3 = string2.substring(0, n6);
                    string2 = string2.substring(n6 + 1);
                } else if (n6 == 0) {
                    string3 = "";
                    string2 = string2.substring(n6 + 1);
                } else {
                    string3 = string2;
                    string2 = "";
                }
                if (n5 != 0 && (n5 <= n6 || n6 == -1)) {
                    string3 = string3.replaceAll("''", "'");
                }
                if (string3.charAt(0) == '\'') {
                    string3 = string3.substring(1);
                }
                if (string3.length() > 0 && string3.charAt(string3.length() - 1) == '\'') {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                properties.setProperty(string4, string3);
                continue;
            }
            string2 = "";
        }
    }

    public void setJavaSPDefaultConnection(boolean bl) {
        this.m_bJavaSPDefaultConnection = bl;
    }

    public boolean isJavaSPDefaultConnection() {
        return this.m_bJavaSPDefaultConnection;
    }

    protected void setLoginTimeout(int n) {
        this.m_nLoginTimeout = n;
    }

    public int getLoginTimeout() {
        return this.m_nLoginTimeout;
    }

    protected void setCompatDBS(String string) throws SQLException {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.m_nCompatDBS = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.m_nCompatDBS = 2;
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "COMPAT_DBS", string);
            }
        }
    }

    public int getCompatDBS() {
        return this.m_nCompatDBS;
    }

    protected void setCompatIsAutoInc(String string) throws SQLException {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.m_nCompatIsAutoInc = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.m_nCompatIsAutoInc = 2;
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "COMPAT_ISAUTOINC", string);
            }
        }
    }

    public int getCompatIsAutoInc() {
        return this.m_nCompatIsAutoInc;
    }

    protected void setCompatIsCurrency(String string) throws SQLException {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.m_nCompatIsCurrency = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.m_nCompatIsCurrency = 2;
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "COMPAT_ISCURRENCY", string);
            }
        }
    }

    public int getCompatIsCurrency() {
        return this.m_nCompatIsCurrency;
    }

    protected void setCompatIsSigned(String string) throws SQLException {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.m_nCompatIsSigned = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.m_nCompatIsSigned = 2;
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "COMPAT_ISSIGNED", string);
            }
        }
    }

    public int getCompatIsSigned() {
        return this.m_nCompatIsSigned;
    }

    protected void setCompatIsSearch(String string) throws SQLException {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.m_nCompatIsSearch = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.m_nCompatIsSearch = 2;
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "COMPAT_ISSEARCH", string);
            }
        }
    }

    public int getCompatIsSearch() {
        return this.m_nCompatIsSearch;
    }

    protected void setCompatGetSchema(String string) {
        if (string != null) {
            this.m_sCompatGetSchema = string;
        }
    }

    public String getCompatGetSchema() {
        return this.m_sCompatGetSchema;
    }

    protected void setCompatGetTable(String string) {
        if (string != null) {
            this.m_sCompatGetTable = string;
        }
    }

    public String getCompatGetTable() {
        return this.m_sCompatGetTable;
    }

    protected void setCompatIsReadOnly(String string) throws SQLException {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.m_nCompatIsReadOnly = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.m_nCompatIsReadOnly = 2;
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "COMPAT_ISREADONLY", string);
            }
        }
    }

    public int getCompatIsReadOnly() {
        return this.m_nCompatIsReadOnly;
    }

    protected void setCompatIsWritable(String string) throws SQLException {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.m_nCompatIsWritable = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.m_nCompatIsWritable = 2;
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "COMPAT_ISWRITABLE", string);
            }
        }
    }

    public int getCompatIsWritable() {
        return this.m_nCompatIsWritable;
    }

    protected void setCompatIsDefWrit(String string) throws SQLException {
        if (string != null) {
            if (string.equalsIgnoreCase("TRUE")) {
                this.m_nCompatIsDefWrit = 1;
            } else if (string.equalsIgnoreCase("FALSE")) {
                this.m_nCompatIsDefWrit = 2;
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "COMPAT_ISDEFWRIT", string);
            }
        }
    }

    public int getCompatIsDefWrit() {
        return this.m_nCompatIsDefWrit;
    }

    protected void setDbsPort(String string) throws SQLException {
        if (string != null) {
            NumberFormatException numberFormatException = null;
            try {
                this.m_nDBSPort = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
            if (numberFormatException != null || this.m_nDBSPort <= 0) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "DBS_PORT", string);
                sQLException.initCause(numberFormatException);
                throw sQLException;
            }
        }
    }

    public int getDbsPort() {
        return this.m_nDBSPort;
    }

    protected void setHTTPSPort(String string) throws SQLException {
        if (string != null) {
            NumberFormatException numberFormatException = null;
            try {
                this.m_nHTTPSPort = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
            if (numberFormatException != null || this.m_nHTTPSPort <= 0) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "HTTPS_PORT", string);
                sQLException.initCause(numberFormatException);
                throw sQLException;
            }
        }
    }

    public int getHTTPSPort() {
        return this.m_nHTTPSPort;
    }

    public void setSSLMode(String string) throws SQLException {
        if (string != null) {
            if ("DISABLE".equalsIgnoreCase(string) || "ALLOW".equalsIgnoreCase(string) || "PREFER".equalsIgnoreCase(string) || "REQUIRE".equalsIgnoreCase(string) || "VERIFY-CA".equalsIgnoreCase(string) || "VERIFY-FULL".equalsIgnoreCase(string)) {
                this.m_sSSLMode = string.toUpperCase();
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "SSLMODE", string);
            }
        }
        if (this.m_sSSLMode == null) {
            this.m_nSSLModeLevel = 3;
        } else if ("DISABLE".equals(this.m_sSSLMode)) {
            this.m_nSSLModeLevel = 1;
        } else if ("ALLOW".equals(this.m_sSSLMode)) {
            this.m_nSSLModeLevel = 2;
        } else if ("PREFER".equals(this.m_sSSLMode)) {
            this.m_nSSLModeLevel = 3;
        } else if ("REQUIRE".equals(this.m_sSSLMode)) {
            this.m_nSSLModeLevel = 4;
        } else if ("VERIFY-CA".equals(this.m_sSSLMode)) {
            this.m_nSSLModeLevel = 5;
        } else if ("VERIFY-FULL".equals(this.m_sSSLMode)) {
            this.m_nSSLModeLevel = 6;
        }
    }

    public String getSSLMode() {
        return this.m_sSSLMode;
    }

    public int getSSLModeLevel() {
        return this.m_nSSLModeLevel;
    }

    public boolean isHTTPSPort(int n) {
        return n == this.m_nHTTPSPort && this.m_nSSLModeLevel >= 2;
    }

    protected void setSSLProtocol(String string) {
        if (string != null) {
            this.m_sSSLProtocol = string;
        }
    }

    public String getSSLProtocol() {
        return this.m_sSSLProtocol;
    }

    protected void setSSLCipher(String string) {
        if (string != null) {
            this.m_sSSLCipher = string;
        }
    }

    public String getSSLCipher() {
        return this.m_sSSLCipher;
    }

    protected void setSSLDebug(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bSSLDebug = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "SSLDEBUG", string);
            }
        }
    }

    public boolean getSSLDebug() {
        return this.m_bSSLDebug;
    }

    protected void setSSLCA(String string) {
        if (string != null) {
            this.m_sSSLCA = string;
        }
    }

    public String getSSLCA() {
        return this.m_sSSLCA;
    }

    protected void setSSLCAPath(String string) {
        if (string != null) {
            this.m_sSSLCAPath = string;
        }
    }

    public String getSSLCAPath() {
        return this.m_sSSLCAPath;
    }

    protected void setSSLTrustStore(String string) {
        if (string != null) {
            this.m_sSSLTrustStore = string;
        }
    }

    public String getSSLTrustStore() {
        return this.m_sSSLTrustStore;
    }

    public void setLogLevel(String string) throws SQLException {
        if (string != null) {
            if ("ERROR".equalsIgnoreCase(string) || "TIMING".equalsIgnoreCase(string) || "INFO".equalsIgnoreCase(string) || "DEBUG".equalsIgnoreCase(string)) {
                this.m_sLogLevel = string.toUpperCase();
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "LOG", string);
            }
        }
    }

    public String getLogLevel() {
        return this.m_sLogLevel;
    }

    public void setCopDiscovery(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bCOPDiscovery = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "COP", string);
            }
        }
    }

    public boolean getCopDiscovery() {
        return this.m_bCOPDiscovery;
    }

    public void setCOPLast(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bCOPLast = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "COPLAST", string);
            }
        }
    }

    public boolean getCOPLast() {
        return this.m_bCOPLast;
    }

    public void setConnectFailureTTL(String string) throws SQLException {
        if (string != null) {
            try {
                this.m_nConnectFailureTTL = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "CONNECT_FAILURE_TTL", string);
                sQLException.initCause(numberFormatException);
                throw sQLException;
            }
        }
    }

    public long getConnectFailureTTL() {
        return this.m_nConnectFailureTTL;
    }

    public void setTCP(String string) {
        if (string != null) {
            this.m_sTCP = string;
        }
    }

    public String getTCP() {
        return this.m_sTCP;
    }

    public void setCharSet(String string) {
        if (string != null) {
            this.m_sCharSet = string.toUpperCase();
        }
    }

    public String getCharSet() {
        return this.m_sCharSet;
    }

    protected void setClientCharset(String string) {
        if (string != null) {
            this.m_sClientCharset = string;
        }
    }

    public String getClientCharset() {
        return this.m_sClientCharset;
    }

    protected void setEncryptData(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bEncryptData = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "ENCRYPTDATA", string);
            }
        }
    }

    public boolean getEncryptData() {
        return this.m_bEncryptData;
    }

    public void setLogMech(String string) {
        if ("BROWSER".equalsIgnoreCase(this.m_sLogMech) && "JWT".equalsIgnoreCase(string)) {
            this.m_bLogMechBrowser = true;
        }
        if (string != null) {
            this.m_sLogMech = string;
        }
    }

    public String getLogMech() {
        return this.m_sLogMech;
    }

    public void setLogData(String string) {
        if (string != null) {
            this.m_sLogData = string;
        }
    }

    public String getLogData() {
        return this.m_sLogData;
    }

    protected void setAccountId(String string) {
        if (string != null) {
            this.m_sAccountId = string;
        }
    }

    public String getAccountId() {
        return this.m_sAccountId;
    }

    public void setRunStartup(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bRunStartup = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "RUNSTARTUP", string);
            }
        }
    }

    public boolean getRunStartup() {
        return this.m_bRunStartup;
    }

    protected void setGovern(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bIsGoverned = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "GOVERN", string);
            }
        }
    }

    public boolean isGoverned() {
        return this.m_bIsGoverned;
    }

    public void setReconnectCount(String string) throws SQLException {
        if (string != null) {
            NumberFormatException numberFormatException = null;
            try {
                this.m_nReconnectCount = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
            if (numberFormatException != null || this.m_nReconnectCount < 0) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "RECONNECT_COUNT", string);
                if (numberFormatException != null) {
                    sQLException.initCause(numberFormatException);
                }
                throw sQLException;
            }
        }
    }

    public int getReconnectCount() {
        return this.m_nReconnectCount;
    }

    public void setReconnectInterval(String string) throws SQLException {
        if (string != null) {
            NumberFormatException numberFormatException = null;
            try {
                this.m_nReconnectInterval = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
            if (numberFormatException != null || this.m_nReconnectInterval < 0) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "RECONNECT_INTERVAL", string);
                if (numberFormatException != null) {
                    sQLException.initCause(numberFormatException);
                }
                throw sQLException;
            }
        }
    }

    public int getReconnectInterval() {
        return this.m_nReconnectInterval;
    }

    public void setFinalizeAutoClose(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bFinalizeAutoClose = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "FINALIZE_AUTO_CLOSE", string);
            }
        }
    }

    public boolean getFinalizeAutoClose() {
        return this.m_bFinalizeAutoClose;
    }

    public void setStrictEncode(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string)) {
                this.m_bStrictEncode = Boolean.TRUE;
            } else if ("OFF".equalsIgnoreCase(string)) {
                this.m_bStrictEncode = Boolean.FALSE;
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "STRICT_ENCODE", string);
            }
        }
    }

    public Boolean getStrictEncode() {
        return this.m_bStrictEncode;
    }

    public void setRedrive(String string) throws SQLException {
        if (string != null) {
            NumberFormatException numberFormatException = null;
            try {
                this.m_nRedrive = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
            if (numberFormatException != null || this.m_nRedrive < 0) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "REDRIVE", string);
                if (numberFormatException != null) {
                    sQLException.initCause(numberFormatException);
                }
                throw sQLException;
            }
        }
    }

    public Integer getRedrive() {
        return this.m_nRedrive;
    }

    public void setMaxMessageBody(String string) throws SQLException {
        if (string != null) {
            NumberFormatException numberFormatException = null;
            try {
                this.m_nMaxMessageBody = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
            if (numberFormatException != null || this.m_nMaxMessageBody < 0) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "MAX_MESSAGE_BODY", string);
                if (numberFormatException != null) {
                    sQLException.initCause(numberFormatException);
                }
                throw sQLException;
            }
        }
    }

    public int getMaxMessageBody() {
        return this.m_nMaxMessageBody;
    }

    public String getUser() {
        return this.m_sUser;
    }

    public String getPassword() {
        return this.m_sPassword;
    }

    public void setNewPassword(String string) {
        if (string != null) {
            this.m_sNewPassword = string;
        }
    }

    public String getNewPassword() {
        return this.m_sNewPassword;
    }

    public void setTransactMode(String string) throws SQLException {
        if (string != null) {
            if ("TERA".equalsIgnoreCase(string) || "T".equalsIgnoreCase(string) || "Teradata".equalsIgnoreCase(string)) {
                this.m_sTransactMode = "TERA";
            } else if ("ANSI".equalsIgnoreCase(string) || "A".equalsIgnoreCase(string)) {
                this.m_sTransactMode = "ANSI";
            } else if ("DEFAULT".equalsIgnoreCase(string) || "D".equalsIgnoreCase(string)) {
                this.m_sTransactMode = "DEFAULT";
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "TMODE", string);
            }
        }
    }

    public String getTransactMode() {
        return this.m_sTransactMode;
    }

    protected void setPartition(String string) {
        if (string != null) {
            this.m_sPartition = string;
        }
    }

    public String getPartition() {
        return this.m_sPartition;
    }

    protected void setLogonSequenceNumber(String string) throws SQLException {
        if (string != null) {
            try {
                this.m_nLogonSequenceNumber = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ404", string);
                sQLException.initCause(numberFormatException);
                throw sQLException;
            }
        }
    }

    public Integer getLogonSequenceNumber() {
        return this.m_nLogonSequenceNumber;
    }

    protected void setConnectFunction(String string) throws SQLException {
        if (string != null) {
            try {
                this.m_nConnectFunction = Short.parseShort(string);
            }
            catch (NumberFormatException numberFormatException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ405", string);
                sQLException.initCause(numberFormatException);
                throw sQLException;
            }
        }
    }

    public short getConnectFunction() {
        return this.m_nConnectFunction;
    }

    protected void setLssType(String string) {
        if (string != null) {
            this.m_sLSSType = string;
        }
    }

    public String getLssType() {
        return this.m_sLSSType;
    }

    public void setType(String string) {
        if (string != null) {
            this.m_sType = string;
        }
    }

    public String getType() {
        return this.m_sType;
    }

    protected void setSessions(String string) throws SQLException {
        if (string != null) {
            try {
                this.m_nSessions = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ454", string);
                sQLException.initCause(numberFormatException);
                throw sQLException;
            }
            if (this.m_nSessions < 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ455", this.m_nSessions);
            }
        }
    }

    public int getSessions() {
        return this.m_nSessions;
    }

    protected void setDatabaseName(String string) {
        if (string != null) {
            this.m_sDatabaseName = string;
        }
    }

    public String getDatabaseName() {
        return this.m_sDatabaseName;
    }

    public void setSpl(String string) throws SQLException {
        if (string != null) {
            if ("SPL".equalsIgnoreCase(string) || "NOSPL".equalsIgnoreCase(string)) {
                this.m_sSPL = string.toUpperCase();
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "SP_SPL", string);
            }
        }
    }

    public String getSpl() {
        return this.m_sSPL;
    }

    protected void setTimeNano(String string) throws SQLException {
        if (string != null) {
            try {
                this.m_nTimeNano = Integer.parseInt(string);
                if (this.m_nTimeNano > 6) {
                    this.m_nTimeNano = 6;
                } else if (this.m_nTimeNano < 0) {
                    this.m_nTimeNano = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "TNANO", string);
                sQLException.initCause(numberFormatException);
                throw sQLException;
            }
        }
    }

    public int getTimeNano() {
        return this.m_nTimeNano;
    }

    protected void setTimestampNano(String string) throws SQLException {
        if (string != null) {
            try {
                this.m_nTimestampNano = Integer.parseInt(string);
                if (this.m_nTimestampNano > 6) {
                    this.m_nTimestampNano = 6;
                } else if (this.m_nTimestampNano < 0) {
                    this.m_nTimestampNano = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "TSNANO", string);
                sQLException.initCause(numberFormatException);
                throw sQLException;
            }
        }
    }

    public int getTimestampNano() {
        return this.m_nTimestampNano;
    }

    private void setPrepSupport(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bPrepSupport = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "PREP_SUPPORT", string);
            }
        }
    }

    public boolean getPrepSupport() {
        return this.m_bPrepSupport;
    }

    protected void setSipSupport(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bSIPSupport = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "SIP_SUPPORT", string);
            }
        }
    }

    public boolean sipSupport() {
        return this.m_bSIPSupport;
    }

    public void setLobSupport(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bLOBSupport = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "LOB_SUPPORT", string);
            }
        }
    }

    public boolean isLobSupported() {
        return this.m_bLOBSupport;
    }

    protected void setLobTempTable(String string) {
        if (string != null) {
            this.m_sLOBTempTable = "\"" + string.replaceAll("\"", "\"\"").replaceAll("[.]", "\".\"") + "\"";
        }
    }

    public String getLobTempTable() {
        return this.m_sLOBTempTable;
    }

    public void setuseXviews(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bUseXViews = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "USEXVIEWS", string);
            }
        }
    }

    public boolean getuseXviews() {
        return this.m_bUseXViews;
    }

    public void setTrustedSQLAwareness(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bTrustedSQLAwareness = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "TRUSTED_SQL", string);
            }
        }
    }

    public boolean getTrustedSQLAwareness() {
        return this.m_bTrustedSQLAwareness;
    }

    public void setDataDictStats(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bDataDictStats = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "DDSTATS", string);
            }
        }
    }

    public boolean getDataDictStats() {
        return this.m_bDataDictStats;
    }

    public void setLiteralUnderscore(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bLiteralUnderscore = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "LITERAL_UNDERSCORE", string);
            }
        }
    }

    public boolean getLiteralUnderscore() {
        return this.m_bLiteralUnderscore;
    }

    public void setFieldSeparator(String string) {
        if (string != null) {
            this.m_sFieldSeparator = string;
        }
    }

    public String getFieldSeparator() {
        return this.m_sFieldSeparator;
    }

    public void setSlobReceiveThreshold(String string) throws SQLException {
        if (string != null) {
            try {
                this.m_nSlobReceiveThreshold = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "SLOB_RECEIVE_THRESHOLD", string);
                sQLException.initCause(numberFormatException);
                throw sQLException;
            }
        }
    }

    public int getSlobReceiveThreshold() {
        return this.m_nSlobReceiveThreshold;
    }

    public void setSlobTransmitThreshold(String string) throws SQLException {
        if (string != null) {
            try {
                this.m_nSlobTransmitThreshold = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "SLOB_TRANSMIT_THRESHOLD", string);
                sQLException.initCause(numberFormatException);
                throw sQLException;
            }
        }
    }

    public int getSlobTransmitThreshold() {
        return this.m_nSlobTransmitThreshold;
    }

    public void setCredentialsFromGetURL(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bCredentialsFromGetURL = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "GETURL_CREDENTIALS", string);
            }
        }
    }

    public boolean getCredentialsFromGetURL() {
        return this.m_bCredentialsFromGetURL;
    }

    public void setMayBeNull(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bMayBeNull = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "MAYBENULL", string);
            }
        }
    }

    public boolean getMayBeNull() {
        return this.m_bMayBeNull;
    }

    public void setAccurateColumnNames(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bAccurateColumnNames = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "COLUMN_NAME", string);
            }
        }
    }

    public boolean getAccurateColumnNames() {
        return this.m_bAccurateColumnNames;
    }

    public void setErrorQueryCount(String string) throws SQLException {
        if (string != null) {
            NumberFormatException numberFormatException = null;
            try {
                this.m_nErrorQueryCount = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
            if (numberFormatException != null || this.m_nErrorQueryCount < 1) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "ERROR_QUERY_COUNT", string);
                if (numberFormatException != null) {
                    sQLException.initCause(numberFormatException);
                }
                throw sQLException;
            }
        }
    }

    public int getErrorQueryCount() {
        return this.m_nErrorQueryCount;
    }

    public void setErrorQueryInterval(String string) throws SQLException {
        if (string != null) {
            NumberFormatException numberFormatException = null;
            try {
                this.m_nErrorQueryInterval = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
            if (numberFormatException != null || this.m_nErrorQueryInterval < 0) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "ERROR_QUERY_INTERVAL", string);
                if (numberFormatException != null) {
                    sQLException.initCause(numberFormatException);
                }
                throw sQLException;
            }
        }
    }

    public int getErrorQueryInterval() {
        return this.m_nErrorQueryInterval;
    }

    public void setErrorTableDatabase(String string) {
        if (string != null) {
            this.m_sErrorTableDatabase = string;
        }
    }

    public String getErrorTableDatabase() {
        return this.m_sErrorTableDatabase;
    }

    public void setErrorTable1Suffix(String string) {
        if (string != null) {
            this.m_sErrorTable1Suffix = string;
        }
    }

    public String getErrorTable1Suffix() {
        return this.m_sErrorTable1Suffix;
    }

    public void setErrorTable2Suffix(String string) {
        if (string != null) {
            this.m_sErrorTable2Suffix = string;
        }
    }

    public String getErrorTable2Suffix() {
        return this.m_sErrorTable2Suffix;
    }

    public void setXXEProcessing(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bXXEProcessing = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "XXE_PROCESSING", string);
            }
        }
    }

    public boolean getXXEProcessing() {
        return this.m_bXXEProcessing;
    }

    public void setBrowser(String string) {
        if (string != null) {
            this.m_sBrowser = string;
        }
    }

    public String getBrowser() {
        return this.m_sBrowser;
    }

    public int getBrowserTimeout() {
        return this.m_nBrowserTimeout;
    }

    public void setBrowserTimeout(String string) throws SQLException {
        if (string != null) {
            NumberFormatException numberFormatException = null;
            try {
                this.m_nBrowserTimeout = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException2) {
                numberFormatException = numberFormatException2;
            }
            if (numberFormatException != null || this.m_nBrowserTimeout < 0) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ594", "BROWSER_TIMEOUT", string);
                if (numberFormatException != null) {
                    sQLException.initCause(numberFormatException);
                }
                throw sQLException;
            }
        }
    }

    public void setOIDCScope(String string) {
        if (string != null) {
            this.m_sOIDCScope = string;
        }
    }

    public String getOIDCScope() {
        return this.m_sOIDCScope;
    }

    public void setOIDCToken(String string) {
        if (string != null) {
            this.m_sOIDCToken = string;
        }
    }

    public String getOIDCToken() {
        return this.m_sOIDCToken;
    }

    public void setFlatten(String string) throws SQLException {
        if (string != null) {
            if ("ON".equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string)) {
                this.m_bFlatten = "ON".equalsIgnoreCase(string);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ843", "FLATTEN", string);
            }
        }
    }

    public boolean getFlatten() {
        return this.m_bFlatten;
    }
}

