/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.TableVersion;

@SdkInternalApi
public class TableVersionMarshaller {
    private static final MarshallingInfo<StructuredPojo> TABLE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Table").build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").build();
    private static final TableVersionMarshaller instance = new TableVersionMarshaller();

    public static TableVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(TableVersion tableVersion, ProtocolMarshaller protocolMarshaller) {
        if (tableVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(tableVersion.getTable(), TABLE_BINDING);
            protocolMarshaller.marshall(tableVersion.getVersionId(), VERSIONID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

