/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.DataLakePrincipal;
import com.simba.athena.amazonaws.services.glue.model.Permission;
import com.simba.athena.amazonaws.services.glue.model.transform.PrincipalPermissionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PrincipalPermissions
implements Serializable,
Cloneable,
StructuredPojo {
    private DataLakePrincipal principal;
    private List<String> permissions;

    public void setPrincipal(DataLakePrincipal principal) {
        this.principal = principal;
    }

    public DataLakePrincipal getPrincipal() {
        return this.principal;
    }

    public PrincipalPermissions withPrincipal(DataLakePrincipal principal) {
        this.setPrincipal(principal);
        return this;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<String> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<String>(permissions);
    }

    public PrincipalPermissions withPermissions(String ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<String>(permissions.length));
        }
        for (String ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public PrincipalPermissions withPermissions(Collection<String> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public PrincipalPermissions withPermissions(Permission ... permissions) {
        ArrayList<String> permissionsCopy = new ArrayList<String>(permissions.length);
        for (Permission value : permissions) {
            permissionsCopy.add(value.toString());
        }
        if (this.getPermissions() == null) {
            this.setPermissions(permissionsCopy);
        } else {
            this.getPermissions().addAll(permissionsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrincipal() != null) {
            sb.append("Principal: ").append(this.getPrincipal()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalPermissions)) {
            return false;
        }
        PrincipalPermissions other = (PrincipalPermissions)obj;
        if (other.getPrincipal() == null ^ this.getPrincipal() == null) {
            return false;
        }
        if (other.getPrincipal() != null && !other.getPrincipal().equals(this.getPrincipal())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        return other.getPermissions() == null || other.getPermissions().equals(this.getPermissions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrincipal() == null ? 0 : this.getPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        return hashCode;
    }

    public PrincipalPermissions clone() {
        try {
            return (PrincipalPermissions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PrincipalPermissionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

