/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model;

import com.simba.athena.amazonaws.AmazonWebServiceResult;
import com.simba.athena.amazonaws.ResponseMetadata;
import com.simba.athena.amazonaws.services.glue.model.Statement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListStatementsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Statement> statements;
    private String nextToken;

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(Collection<Statement> statements) {
        if (statements == null) {
            this.statements = null;
            return;
        }
        this.statements = new ArrayList<Statement>(statements);
    }

    public ListStatementsResult withStatements(Statement ... statements) {
        if (this.statements == null) {
            this.setStatements(new ArrayList<Statement>(statements.length));
        }
        for (Statement ele : statements) {
            this.statements.add(ele);
        }
        return this;
    }

    public ListStatementsResult withStatements(Collection<Statement> statements) {
        this.setStatements(statements);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListStatementsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatements() != null) {
            sb.append("Statements: ").append(this.getStatements()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStatementsResult)) {
            return false;
        }
        ListStatementsResult other = (ListStatementsResult)obj;
        if (other.getStatements() == null ^ this.getStatements() == null) {
            return false;
        }
        if (other.getStatements() != null && !other.getStatements().equals(this.getStatements())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatements() == null ? 0 : this.getStatements().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListStatementsResult clone() {
        try {
            return (ListStatementsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

