/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.glue.model;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.glue.model.ColumnImportance;
import com.simba.athena.amazonaws.services.glue.model.ConfusionMatrix;
import com.simba.athena.amazonaws.services.glue.model.transform.FindMatchesMetricsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FindMatchesMetrics
implements Serializable,
Cloneable,
StructuredPojo {
    private Double areaUnderPRCurve;
    private Double precision;
    private Double recall;
    private Double f1;
    private ConfusionMatrix confusionMatrix;
    private List<ColumnImportance> columnImportances;

    public void setAreaUnderPRCurve(Double areaUnderPRCurve) {
        this.areaUnderPRCurve = areaUnderPRCurve;
    }

    public Double getAreaUnderPRCurve() {
        return this.areaUnderPRCurve;
    }

    public FindMatchesMetrics withAreaUnderPRCurve(Double areaUnderPRCurve) {
        this.setAreaUnderPRCurve(areaUnderPRCurve);
        return this;
    }

    public void setPrecision(Double precision) {
        this.precision = precision;
    }

    public Double getPrecision() {
        return this.precision;
    }

    public FindMatchesMetrics withPrecision(Double precision) {
        this.setPrecision(precision);
        return this;
    }

    public void setRecall(Double recall) {
        this.recall = recall;
    }

    public Double getRecall() {
        return this.recall;
    }

    public FindMatchesMetrics withRecall(Double recall) {
        this.setRecall(recall);
        return this;
    }

    public void setF1(Double f1) {
        this.f1 = f1;
    }

    public Double getF1() {
        return this.f1;
    }

    public FindMatchesMetrics withF1(Double f1) {
        this.setF1(f1);
        return this;
    }

    public void setConfusionMatrix(ConfusionMatrix confusionMatrix) {
        this.confusionMatrix = confusionMatrix;
    }

    public ConfusionMatrix getConfusionMatrix() {
        return this.confusionMatrix;
    }

    public FindMatchesMetrics withConfusionMatrix(ConfusionMatrix confusionMatrix) {
        this.setConfusionMatrix(confusionMatrix);
        return this;
    }

    public List<ColumnImportance> getColumnImportances() {
        return this.columnImportances;
    }

    public void setColumnImportances(Collection<ColumnImportance> columnImportances) {
        if (columnImportances == null) {
            this.columnImportances = null;
            return;
        }
        this.columnImportances = new ArrayList<ColumnImportance>(columnImportances);
    }

    public FindMatchesMetrics withColumnImportances(ColumnImportance ... columnImportances) {
        if (this.columnImportances == null) {
            this.setColumnImportances(new ArrayList<ColumnImportance>(columnImportances.length));
        }
        for (ColumnImportance ele : columnImportances) {
            this.columnImportances.add(ele);
        }
        return this;
    }

    public FindMatchesMetrics withColumnImportances(Collection<ColumnImportance> columnImportances) {
        this.setColumnImportances(columnImportances);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAreaUnderPRCurve() != null) {
            sb.append("AreaUnderPRCurve: ").append(this.getAreaUnderPRCurve()).append(",");
        }
        if (this.getPrecision() != null) {
            sb.append("Precision: ").append(this.getPrecision()).append(",");
        }
        if (this.getRecall() != null) {
            sb.append("Recall: ").append(this.getRecall()).append(",");
        }
        if (this.getF1() != null) {
            sb.append("F1: ").append(this.getF1()).append(",");
        }
        if (this.getConfusionMatrix() != null) {
            sb.append("ConfusionMatrix: ").append(this.getConfusionMatrix()).append(",");
        }
        if (this.getColumnImportances() != null) {
            sb.append("ColumnImportances: ").append(this.getColumnImportances());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindMatchesMetrics)) {
            return false;
        }
        FindMatchesMetrics other = (FindMatchesMetrics)obj;
        if (other.getAreaUnderPRCurve() == null ^ this.getAreaUnderPRCurve() == null) {
            return false;
        }
        if (other.getAreaUnderPRCurve() != null && !other.getAreaUnderPRCurve().equals(this.getAreaUnderPRCurve())) {
            return false;
        }
        if (other.getPrecision() == null ^ this.getPrecision() == null) {
            return false;
        }
        if (other.getPrecision() != null && !other.getPrecision().equals(this.getPrecision())) {
            return false;
        }
        if (other.getRecall() == null ^ this.getRecall() == null) {
            return false;
        }
        if (other.getRecall() != null && !other.getRecall().equals(this.getRecall())) {
            return false;
        }
        if (other.getF1() == null ^ this.getF1() == null) {
            return false;
        }
        if (other.getF1() != null && !other.getF1().equals(this.getF1())) {
            return false;
        }
        if (other.getConfusionMatrix() == null ^ this.getConfusionMatrix() == null) {
            return false;
        }
        if (other.getConfusionMatrix() != null && !other.getConfusionMatrix().equals(this.getConfusionMatrix())) {
            return false;
        }
        if (other.getColumnImportances() == null ^ this.getColumnImportances() == null) {
            return false;
        }
        return other.getColumnImportances() == null || other.getColumnImportances().equals(this.getColumnImportances());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAreaUnderPRCurve() == null ? 0 : this.getAreaUnderPRCurve().hashCode());
        hashCode = 31 * hashCode + (this.getPrecision() == null ? 0 : this.getPrecision().hashCode());
        hashCode = 31 * hashCode + (this.getRecall() == null ? 0 : this.getRecall().hashCode());
        hashCode = 31 * hashCode + (this.getF1() == null ? 0 : this.getF1().hashCode());
        hashCode = 31 * hashCode + (this.getConfusionMatrix() == null ? 0 : this.getConfusionMatrix().hashCode());
        hashCode = 31 * hashCode + (this.getColumnImportances() == null ? 0 : this.getColumnImportances().hashCode());
        return hashCode;
    }

    public FindMatchesMetrics clone() {
        try {
            return (FindMatchesMetrics)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FindMatchesMetricsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

