/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.athena.model.transform;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.MarshallLocation;
import com.simba.athena.amazonaws.protocol.MarshallingInfo;
import com.simba.athena.amazonaws.protocol.MarshallingType;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.services.athena.model.PreparedStatement;
import java.util.Date;

@SdkInternalApi
public class PreparedStatementMarshaller {
    private static final MarshallingInfo<String> STATEMENTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatementName").build();
    private static final MarshallingInfo<String> QUERYSTATEMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryStatement").build();
    private static final MarshallingInfo<String> WORKGROUPNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkGroupName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final PreparedStatementMarshaller instance = new PreparedStatementMarshaller();

    public static PreparedStatementMarshaller getInstance() {
        return instance;
    }

    public void marshall(PreparedStatement preparedStatement, ProtocolMarshaller protocolMarshaller) {
        if (preparedStatement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(preparedStatement.getStatementName(), STATEMENTNAME_BINDING);
            protocolMarshaller.marshall(preparedStatement.getQueryStatement(), QUERYSTATEMENT_BINDING);
            protocolMarshaller.marshall(preparedStatement.getWorkGroupName(), WORKGROUPNAME_BINDING);
            protocolMarshaller.marshall(preparedStatement.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(preparedStatement.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

