/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.auth;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.annotation.SdkTestInternalApi;
import com.simba.athena.amazonaws.auth.BaseCredentialsFetcher;
import com.simba.athena.amazonaws.internal.EC2ResourceFetcher;
import com.simba.athena.amazonaws.internal.InstanceMetadataServiceResourceFetcher;
import com.simba.athena.amazonaws.retry.internal.CredentialsEndpointRetryParameters;
import com.simba.athena.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;
import com.simba.athena.amazonaws.util.EC2MetadataUtils;
import java.net.URI;

@SdkInternalApi
final class InstanceMetadataServiceCredentialsFetcher
extends BaseCredentialsFetcher
implements CredentialsEndpointRetryPolicy {
    private final EC2ResourceFetcher resourceFetcher;

    InstanceMetadataServiceCredentialsFetcher() {
        super(true);
        this.resourceFetcher = InstanceMetadataServiceResourceFetcher.getInstance();
    }

    @SdkTestInternalApi
    InstanceMetadataServiceCredentialsFetcher(EC2ResourceFetcher resourceFetcher) {
        super(true);
        this.resourceFetcher = resourceFetcher;
    }

    @Override
    protected String getCredentialsResponse() {
        URI credentialsEndpoint = this.getCredentialsEndpoint();
        return this.resourceFetcher.readResource(credentialsEndpoint, this);
    }

    @Override
    public String toString() {
        return "InstanceMetadataServiceCredentialsFetcher";
    }

    private URI getCredentialsEndpoint() {
        String host = EC2MetadataUtils.getHostAddressForEC2MetadataService();
        String securityCredentialsList = this.resourceFetcher.readResource(URI.create(host + "/latest/meta-data/iam/security-credentials/"), this);
        String[] securityCredentials = securityCredentialsList.trim().split("\n");
        if (securityCredentials.length == 0) {
            throw new SdkClientException("Unable to load credentials path");
        }
        return URI.create(host + "/latest/meta-data/iam/security-credentials/" + securityCredentials[0]);
    }

    @Override
    public boolean shouldRetry(int retriesAttempted, CredentialsEndpointRetryParameters retryParams) {
        return false;
    }
}

