/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.complex.Version;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.ucanaccess.commands.AbstractCursorCommand;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.commands.IndexSelector;
import net.ucanaccess.complex.Attachment;
import net.ucanaccess.complex.ComplexBase;
import net.ucanaccess.complex.SingleValue;
import net.ucanaccess.converters.Persist2Jet;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import org.hsqldb.types.BlobData;

public class UpdateCommand
extends AbstractCursorCommand {
    private List<Column> blobColumns;
    private String execId;
    private IndexSelector indexSelector;
    private Object[] modifiedRow;
    private Map<String, Object> rowPattern;
    private Table table;
    private List<? extends Column> tableColumns;
    private boolean isRollbacking;

    public UpdateCommand(Table table, Map<String, Object> map, Object[] modifiedRow, String execId) {
        this.tableColumns = table.getColumns();
        this.indexSelector = new IndexSelector(table);
        this.rowPattern = map;
        this.modifiedRow = modifiedRow;
        this.execId = execId;
        this.checkBlob(modifiedRow);
        this.table = table;
    }

    private void checkBlob(Object[] newRow2) {
        for (int i = 0; i < newRow2.length; ++i) {
            if (!(newRow2[i] instanceof BlobData)) continue;
            if (this.blobColumns == null) {
                this.blobColumns = new ArrayList<Column>();
            }
            this.blobColumns.add(this.tableColumns.get(i));
        }
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public IndexSelector getIndexSelector() {
        return this.indexSelector;
    }

    @Override
    public Map<String, Object> getRowPattern() {
        return this.rowPattern;
    }

    @Override
    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public ICommand.TYPES getType() {
        return ICommand.TYPES.UPDATE;
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        try {
            Cursor cur = this.indexSelector.getCursor();
            if (cur.findNextRow(this.rowPattern)) {
                if (this.blobColumns != null) {
                    for (Column col : this.blobColumns) {
                        Object val;
                        this.modifiedRow[this.tableColumns.indexOf((Object)col)] = val = cur.getCurrentRowValue(col);
                    }
                }
                this.updateComplex(cur);
                this.persist(cur);
            }
        }
        catch (IOException e) {
            throw new UcanaccessSQLException(e);
        }
        return null;
    }

    @Override
    public void persistCurrentRow(Cursor cur) throws IOException, SQLException {
        if (this.blobColumns != null) {
            for (Column col : this.blobColumns) {
                Object val;
                this.modifiedRow[this.tableColumns.indexOf((Object)col)] = val = cur.getCurrentRowValue(col);
            }
        }
        this.updateComplex(cur);
        this.persist(cur);
    }

    private void updateComplex(Cursor cur) throws IOException {
        int j = 0;
        for (Column column : this.tableColumns) {
            if (column.getType() == DataType.COMPLEX_TYPE) {
                ComplexBase[] vs;
                ComplexValueForeignKey rowFk = (ComplexValueForeignKey)column.getRowValue((Map)cur.getCurrentRow());
                if (this.modifiedRow[j] instanceof Attachment[]) {
                    rowFk.deleteAllValues();
                    Attachment[] atcs = (Attachment[])this.modifiedRow[j];
                    for (ComplexBase complexBase : atcs) {
                        rowFk.addAttachment(((Attachment)complexBase).getUrl(), ((Attachment)complexBase).getName(), ((Attachment)complexBase).getType(), ((Attachment)complexBase).getData(), ((Attachment)complexBase).getTimeStamp(), ((Attachment)complexBase).getFlags());
                    }
                } else if (this.modifiedRow[j] instanceof SingleValue[]) {
                    rowFk.deleteAllValues();
                    vs = (SingleValue[])this.modifiedRow[j];
                    for (ComplexBase complexBase : vs) {
                        rowFk.addMultiValue(((SingleValue)complexBase).getValue());
                    }
                } else if (this.modifiedRow[j] instanceof net.ucanaccess.complex.Version[]) {
                    Date upTime;
                    vs = (net.ucanaccess.complex.Version[])this.modifiedRow[j];
                    ComplexBase v = vs[0];
                    List oldV = rowFk.getVersions();
                    String vn = ((net.ucanaccess.complex.Version)v).getValue();
                    String string = oldV.size() > 0 ? ((Version)oldV.get(0)).getValue() : null;
                    Date date = upTime = this.isRollbacking ? new Date() : ((net.ucanaccess.complex.Version)v).getModifiedDate();
                    if (vn != null && string == null || string != null && vn == null || string != null && vn != null && !string.equals(vn)) {
                        rowFk.addVersion(vn, upTime);
                    }
                }
            }
            ++j;
        }
    }

    @Override
    public IFeedbackAction rollback() throws SQLException {
        Persist2Jet p2a = new Persist2Jet();
        UpdateCommand urev = new UpdateCommand(this.table, p2a.getRowPattern(this.modifiedRow, this.table), p2a.getValues(this.getRowPattern(), this.table), this.execId);
        urev.isRollbacking = true;
        return urev.persist();
    }

    private void persist(Cursor cur) throws IOException, SQLException {
        Object[] mr = this.modifiedRow;
        if (this.table.getDatabase().getColumnOrder().equals((Object)Table.ColumnOrder.DISPLAY)) {
            Object[] newRowReorded = new Object[this.modifiedRow.length];
            int j = 0;
            for (Column cli : this.table.getColumns()) {
                newRowReorded[cli.getColumnIndex()] = this.modifiedRow[j];
                ++j;
            }
            mr = newRowReorded;
        }
        cur.updateCurrentRow(mr);
    }
}

