/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.wmi.service;

import org.jkiss.wmi.service.WMIObject;
import org.jkiss.wmi.service.WMIObjectElement;

public class WMIObjectAttribute
extends WMIObjectElement {
    private int type;
    private int flavor;
    private Object value;

    public WMIObjectAttribute(WMIObject owner, String name, int type, int flavor, Object value) {
        super(owner, name);
        this.type = type;
        this.flavor = flavor;
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public int getFlavor() {
        return this.flavor;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isSystem() {
        return this.getName().startsWith("__");
    }

    public String toString() {
        return String.valueOf(this.getName()) + "=" + this.value;
    }

    public String getTypeName() {
        int type = this.getType();
        if ((type & 0x2000) != 0) {
            return String.valueOf(WMIObjectAttribute.getCIMTypeName(type ^ 0x2000)) + "[]";
        }
        return WMIObjectAttribute.getCIMTypeName(type);
    }

    public static String getCIMTypeName(int type) {
        switch (type) {
            case 4095: {
                return "Illegal";
            }
            case 0: {
                return "Empty";
            }
            case 16: {
                return "Int8";
            }
            case 17: {
                return "UInt8";
            }
            case 2: {
                return "Int16";
            }
            case 18: {
                return "UInt16";
            }
            case 3: {
                return "Int32";
            }
            case 19: {
                return "UInt32";
            }
            case 20: {
                return "Int64";
            }
            case 21: {
                return "UInt64";
            }
            case 4: {
                return "Real32";
            }
            case 5: {
                return "Real64";
            }
            case 11: {
                return "Boolean";
            }
            case 8: {
                return "String";
            }
            case 101: {
                return "DateTime";
            }
            case 102: {
                return "Reference";
            }
            case 103: {
                return "Char";
            }
            case 13: {
                return "Object";
            }
        }
        return "Unknown (" + type + ")";
    }
}

