/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.SupportedPlatform;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class SupportedPlatformStaxUnmarshaller
implements Unmarshaller<SupportedPlatform, StaxUnmarshallerContext> {
    private static SupportedPlatformStaxUnmarshaller instance;

    public SupportedPlatform unmarshall(StaxUnmarshallerContext context) throws Exception {
        SupportedPlatform supportedPlatform = new SupportedPlatform();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return supportedPlatform;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Name", targetDepth)) continue;
                supportedPlatform.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return supportedPlatform;
    }

    public static SupportedPlatformStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SupportedPlatformStaxUnmarshaller();
        }
        return instance;
    }
}

