/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest;
import com.amazonaws.services.redshift.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateSnapshotCopyGrantRequestMarshaller
implements Marshaller<Request<CreateSnapshotCopyGrantRequest>, CreateSnapshotCopyGrantRequest> {
    public Request<CreateSnapshotCopyGrantRequest> marshall(CreateSnapshotCopyGrantRequest createSnapshotCopyGrantRequest) {
        if (createSnapshotCopyGrantRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSnapshotCopyGrantRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateSnapshotCopyGrant");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSnapshotCopyGrantRequest.getSnapshotCopyGrantName() != null) {
            request.addParameter("SnapshotCopyGrantName", StringUtils.fromString((String)createSnapshotCopyGrantRequest.getSnapshotCopyGrantName()));
        }
        if (createSnapshotCopyGrantRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createSnapshotCopyGrantRequest.getKmsKeyId()));
        }
        if (!createSnapshotCopyGrantRequest.getTags().isEmpty() || !((SdkInternalList)createSnapshotCopyGrantRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createSnapshotCopyGrantRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

