/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.actions;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.internal.GEFMessages;
import org.eclipse.gef3.ui.actions.StackAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class RedoAction
extends StackAction {
    public RedoAction(IWorkbenchPart part) {
        super(part);
    }

    public RedoAction(IEditorPart editor) {
        super((IWorkbenchPart)editor);
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getCommandStack().canRedo();
    }

    @Override
    protected void init() {
        super.init();
        this.setToolTipText(MessageFormat.format((String)GEFMessages.RedoAction_Tooltip, (Object[])new Object[]{""}).trim());
        this.setText(MessageFormat.format((String)GEFMessages.RedoAction_Label, (Object[])new Object[]{""}).trim());
        this.setId(ActionFactory.REDO.getId());
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
    }

    @Override
    protected void refresh() {
        Command redoCmd = this.getCommandStack().getRedoCommand();
        this.setToolTipText(MessageFormat.format((String)GEFMessages.RedoAction_Tooltip, (Object[])new Object[]{this.getLabelForCommand(redoCmd)}).trim());
        this.setText(MessageFormat.format((String)GEFMessages.RedoAction_Label, (Object[])new Object[]{this.getLabelForCommand(redoCmd)}).trim());
        super.refresh();
    }

    public void run() {
        this.getCommandStack().redo();
    }
}

