/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.editparts;

import org.eclipse.draw2dl.ConnectionLayer;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Layer;
import org.eclipse.draw2dl.LayeredPane;
import org.eclipse.draw2dl.LayoutManager;
import org.eclipse.draw2dl.ScrollPane;
import org.eclipse.draw2dl.StackLayout;
import org.eclipse.draw2dl.Viewport;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.EditPartViewer;
import org.eclipse.gef3.LayerConstants;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.RootEditPart;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.commands.UnexecutableCommand;
import org.eclipse.gef3.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef3.editparts.LayerManager;
import org.eclipse.gef3.tools.MarqueeDragTracker;

public class GraphicalRootEditPart
extends AbstractGraphicalEditPart
implements RootEditPart,
LayerConstants,
LayerManager {
    protected EditPart contents;
    protected EditPartViewer viewer;
    private LayeredPane innerLayers;
    private LayeredPane printableLayers;

    @Override
    protected void createEditPolicies() {
    }

    @Override
    protected IFigure createFigure() {
        this.innerLayers = new LayeredPane();
        this.printableLayers = new LayeredPane();
        Layer layer = new Layer();
        layer.setLayoutManager((LayoutManager)new StackLayout());
        this.printableLayers.add((IFigure)layer, (Object)"Primary Layer");
        layer = new ConnectionLayer();
        layer.setPreferredSize(new Dimension(5, 5));
        this.printableLayers.add((IFigure)layer, (Object)"Connection Layer");
        this.innerLayers.add((IFigure)this.printableLayers, (Object)"Printable Layers");
        layer = new Layer();
        layer.setPreferredSize(new Dimension(5, 5));
        this.innerLayers.add((IFigure)layer, (Object)"Handle Layer");
        layer = new FeedbackLayer();
        layer.setPreferredSize(new Dimension(5, 5));
        this.innerLayers.add((IFigure)layer, (Object)"Feedback Layer");
        ScrollPane pane = new ScrollPane();
        pane.setViewport(new Viewport(true));
        pane.setContents((IFigure)this.innerLayers);
        return pane;
    }

    @Override
    public Command getCommand(Request req) {
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public EditPart getContents() {
        return this.contents;
    }

    @Override
    public DragTracker getDragTracker(Request req) {
        return new MarqueeDragTracker();
    }

    @Override
    public IFigure getLayer(Object key) {
        if (this.innerLayers == null) {
            return null;
        }
        Layer layer = this.printableLayers.getLayer(key);
        if (layer != null) {
            return layer;
        }
        return this.innerLayers.getLayer(key);
    }

    @Override
    public IFigure getContentPane() {
        return this.getLayer("Primary Layer");
    }

    @Override
    public Object getModel() {
        return LayerManager.ID;
    }

    @Override
    public RootEditPart getRoot() {
        return this;
    }

    @Override
    public EditPartViewer getViewer() {
        return this.viewer;
    }

    @Override
    protected void refreshChildren() {
    }

    @Override
    public void setContents(EditPart editpart) {
        if (this.contents != null) {
            this.removeChild(this.contents);
        }
        this.contents = editpart;
        if (this.contents != null) {
            this.addChild(this.contents, 0);
        }
    }

    @Override
    public void setViewer(EditPartViewer newViewer) {
        if (this.viewer == newViewer) {
            return;
        }
        if (this.viewer != null) {
            this.unregister();
        }
        this.viewer = newViewer;
        if (this.viewer != null) {
            this.register();
        }
    }

    class FeedbackLayer
    extends Layer {
        FeedbackLayer() {
            this.setEnabled(false);
        }
    }
}

