/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.interceptor;

import com.dbeaver.remote.client.AbstractRemoteClient;
import java.io.IOException;
import java.net.ConnectException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;

public class RetryRequestInterceptor
implements Interceptor {
    private static final Log log = Log.getLog(RetryRequestInterceptor.class);
    private static final int BAD_GATEWAY = 502;
    private static final int BAD_GATEWAY_TIMEOUT = 504;
    private final AbstractRemoteClient remoteClient;
    private final int retryCount;
    private final String apiUrl;

    public RetryRequestInterceptor(AbstractRemoteClient remoteClient, int retryCount, String apiUrl) {
        this.remoteClient = remoteClient;
        this.retryCount = retryCount;
        this.apiUrl = apiUrl;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.remoteClient.isOmitRequestRetry(request.url().url())) {
            return chain.proceed(request);
        }
        int tryCount = 0;
        Response response = null;
        while (tryCount < this.retryCount) {
            try {
                ++tryCount;
                if (response != null) {
                    response.close();
                }
                if ((response = chain.proceed(request)).code() != 502 && response.code() != 504) {
                    return response;
                }
            }
            catch (ConnectException connectException) {}
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Failed execute request ").append(tryCount).append(" times: ").append(request);
            if (response != null) {
                errorMessage.append("\nResponse: " + response);
            }
            log.debug((Object)errorMessage);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (response != null) {
            response.close();
        }
        throw new IOException("Server is not available: " + this.apiUrl);
    }
}

